/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.io.callbacks;

import android.text.TextUtils;

import org.json.JSONObject;

import java.util.ArrayList;

import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.NewCampaign;
import ly.warp.sdk.io.models.NewCampaignList;
import ly.warp.sdk.utils.WarpJSONParser;

/**
 * Created by Panagiotis Triantafyllou on 12-May-22.
 */

public class NewCampaignsHook implements CallbackReceiver<JSONObject> {

    private final CallbackReceiver<ArrayList<Campaign>> mListener;
    private final String mRequestSignature;

    public NewCampaignsHook(CallbackReceiver<ArrayList<Campaign>> listener, String requestSignature) {
        this.mListener = listener;
        this.mRequestSignature = requestSignature;
    }

    @Override
    public void onSuccess(JSONObject result) {
        if (mListener != null) {
            int status = result.optInt("status", 2);
            if (status == 1) {
                NewCampaignList cmpList = new NewCampaignList(result, mRequestSignature);
                ArrayList<Campaign> tempCampaigns = new ArrayList<>();
                for (NewCampaign newCamp : cmpList) {
                    Campaign camp = new Campaign();
                    camp.setIndexUrl(newCamp.getIndexUrl());
                    camp.setLogoUrl(newCamp.getLogoUrl());
                    camp.setMessage(newCamp.getMessage());
                    camp.setOfferCategory(newCamp.getCommunicationCategory());
                    camp.setSessionUUID(newCamp.getCommunicationUUID());
                    camp.setTitle(newCamp.getTitle());
                    camp.setSubtitle(newCamp.getSubtitle());
                    camp.setSorting(newCamp.getSorting());
                    camp.setNew(newCamp.getIsNew());
                    camp.setType(newCamp.getCampaignType());
                    try {
                        camp.setExtraFields(newCamp.getExtraFields().toString());
                        if (!TextUtils.isEmpty(newCamp.getExtraFields().toString())) {
                            JSONObject extraFieldsResp = WarpJSONParser.getJSONFromString(newCamp.getExtraFields().toString());
                            if (extraFieldsResp != null) {
                                if (extraFieldsResp.has("Banner_title")) {
                                    camp.setBannerTitle(extraFieldsResp.optString("Banner_title", ""));
                                }
                                if (extraFieldsResp.has("Banner_img")) {
                                    camp.setBannerImage(extraFieldsResp.optString("Banner_img", ""));
                                }
                            }
                        } else {
                            camp.setBannerImage("");
                            camp.setBannerTitle("");
                        }
                    } catch (NullPointerException e) {
                        camp.setExtraFields("");
                        camp.setBannerImage("");
                        camp.setBannerTitle("");
                        e.printStackTrace();
                    }

                    try {
                        camp.setCampaignTypeSettings(newCamp.getSettings().toString());
                    } catch (NullPointerException e) {
                        camp.setCampaignTypeSettings("");
                        e.printStackTrace();
                    }
                    tempCampaigns.add(camp);
                }
                mListener.onSuccess(tempCampaigns);
            } else
                mListener.onFailure(status);
        }

    }

    @Override
    public void onFailure(int errorCode) {
        if (mListener != null)
            mListener.onFailure(errorCode);
    }
}
