/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.io.callbacks;

import java.util.ArrayList;

import org.json.JSONObject;

import android.content.Context;

import ly.warp.sdk.Warply;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.utils.WarpUtils;

public class PostHook implements CallbackReceiver<JSONObject> {

    private ArrayList<Long> mIds, mIdsPush, mIdsPushAck;
    private final Context mContext;
    private boolean mIsPushResponse = false;
    private boolean mIsPushAckResponse = false;

    public PostHook(Context context, ArrayList<Long> ids) {
        mContext = context;
        mIds = ids;
    }

    public PostHook(Context context, ArrayList<Long> ids, boolean isPushResponse) {
        mContext = context;
        mIdsPush = ids;
        mIsPushResponse = isPushResponse;
    }

    public PostHook(Context context, ArrayList<Long> ids, boolean placeholder, boolean isPushAck) {
        mContext = context;
        mIdsPushAck = ids;
        mIsPushAckResponse = isPushAck;
    }

    @Override
    public void onSuccess(JSONObject result) {
        WarpUtils.log("************* WARPLY Database ********************");
        WarpUtils.log("[WARP Trace] Successful Post, emptying database");
        WarpUtils.log("**************************************************");

        if (mIsPushResponse || mIsPushAckResponse) {
            if (mIsPushResponse) {
                WarplyDBHelper.getInstance(mContext).deletePushRequests(
                        mIdsPush.toArray(new Long[mIdsPush.size()]));
                mIsPushResponse = false;
                WarpUtils.log("[WARP Trace] Database Push Requests cleared");
                WarpUtils.log("**************************************************");
            }
            if (mIsPushAckResponse) {
                WarplyDBHelper.getInstance(mContext).deletePushAckRequests(
                        mIdsPushAck.toArray(new Long[mIdsPushAck.size()]));
                mIsPushAckResponse = false;
                WarpUtils.log("[WARP Trace] Database Push Ack Requests cleared");
                WarpUtils.log("**************************************************");
            }
        } else {
            WarplyDBHelper.getInstance(mContext).deleteRequests(
                    mIds.toArray(new Long[mIds.size()]));
        }
        Warply.releasePostLock();
        Warply.tryWakingSendingTask();
    }

    @Override
    public void onFailure(int errorCode) {
        WarpUtils.log("************* WARPLY Database ********************");
        WarpUtils.log("[WARP Trace] Post to context failed with error: "
                + errorCode);
        WarpUtils.log("**************************************************");

        Warply.releasePostLock();
    }

}
