package ly.warp.sdk.io.models;


import android.util.Base64;

import org.altbeacon.beacon.Beacon;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import ly.warp.sdk.utils.constants.WarpConstants;

public class BeaconMessage {

    // ===========================================================
    // Constants
    // ===========================================================

    private final String KEY_UUID = "uuid";
    private final String KEY_MAJOR = "major";
    private final String KEY_MINOR = "minor";
    private final String KEY_DISTANCE = "distance";
    private final String KEY_ACTION = "action";
    private final String KEY_DATA = "data";
    private final String ACTION_BEACON = "beacon";

    // ===========================================================
    // Fields
    // ===========================================================

    private String uuid, major, minor;
    private double distance;

    // ===========================================================
    // Constructor
    // ===========================================================

    public BeaconMessage(Beacon beacon) {

        if (beacon != null) {
            uuid = beacon.getId1().toUuid().toString();
            major = beacon.getId2().toString();
            minor = beacon.getId3().toString();
            distance = beacon.getDistance();
            /*beacon.getTxPower();
            beacon.getManufacturer();
            beacon.getBeaconTypeCode();*/
        }
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    // ===========================================================
    // Methods
    // ===========================================================

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    public JSONObject toJson() {

        JSONObject json = new JSONObject();
        try {

            JSONObject beaconMessageJson = new JSONObject();
            beaconMessageJson.putOpt(KEY_UUID, uuid);
            beaconMessageJson.putOpt(KEY_MAJOR, major);
            beaconMessageJson.putOpt(KEY_MINOR, minor);
            beaconMessageJson.putOpt(KEY_DISTANCE, distance);

            JSONArray dataJsonArray = new JSONArray();
            dataJsonArray.put(beaconMessageJson);
            json.putOpt(KEY_DATA, dataJsonArray);
            json.putOpt(KEY_ACTION, ACTION_BEACON);

        } catch (JSONException e) {
            if (WarpConstants.DEBUG)
                e.printStackTrace();
        }

        return json;
    }

    public String getSignature() {

        String signature = uuid + major + minor;
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString(hash, Base64.NO_WRAP);
        } catch (NullPointerException | NoSuchAlgorithmException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }
}
