/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.io.models;

import android.os.Parcel;
import android.os.Parcelable;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 26-03-2019
 */

public class CampaignAction implements Parcelable, Serializable {

    private static final String SORTING = "sorting";
    private static final String DISPLAY_NAME = "display_name";
    private static final String ACTION_NAME = "action_name";
    private static final String DATA = "data";

    private int sorting;
    private String displayName;
    private String actionName;
    private String data;

    public CampaignAction(String json) throws JSONException {
        this(new JSONObject(json));
    }

    public CampaignAction(JSONObject json) {
        this.sorting = json.optInt(SORTING);
        this.displayName = json.optString(DISPLAY_NAME);
        this.actionName = json.optString(ACTION_NAME);
        this.data = json.optJSONObject(DATA).toString();
    }

    public CampaignAction(Parcel source) {
        this.sorting = source.readInt();
        this.displayName = source.readString();
        this.actionName = source.readString();
        this.data = source.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.sorting);
        dest.writeString(this.displayName);
        dest.writeString(this.actionName);
        dest.writeString(this.data);
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.putOpt(SORTING, this.sorting);
            jObj.putOpt(DISPLAY_NAME, this.displayName);
            jObj.putOpt(ACTION_NAME, this.actionName);
            jObj.putOpt(DATA, this.data);
        } catch (JSONException e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
        }
        return jObj;
    }

    public String toString() {
        if (toJSONObject() != null)
            return toJSONObject().toString();
        return null;
    }

    // ================================================================================
    // Getters
    // ================================================================================

    public int getSorting() {
        return sorting;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getActionName() {
        return actionName;
    }

    public JSONObject getData() throws JSONException {
        return new JSONObject(data);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ly.warp.sdk.io.models.CampaignAction> CREATOR = new Creator<ly.warp.sdk.io.models.CampaignAction>() {
        public ly.warp.sdk.io.models.CampaignAction createFromParcel(Parcel source) {
            return new ly.warp.sdk.io.models.CampaignAction(source);
        }

        public ly.warp.sdk.io.models.CampaignAction[] newArray(int size) {
            return new ly.warp.sdk.io.models.CampaignAction[size];
        }
    };
}
