/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.io.models;

import android.os.Parcel;
import android.os.Parcelable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 04-Jan-22.
 */

public class Consumer implements Parcelable, Serializable {

    private static final long serialVersionUID = -4754964462459705285L;

    /* Constants used to export the campaign in JSON formal and vice versa */

    private static final String ACK_OPTIN = "ack_optin";
    private static final String BILLING_INFO = "billing_info";
    private static final String BIRTHDAY = "birthday";
    private static final String BURNT_POINTS = "burnt_points";
    private static final String COMPANY_NAME = "company_name";
    private static final String CONSUMER_METADATA = "consumer_metadata";
    private static final String DISPLAY_NAME = "display_name";
    private static final String EMAIL = "email";
    private static final String FIRST_NAME = "firstname";
    private static final String GENDER = "gender";
    private static final String IMAGE_URL = "image_url";
    private static final String LANGUAGE = "language";
    private static final String LAST_NAME = "lastname";
    private static final String LOYALTY_ID = "loyalty_id";
    private static final String MSISDN = "msisdn";
    private static final String NAMEDAY = "nameday";
    private static final String NICKNAME = "nickname";
    private static final String OPTIN = "optin";
    private static final String PASSWORD_SET = "password_set";
    private static final String PROFILE_METADATA = "profile_metadata";
    private static final String REDEEMED_POINTS = "redeemed_points";
    private static final String RETRIEVED_POINTS = "retrieved_points";
    private static final String SALUTATION = "salutation";
    private static final String SUBSCRIBE = "subscribe";
    private static final String TAGS = "tags";
    private static final String TAX_ID = "tax_id";
    private static final String USER_POINTS = "user_points";
    private static final String UUID = "uuid";
    private static final String VERIFIED = "verified";
    private static final String KEY_NEWSLETTER = "newsletter";
    private static final String KEY_SMS = "sms";
    private static final String KEY_PERSON_NEWSLETTER = "segmentation";
    private static final String KEY_PERSON_SMS = "sms_segmentation";

    /* Member variables of the Campaign object */

    private boolean ackOptin = false;
    private JSONObject billingInfo = new JSONObject();
    private String birthday = "";
    private double burntPoints = 0.0d;
    private String companyName = "";
    private JSONObject consumerMetadata = new JSONObject();
    private String displayName = "";
    private String email = "";
    private String firstName = "";
    private String gender = "";
    private String imageUrl = "";
    private String language = "";
    private String lastName = "";
    private String loyaltyId = "";
    private String msisdn = "";
    private String nameday = "";
    private String nickname = "";
    private JSONObject optin = new JSONObject();
    private boolean passwordSet = false;
    private String profileMetadata = "";
    private double redeemedPoints = 0.0d;
    private double retrievedPoints = 0.0d;
    private String salutation = "";
    private boolean subscribe = false;
    private JSONObject tags = new JSONObject();
    private String taxId = "";
    private double userPoints = 0.0d;
    private String uuid = "";
    private boolean verified = false;
    private boolean newsletter = false;
    private boolean sms = false;
    private boolean segmentation = false;
    private boolean sms_segmentation = false;

    /**
     * Basic constructor used to create an object from a String, representing a
     * JSON Object
     *
     * @param json The String, representing the JSON Object
     * @throws JSONException Thrown if the String cannot be converted to JSON
     */
    public Consumer(String json) throws JSONException {
        this(new JSONObject(json));
    }

    public Consumer() {
        this.ackOptin = false;
        this.billingInfo = new JSONObject();
        this.birthday = "";
        this.burntPoints = 0.0d;
        this.companyName = "";
        this.consumerMetadata = new JSONObject();
        this.displayName = "";
        this.email = "";
        this.firstName = "";
        this.gender = "";
        this.imageUrl = "";
        this.language = "";
        this.lastName ="";
        this.loyaltyId = "";
        this.msisdn = "";
        this.nameday = "";
        this.nickname = "";
        this.optin = new JSONObject();
        if (this.optin != null) {
            this.newsletter = false;
            this.sms = false;
            this.segmentation = false;
            this.sms_segmentation = false;
        }
        this.passwordSet = false;
        this.profileMetadata = "";
        this.redeemedPoints = 0.0d;
        this.retrievedPoints = 0.0d;
        this.salutation = "";
        this.subscribe = false;
        this.tags = new JSONObject();
        this.taxId = "";
        this.userPoints = 0.0d;
        this.uuid = "";
        this.verified = false;
    }

    /**
     * Constructor used to create an Object from a given JSON Object
     *
     * @param json JSON Object used to create the Consumer
     */
    public Consumer(JSONObject json) {
        if (json != null) {
            this.ackOptin = json.optBoolean(ACK_OPTIN);
            this.billingInfo = json.optJSONObject(BILLING_INFO);
            this.birthday = json.optString(BIRTHDAY);
            this.burntPoints = json.optDouble(BURNT_POINTS);
            this.companyName = json.optString(COMPANY_NAME);
            this.consumerMetadata = json.optJSONObject(CONSUMER_METADATA);
            this.displayName = json.optString(DISPLAY_NAME);
            this.email = json.optString(EMAIL);
            this.firstName = json.optString(FIRST_NAME);
            this.gender = json.optString(GENDER);
            this.imageUrl = json.optString(IMAGE_URL);
            this.language = json.optString(LANGUAGE);
            this.lastName = json.optString(LAST_NAME);
            this.loyaltyId = json.optString(LOYALTY_ID);
            this.msisdn = json.optString(MSISDN);
            this.nameday = json.optString(NAMEDAY);
            this.nickname = json.optString(NICKNAME);
            this.optin = json.optJSONObject(OPTIN);
            if (this.optin != null) {
                this.newsletter = this.optin.optBoolean(KEY_NEWSLETTER);
                this.sms = this.optin.optBoolean(KEY_SMS);
                this.segmentation = this.optin.optBoolean(KEY_PERSON_NEWSLETTER);
                this.sms_segmentation = this.optin.optBoolean(KEY_PERSON_SMS);
            }
            this.passwordSet = json.optBoolean(PASSWORD_SET);
            this.profileMetadata = json.optString(PROFILE_METADATA);
            this.redeemedPoints = json.optDouble(REDEEMED_POINTS);
            this.retrievedPoints = json.optDouble(RETRIEVED_POINTS);
            this.salutation = json.optString(SALUTATION);
            this.subscribe = json.optBoolean(SUBSCRIBE);
            this.tags = json.optJSONObject(TAGS);
            this.taxId = json.optString(TAX_ID);
            this.userPoints = json.optDouble(USER_POINTS);
            this.uuid = json.optString(UUID);
            this.verified = json.optBoolean(VERIFIED);
        }
    }

    public Consumer(Parcel source) {
        this.ackOptin = source.readByte() != 0;
        this.birthday = source.readString();
        this.burntPoints = source.readDouble();
        this.companyName = source.readString();
        this.displayName = source.readString();
        this.email = source.readString();
        this.firstName = source.readString();
        this.gender = source.readString();
        this.imageUrl = source.readString();
        this.language = source.readString();
        this.lastName = source.readString();
        this.loyaltyId = source.readString();
        this.msisdn = source.readString();
        this.nameday = source.readString();
        this.nickname = source.readString();
        this.newsletter = source.readByte() != 0;
        this.sms = source.readByte() != 0;
        this.segmentation = source.readByte() != 0;
        this.sms_segmentation = source.readByte() != 0;
        this.passwordSet = source.readByte() != 0;
        this.redeemedPoints = source.readDouble();
        this.retrievedPoints = source.readDouble();
        this.salutation = source.readString();
        this.subscribe = source.readByte() != 0;
        this.taxId = source.readString();
        this.userPoints = source.readDouble();
        this.uuid = source.readString();
        this.verified = source.readByte() != 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte) (this.ackOptin ? 1 : 0));
        dest.writeString(this.birthday);
        dest.writeDouble(this.burntPoints);
        dest.writeString(this.companyName);
        dest.writeString(this.displayName);
        dest.writeString(this.email);
        dest.writeString(this.firstName);
        dest.writeString(this.gender);
        dest.writeString(this.imageUrl);
        dest.writeString(this.language);
        dest.writeString(this.lastName);
        dest.writeString(this.loyaltyId);
        dest.writeString(this.msisdn);
        dest.writeString(this.nameday);
        dest.writeString(this.nickname);
        dest.writeByte((byte) (this.newsletter ? 1 : 0));
        dest.writeByte((byte) (this.sms ? 1 : 0));
        dest.writeByte((byte) (this.segmentation ? 1 : 0));
        dest.writeByte((byte) (this.sms_segmentation ? 1 : 0));
        dest.writeByte((byte) (this.passwordSet ? 1 : 0));
        dest.writeDouble(this.redeemedPoints);
        dest.writeDouble(this.retrievedPoints);
        dest.writeString(this.salutation);
        dest.writeByte((byte) (this.subscribe ? 1 : 0));
        dest.writeString(this.taxId);
        dest.writeDouble(this.userPoints);
        dest.writeString(this.uuid);
        dest.writeByte((byte) (this.verified ? 1 : 0));
    }

    /**
     * Converts the Consumer into a JSON Object
     *
     * @return The JSON Object created from this Consumer
     */
    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.putOpt(ACK_OPTIN, this.ackOptin);
            jObj.putOpt(BIRTHDAY, this.birthday);
            jObj.putOpt(BURNT_POINTS, this.burntPoints);
            jObj.putOpt(COMPANY_NAME, this.companyName);
            jObj.putOpt(DISPLAY_NAME, this.displayName);
            jObj.putOpt(EMAIL, this.email);
            jObj.putOpt(FIRST_NAME, this.firstName);
            jObj.putOpt(GENDER, this.gender);
            jObj.putOpt(IMAGE_URL, this.imageUrl);
            jObj.putOpt(LANGUAGE, this.language);
            jObj.putOpt(LAST_NAME, this.lastName);
            jObj.putOpt(LOYALTY_ID, this.loyaltyId);
            jObj.putOpt(MSISDN, this.msisdn);
            jObj.putOpt(NAMEDAY, this.nameday);
            jObj.putOpt(NICKNAME, this.nickname);
            JSONObject optinOnj = new JSONObject();
            optinOnj.putOpt(KEY_NEWSLETTER, this.newsletter);
            optinOnj.putOpt(KEY_SMS, this.sms);
            optinOnj.putOpt(KEY_PERSON_NEWSLETTER, this.segmentation);
            optinOnj.putOpt(KEY_PERSON_SMS, this.sms_segmentation);
            jObj.putOpt(OPTIN, optinOnj);
            jObj.putOpt(PASSWORD_SET, this.passwordSet);
            jObj.putOpt(REDEEMED_POINTS, this.redeemedPoints);
            jObj.putOpt(RETRIEVED_POINTS, this.retrievedPoints);
            jObj.putOpt(SALUTATION, this.salutation);
            jObj.putOpt(SUBSCRIBE, this.subscribe);
            jObj.putOpt(TAX_ID, this.taxId);
            jObj.putOpt(USER_POINTS, this.userPoints);
            jObj.putOpt(UUID, this.uuid);
            jObj.putOpt(VERIFIED, this.verified);
        } catch (JSONException e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
        }
        return jObj;
    }

    /**
     * String representation of the Consumer, as a JSON object
     *
     * @return A String representation of JSON object
     */
    public String toString() {
        if (toJSONObject() != null)
            return toJSONObject().toString();
        return null;
    }

    /**
     * String representation of the Consumer, as a human readable JSON object
     *
     * @return A human readable String representation of JSON object
     */
    public String toHumanReadableString() {
        String humanReadableString = null;
        try {
            humanReadableString = toJSONObject().toString(2);
        } catch (JSONException e) {
            WarpUtils.warn("Failed converting Consumer JSON object to String", e);
        }
        return humanReadableString;
    }

    // ================================================================================
    // Getters
    // ================================================================================


    public boolean isAckOptin() {
        return ackOptin;
    }

    public JSONObject getBillingInfo() {
        return billingInfo;
    }

    public String getBirthday() {
        return birthday;
    }

    public double getBurntPoints() {
        return burntPoints;
    }

    public String getCompanyName() {
        return companyName;
    }

    public JSONObject getConsumerMetadata() {
        return consumerMetadata;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getEmail() {
        return email;
    }

    public String getFirstName() {
        return firstName;
    }

    public String getGender() {
        return gender;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public String getLanguage() {
        return language;
    }

    public String getLastName() {
        return lastName;
    }

    public String getLoyaltyId() {
        return loyaltyId;
    }

    public String getMsisdn() {
        return msisdn;
    }

    public String getNameday() {
        return nameday;
    }

    public String getNickname() {
        return nickname;
    }

    public JSONObject getOptin() {
        return optin;
    }

    public boolean isPasswordSet() {
        return passwordSet;
    }

    public String getProfileMetadata() {
        return profileMetadata;
    }

    public double getRedeemedPoints() {
        return redeemedPoints;
    }

    public double getRetrievedPoints() {
        return retrievedPoints;
    }

    public String getSalutation() {
        return salutation;
    }

    public boolean isSubscribe() {
        return subscribe;
    }

    public JSONObject getTags() {
        return tags;
    }

    public String getTaxId() {
        return taxId;
    }

    public double getUserPoints() {
        return userPoints;
    }

    public String getUuid() {
        return uuid;
    }

    public boolean isVerified() {
        return verified;
    }

    public boolean isNewsletter() {
        return newsletter;
    }

    public boolean isSms() {
        return sms;
    }

    public boolean isSegmentation() {
        return segmentation;
    }

    public boolean isSms_segmentation() {
        return sms_segmentation;
    }

    public void setAckOptin(boolean ackOptin) {
        this.ackOptin = ackOptin;
    }

    public void setBillingInfo(JSONObject billingInfo) {
        this.billingInfo = billingInfo;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public void setBurntPoints(double burntPoints) {
        this.burntPoints = burntPoints;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public void setConsumerMetadata(JSONObject consumerMetadata) {
        this.consumerMetadata = consumerMetadata;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setLoyaltyId(String loyaltyId) {
        this.loyaltyId = loyaltyId;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public void setNameday(String nameday) {
        this.nameday = nameday;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setOptin(JSONObject optin) {
        this.optin = optin;
    }

    public void setPasswordSet(boolean passwordSet) {
        this.passwordSet = passwordSet;
    }

    public void setProfileMetadata(String profileMetadata) {
        this.profileMetadata = profileMetadata;
    }

    public void setRedeemedPoints(double redeemedPoints) {
        this.redeemedPoints = redeemedPoints;
    }

    public void setRetrievedPoints(double retrievedPoints) {
        this.retrievedPoints = retrievedPoints;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public void setSubscribe(boolean subscribe) {
        this.subscribe = subscribe;
    }

    public void setTags(JSONObject tags) {
        this.tags = tags;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public void setUserPoints(double userPoints) {
        this.userPoints = userPoints;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public void setNewsletter(boolean newsletter) {
        this.newsletter = newsletter;
    }

    public void setSms(boolean sms) {
        this.sms = sms;
    }

    public void setSegmentation(boolean segmentation) {
        this.segmentation = segmentation;
    }

    public void setSms_segmentation(boolean sms_segmentation) {
        this.sms_segmentation = sms_segmentation;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Consumer> CREATOR = new Creator<Consumer>() {
        public Consumer createFromParcel(Parcel source) {
            return new Consumer(source);
        }

        public Consumer[] newArray(int size) {
            return new Consumer[size];
        }
    };
}
