/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.io.models;

import android.text.TextUtils;

import androidx.annotation.NonNull;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * Created by Panagiotis Triantafyllou on 14-Jan-22.
 */

public class CouponList extends ArrayList<Coupon> {

    /**
     * Generated for serialized class
     */
    private static final long serialVersionUID = -188843583823948267L;

    private static final String JSON_KEY_RESULT = "result";

    private String mRequestSignature = "";

    private CouponList(String requestSignature) {
        this.mRequestSignature = requestSignature;
    }

    public CouponList() {
        super();
    }

    /**
     * Constructor used to create the CouponList from a JSON Object.
     *
     * @param couponListJSONObject The JSON Object, used to create the CouponList
     */
    public CouponList(JSONObject couponListJSONObject, String requestSignature) {
        this(requestSignature);

        if (couponListJSONObject == null)
            return;

        JSONArray jArray = couponListJSONObject.optJSONArray(JSON_KEY_RESULT);
        if (jArray != null) {
            for (int i = 0, lim = jArray.length(); i < lim; ++i) {
                add(new Coupon(jArray.optJSONObject(i)));
            }
        }
    }

    public CouponList(String couponListJSONObject, boolean customCast) {
        this();

        if (couponListJSONObject == null || TextUtils.isEmpty(couponListJSONObject))
            return;

        JSONArray jArray = null;
        try {
            jArray = new JSONArray(couponListJSONObject);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        if (jArray != null) {
            for (int i = 0, lim = jArray.length(); i < lim; ++i) {
                add(new Coupon(jArray.optJSONObject(i)));
            }
        }
    }

    @NonNull
    public String getRequestSignature() {
        return mRequestSignature;
    }
}
