package ly.warp.sdk.io.models;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * Created by Panagiotis Triantafyllou on 20/Απρ/2022.
 */

public class LoyaltyContextualOfferModel implements Serializable {
    private String sessionId;
    private ArrayList<String> eligibleAssets;
    private String id;
    private String businessAdditionalId;
    private String treatmentCode;
    private String offerName;
    private String productType;
    private String provDuration;
    private String noOfRecurrance;
    private String price;
    private String discount;
    private String voiceCategory;
    private String dataCategory;
    private String minsValue;
    private String dataValue;
    private String provStepValueMins;
    private String postpayProduct;
    private String notificationMessage;
    private String loyaltyCampaignId;
    private String businessService;
    private String UACIOfferTrackingCode;
    private String offerCode1;
    private String score;
    private String zone;
    private String wave;
    private String validity;
    private String offerAudienceLevel;
    private String imageUrl; // εξωτερική εικόνα
    private String title; // τίτλος εξωτερικά
    private String subtitle; // για more for you 2ο λεκτικό
    private String message; // για more for you 3ο λεκτικό
    private String titleOffer; // τιτλος εσωτερικά
    private String imageOfferUrl; // εικόνα εσωτερικά
    private String duration; // διάρκεια
    private String giftType; // είδος δώρου
    private String giftValue; // αξία δώρου
    private String description; // περιγραφή
    private String termsAndConditions; // όροι


    public LoyaltyContextualOfferModel() {
        this.sessionId = "";
        this.eligibleAssets = new ArrayList<String>();
        this.id = "";
        this.businessAdditionalId = "";
        this.treatmentCode = "";
        this.offerName = "";
        this.productType = "";
        this.provDuration = "";
        this.noOfRecurrance = "";
        this.price = "";
        this.discount = "";
        this.voiceCategory = "";
        this.dataCategory = "";
        this.minsValue = "";
        this.dataValue = "";
        this.provStepValueMins = "";
        this.postpayProduct = "";
        this.notificationMessage = "";
        this.loyaltyCampaignId = "";
        this.businessService = "";
        this.UACIOfferTrackingCode = "";
        this.offerCode1 = "";
        this.score = "";
        this.zone = "";
        this.wave = "";
        this.validity = "";
        this.offerAudienceLevel = "";
        this.imageUrl = "";
        this.title = "";
        this.subtitle = "";
        this.message = "";
        this.titleOffer = "";
        this.imageOfferUrl = "";
        this.duration = "";
        this.giftType = "";
        this.giftValue = "";
        this.description = "";
        this.termsAndConditions = "";
    }

    public LoyaltyContextualOfferModel(JSONObject jobj) {
        if (jobj != null) {
            this.sessionId = jobj.optString("sessionId");
            this.eligibleAssets = new ArrayList<>();
            JSONArray assets = new JSONArray();
            assets = jobj.optJSONArray("eligibleAssets");
            if (assets != null && assets.length() > 0) {
                ArrayList<String> assetsList = new ArrayList<>();
                for (int i = 0; i < assets.length(); i++) {
                    assetsList.add(assets.optString(i));
                }
                this.eligibleAssets.addAll(assetsList);
            }
            this.id = jobj.optString("id");
            this.businessAdditionalId = jobj.optString("businessAdditionalId");
            this.treatmentCode = jobj.optString("treatmentCode");
            this.offerName = jobj.optString("offerName");
            this.productType = jobj.optString("productType");
            this.provDuration = jobj.optString("provDuration");
            this.noOfRecurrance = jobj.optString("noOfRecurrance");
            this.price = jobj.optString("price");
            this.discount = jobj.optString("discount");
            this.voiceCategory = jobj.optString("voiceCategory");
            this.dataCategory = jobj.optString("dataCategory");
            this.minsValue = jobj.optString("minsValue");
            this.dataValue = jobj.optString("dataValue");
            this.provStepValueMins = jobj.optString("provStepValueMins");
            this.postpayProduct = jobj.optString("postpayProduct");
            this.notificationMessage = jobj.optString("notificationMessage");
            this.loyaltyCampaignId = jobj.optString("loyaltyCampaignId");
            this.businessService = jobj.optString("businessService");
            this.UACIOfferTrackingCode = jobj.optString("UACIOfferTrackingCode");
            this.offerCode1 = jobj.optString("offerCode1");
            this.score = jobj.optString("score");
            this.zone = jobj.optString("zone");
            this.wave = jobj.optString("wave");
            this.validity = jobj.optString("validity");
            this.offerAudienceLevel = jobj.optString("offerAudienceLevel");
            this.imageUrl = jobj.optString("imageUrl");
            this.title = jobj.optString("title");
            this.subtitle = jobj.optString("subtitle");
            this.message = jobj.optString("message");
            this.titleOffer = jobj.optString("titleOffer");
            this.imageOfferUrl = jobj.optString("imageOfferUrl");
            this.duration = jobj.optString("duration");
            this.giftType = jobj.optString("giftType");
            this.giftValue = jobj.optString("giftValue");
            this.description = jobj.optString("description");
            this.termsAndConditions = jobj.optString("termsAndConditions");
        }
    }

    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public ArrayList<String> getEligibleAssets() {
        return eligibleAssets;
    }

    public void setEligibleAssets(ArrayList<String> eligibleAssets) {
        this.eligibleAssets = eligibleAssets;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBusinessAdditionalId() {
        return businessAdditionalId;
    }

    public void setBusinessAdditionalId(String businessAdditionalId) {
        this.businessAdditionalId = businessAdditionalId;
    }

    public String getTreatmentCode() {
        return treatmentCode;
    }

    public void setTreatmentCode(String treatmentCode) {
        this.treatmentCode = treatmentCode;
    }

    public String getOfferName() {
        return offerName;
    }

    public void setOfferName(String offerName) {
        this.offerName = offerName;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getProvDuration() {
        return provDuration;
    }

    public void setProvDuration(String provDuration) {
        this.provDuration = provDuration;
    }

    public String getNoOfRecurrance() {
        return noOfRecurrance;
    }

    public void setNoOfRecurrance(String noOfRecurrance) {
        this.noOfRecurrance = noOfRecurrance;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public String getVoiceCategory() {
        return voiceCategory;
    }

    public void setVoiceCategory(String voiceCategory) {
        this.voiceCategory = voiceCategory;
    }

    public String getDataCategory() {
        return dataCategory;
    }

    public void setDataCategory(String dataCategory) {
        this.dataCategory = dataCategory;
    }

    public String getMinsValue() {
        return minsValue;
    }

    public void setMinsValue(String minsValue) {
        this.minsValue = minsValue;
    }

    public String getDataValue() {
        return dataValue;
    }

    public void setDataValue(String dataValue) {
        this.dataValue = dataValue;
    }

    public String getProvStepValueMins() {
        return provStepValueMins;
    }

    public void setProvStepValueMins(String provStepValueMins) {
        this.provStepValueMins = provStepValueMins;
    }

    public String getPostpayProduct() {
        return postpayProduct;
    }

    public void setPostpayProduct(String postpayProduct) {
        this.postpayProduct = postpayProduct;
    }

    public String getNotificationMessage() {
        return notificationMessage;
    }

    public void setNotificationMessage(String notificationMessage) {
        this.notificationMessage = notificationMessage;
    }

    public String getLoyaltyCampaignId() {
        return loyaltyCampaignId;
    }

    public void setLoyaltyCampaignId(String loyaltyCampaignId) {
        this.loyaltyCampaignId = loyaltyCampaignId;
    }

    public String getBusinessService() {
        return businessService;
    }

    public void setBusinessService(String businessService) {
        this.businessService = businessService;
    }

    public String getUACIOfferTrackingCode() {
        return UACIOfferTrackingCode;
    }

    public void setUACIOfferTrackingCode(String UACIOfferTrackingCode) {
        this.UACIOfferTrackingCode = UACIOfferTrackingCode;
    }

    public String getOfferCode1() {
        return offerCode1;
    }

    public void setOfferCode1(String offerCode1) {
        this.offerCode1 = offerCode1;
    }

    public String getScore() {
        return score;
    }

    public void setScore(String score) {
        this.score = score;
    }

    public String getZone() {
        return zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getWave() {
        return wave;
    }

    public void setWave(String wave) {
        this.wave = wave;
    }

    public String getValidity() {
        return validity;
    }

    public void setValidity(String validity) {
        this.validity = validity;
    }

    public String getOfferAudienceLevel() {
        return offerAudienceLevel;
    }

    public void setOfferAudienceLevel(String offerAudienceLevel) {
        this.offerAudienceLevel = offerAudienceLevel;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTitleOffer() {
        return titleOffer;
    }

    public void setTitleOffer(String titleOffer) {
        this.titleOffer = titleOffer;
    }

    public String getImageOfferUrl() {
        return imageOfferUrl;
    }

    public void setImageOfferUrl(String imageOfferUrl) {
        this.imageOfferUrl = imageOfferUrl;
    }

    public String getDuration() {
        return duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getGiftType() {
        return giftType;
    }

    public void setGiftType(String giftType) {
        this.giftType = giftType;
    }

    public String getGiftValue() {
        return giftValue;
    }

    public void setGiftValue(String giftValue) {
        this.giftValue = giftValue;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTermsAndConditions() {
        return termsAndConditions;
    }

    public void setTermsAndConditions(String termsAndConditions) {
        this.termsAndConditions = termsAndConditions;
    }
}
