/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package ly.warp.sdk.io.models;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.IntegerRes;
import androidx.core.app.NotificationCompat;
import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;

public class PushCampaign {

    public static final String NOTIFICATION_STYLE_DEFAULT = "default";
    public static final String NOTIFICATION_STYLE_BIG_PICTURE = "big_picture";
    public static final String NOTIFICATION_STYLE_BIG_TEXT = "big_text";
    public static final String NOTIFICATION_STYLE_INBOX_STYLE = "inbox_style";

    private static final String NOTIFICATION_KEY_TICKER = "alert";
    private static final String NOTIFICATION_KEY_TITLE = "alert";
    private static final String NOTIFICATION_KEY_SUBTITLE = "subtitle";
    // private static final String NOTIFICATION_KEY_CONTENT = "message";
    private static final String NOTIFICATION_KEY_SESSION_UUID = "session_uuid";
    private static final String NOTIFICATION_KEY_LOYALTY_ACTION = "loyalty-action";
    private static final String NOTIFICATION_KEY_SOUND = "sound";

    //new
    private static final String NOTIFICATION_KEY_NOTIFICATION_STYLE = "notification_style";
    private static final String NOTIFICATION_KEY_LARGE_ICON = "large_icon";
    private static final String NOTIFICATION_KEY_SUMMARY_TEXT = "summary_text";
    private static final String NOTIFICATION_KEY_BIG_PICTURE_URL = "big_picture_url";
    private static final String NOTIFICATION_KEY_BIG_TEXT = "big_text";
    private static final String NOTIFICATION_KEY_COLOR = "color";
    private static final String NOTIFICATION_KEY_INBOX_LINES = "inbox_lines";
    private static final String NOTIFICATION_KEY_ACTION = "action";
    private static final String NOTIFICATION_KEY_ACTION_NAME = "action_name";
    private static final String NOTIFICATION_KEY_ACTION_INTENT = "action_intent";



    private int action;
    private String ticker;
    private String title;
    private String subtitle;
    // private String content;
    private String sessionUUID;
    private String soundUri;
    private String notificationStyle;
    private String largeIconUrl;
    private String summaryText;
    private String bigPictureUrl;
    private String bigText;
    private String color;
    private List<String> inboxLines = new ArrayList<>();
    private List<NotificationCompat.Action> actions = new ArrayList<>();




    public PushCampaign(Bundle data) {
        try {
            action = Integer.parseInt(data
                    .getString(NOTIFICATION_KEY_LOYALTY_ACTION));
        } catch (NumberFormatException e) {
            action = 0;
            WarpUtils.log("Loyalty action is not a number. Reseting to 0", e);
        }
        ticker = data.getString(NOTIFICATION_KEY_TICKER);
        title = data.getString(NOTIFICATION_KEY_TITLE);
        subtitle = data.getString(NOTIFICATION_KEY_SUBTITLE);
        // content = data.getString(NOTIFICATION_KEY_CONTENT);
        sessionUUID = data.getString(NOTIFICATION_KEY_SESSION_UUID);
        soundUri = data.getString(NOTIFICATION_KEY_SOUND);

        notificationStyle = data.getString(NOTIFICATION_KEY_NOTIFICATION_STYLE,"");
        largeIconUrl = data.getString(NOTIFICATION_KEY_LARGE_ICON,"");
        summaryText =  data.getString(NOTIFICATION_KEY_SUMMARY_TEXT,"");
        bigPictureUrl = data.getString(NOTIFICATION_KEY_BIG_PICTURE_URL,"");
        bigText = data.getString(NOTIFICATION_KEY_BIG_TEXT,"");
        color = data.getString(NOTIFICATION_KEY_COLOR,"");

        try {
            inboxLines = WarpJSONParser.parseJsonToList(new JSONArray(data.getString(NOTIFICATION_KEY_INBOX_LINES)),String.class);
        } catch (Exception e ) {
            e.printStackTrace();
        }
        try {
            actions = jsonArrayToAction(new JSONArray(data.getString(NOTIFICATION_KEY_ACTION)));
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    public PushCampaign(JSONObject json) {

        if (json != null) {
            action = json.optInt(NOTIFICATION_KEY_LOYALTY_ACTION);
            ticker = json.optString(NOTIFICATION_KEY_TICKER);
            title = json.optString(NOTIFICATION_KEY_TITLE);
            subtitle = json.optString(NOTIFICATION_KEY_SUBTITLE);
            // content = data.getString(NOTIFICATION_KEY_CONTENT);
            sessionUUID = json.optString(NOTIFICATION_KEY_SESSION_UUID);
            soundUri = json.optString(NOTIFICATION_KEY_SOUND);

            notificationStyle = json.optString(NOTIFICATION_KEY_NOTIFICATION_STYLE,"");
            largeIconUrl = json.optString(NOTIFICATION_KEY_LARGE_ICON,"");
            summaryText =  json.optString(NOTIFICATION_KEY_SUMMARY_TEXT,"");
            bigPictureUrl = json.optString(NOTIFICATION_KEY_BIG_PICTURE_URL,"");
            bigText = json.optString(NOTIFICATION_KEY_BIG_TEXT,"");
            color = json.optString(NOTIFICATION_KEY_COLOR,"");
            inboxLines = WarpJSONParser.parseJsonToList(json,NOTIFICATION_KEY_INBOX_LINES,String.class);
            actions = jsonArrayToAction(json.optJSONArray(NOTIFICATION_KEY_ACTION));

        }

    }

    public boolean isFilled() {
        return !TextUtils.isEmpty(ticker)
                && !TextUtils.isEmpty(title)
                && !TextUtils.isEmpty(sessionUUID);
    }

    public int getAction() {
        return action;
    }

    public String getTicker() {
        return ticker;
    }

    public String getTitle() {
        return title;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public String getContent() {
        return null;
        // TODO Implement this when needed
        // return content;
    }

    public String getColor() {
        return color;
    }

    public String getImageUrl() {
//        if(!TextUtils.isEmpty(getLargeIconUrl())){
        return getLargeIconUrl();
//        }else{
//            return WarplyProperty.getBaseUrl(Warply.getWarplyContext()) + WarpConstants.BASE_REMOTE_PAGE_URL + "logo/" + getSessionUUID();
//        }
    }

    public String getSessionUUID() {
        return sessionUUID;
    }

    public Uri getSoundUri(Context context) {

        if (soundUri != null) {
            int soundResource = context.getResources().getIdentifier(soundUri,
                    "raw", context.getPackageName());
            if (soundResource != 0) {
                return Uri.parse("android.resource://"
                        + context.getPackageName() + "/raw/" + soundUri);
            }
        }
        return null;
    }


    public String getNotificationStyle() {
        return notificationStyle;
    }

    public String getLargeIconUrl() {
        return largeIconUrl;
    }

    public String getSummaryText() {
        return summaryText;
    }

    public String getBigPictureUrl() {
        return bigPictureUrl;
    }

    public String getBigText() {
        return bigText;
    }

    public List<String> getInboxLines() {
        return inboxLines;
    }

    public List<NotificationCompat.Action> getActions() {
        return actions;
    }

    public boolean hasActions() {
        return actions != null && actions.size()>0 ;
    }

    private List<NotificationCompat.Action> jsonArrayToAction(JSONArray jarr) {
        List<NotificationCompat.Action> act = new ArrayList<>();
        if (jarr == null)
            return act;
        if (jarr.length() == 0)
            return act;

        for (int i=0; i< jarr.length();i++){
            JSONObject jsonAction = jarr.optJSONObject(i);
            if(jsonAction != null){
                act.add(new NotificationCompat.Action(0 ,jsonAction.optString(NOTIFICATION_KEY_ACTION_NAME),null));
            }
        }

        return act;
    }


    public void setAction(int action) {
        this.action = action;
    }

    public void setTicker(String ticker) {
        this.ticker = ticker;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setSessionUUID(String sessionUUID) {
        this.sessionUUID = sessionUUID;
    }

    public void setSoundUri(String soundUri) {
        this.soundUri = soundUri;
    }

    public void setNotificationStyle(String notificationStyle) {
        this.notificationStyle = notificationStyle;
    }

    public void setLargeIconUrl(String largeIconUrl) {
        this.largeIconUrl = largeIconUrl;
    }

    public void setSummaryText(String summaryText) {
        this.summaryText = summaryText;
    }

    public void setBigPictureUrl(String bigPictureUrl) {
        this.bigPictureUrl = bigPictureUrl;
    }

    public void setBigText(String bigText) {
        this.bigText = bigText;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setInboxLines(List<String> inboxLines) {
        this.inboxLines = inboxLines;
    }

    public void setActions(List<NotificationCompat.Action> actions) {
        this.actions = actions;
    }
}
