/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.io.models;

import android.os.Parcel;
import android.os.Parcelable;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 19-July-22.
 */

public class SharingCoupon implements Parcelable, Serializable {

    private static final long serialVersionUID = -4754964462459705285L;

    /* Constants used to export the campaign in JSON formal and vice versa */

    private static final String TRANSACTION_METADATA = "transaction_metadata";
    private static final String SHARING_TYPE = "sharing_type";
    private static final String DISCOUNT = "discount";
    private static final String DATE = "date";
    private static final String COUPONSET_UUID = "couponset_uuid";
    private static final String NAME = "name";
    private static final String MERCHANT_UUID = "merchant_uuid";
    private static final String FINAL_PRICE = "final_price";

    /* Member variables of the Campaign object */

    private String transactionMetadata = "";
    private String sharingType = "";
    private String discount = "";
    private String date = "";
    private String couponsetUuid = "";
    private String name = "";
    private String merchantUuid = "";
    private double final_price = 0.0d;

    /**
     * Basic constructor used to create an object from a String, representing a
     * JSON Object
     *
     * @param json The String, representing the JSON Object
     * @throws JSONException Thrown if the String cannot be converted to JSON
     */
    public SharingCoupon(String json) throws JSONException {
        this(new JSONObject(json));
    }

    public SharingCoupon() {
        this.transactionMetadata = "";
        this.sharingType = "";
        this.discount = "";
        this.date = "";
        this.couponsetUuid = "";
        this.name = "";
        this.final_price = 0.0d;
    }

    /**
     * Constructor used to create an Object from a given JSON Object
     *
     * @param json JSON Object used to create the Coupon
     */
    public SharingCoupon(JSONObject json) {
        if (json != null) {
            this.discount = json.optString(DISCOUNT);
            this.couponsetUuid = json.optString(COUPONSET_UUID);
            this.date = json.optString(DATE);
            this.sharingType = json.optString(SHARING_TYPE);
            this.transactionMetadata = json.optString(TRANSACTION_METADATA);
            this.name = json.optString(NAME);
            this.merchantUuid = json.optString(MERCHANT_UUID);
            this.final_price = json.optDouble(FINAL_PRICE);
        }
    }

    public SharingCoupon(Parcel source) {
        this.discount = source.readString();
        this.couponsetUuid = source.readString();
        this.date = source.readString();
        this.sharingType = source.readString();
        this.transactionMetadata = source.readString();
        this.name = source.readString();
        this.merchantUuid = source.readString();
        this.final_price = source.readDouble();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.discount);
        dest.writeString(this.couponsetUuid);
        dest.writeString(this.date);
        dest.writeString(this.sharingType);
        dest.writeString(this.transactionMetadata);
        dest.writeString(this.name);
        dest.writeString(this.merchantUuid);
        dest.writeDouble(this.final_price);
    }

    /**
     * Converts the Coupon into a JSON Object
     *
     * @return The JSON Object created from this Coupon
     */
    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.putOpt(DISCOUNT, this.discount);
            jObj.putOpt(COUPONSET_UUID, this.couponsetUuid);
            jObj.putOpt(DATE, this.date);
            jObj.putOpt(SHARING_TYPE, this.sharingType);
            jObj.putOpt(TRANSACTION_METADATA, this.transactionMetadata);
            jObj.putOpt(NAME, this.name);
            jObj.putOpt(MERCHANT_UUID, this.merchantUuid);
            jObj.putOpt(FINAL_PRICE, this.final_price);
        } catch (JSONException e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
        }
        return jObj;
    }

    /**
     * String representation of the Coupon, as a JSON object
     *
     * @return A String representation of JSON object
     */
    public String toString() {
        if (toJSONObject() != null)
            return toJSONObject().toString();
        return null;
    }

    /**
     * String representation of the Coupon, as a human readable JSON object
     *
     * @return A human readable String representation of JSON object
     */
    public String toHumanReadableString() {
        String humanReadableString = null;
        try {
            humanReadableString = toJSONObject().toString(2);
        } catch (JSONException e) {
            WarpUtils.warn("Failed converting Coupon JSON object to String", e);
        }
        return humanReadableString;
    }

    // ================================================================================
    // Getters
    // ================================================================================


    public String getTransactionMetadata() {
        return transactionMetadata;
    }

    public void setTransactionMetadata(String transactionMetadata) {
        this.transactionMetadata = transactionMetadata;
    }

    public String getSharingType() {
        return sharingType;
    }

    public void setSharingType(String sharingType) {
        this.sharingType = sharingType;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getCouponsetUuid() {
        return couponsetUuid;
    }

    public void setCouponsetUuid(String couponsetUuid) {
        this.couponsetUuid = couponsetUuid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMerchantUuid() {
        return merchantUuid;
    }

    public void setMerchantUuid(String merchantUuid) {
        this.merchantUuid = merchantUuid;
    }

    public double getFinal_price() {
        return final_price;
    }

    public void setFinal_price(double final_price) {
        this.final_price = final_price;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<SharingCoupon> CREATOR = new Creator<SharingCoupon>() {
        public SharingCoupon createFromParcel(Parcel source) {
            return new SharingCoupon(source);
        }

        public SharingCoupon[] newArray(int size) {
            return new SharingCoupon[size];
        }
    };
}
