/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.io.models;

import android.os.Parcel;
import android.os.Parcelable;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 07-Dec-21.
 */

public class Tags implements Parcelable, Serializable {

    private static final long serialVersionUID = -4754964462459705285L;

    /* Constants used to export the campaign in JSON formal and vice versa */

    private static final String UUID = "uuid";
    private static final String ADMIN_NAME = "admin_name";
    private static final String NAME = "name";
    private static final String CREATED = "created";
    private static final String LANGUAGE = "language";
    private static final String CATEGORY = "category";

    /* Member variables of the Campaign object */

    private String uuid = "";
    private String admin_name = "";
    private String name = "";
    private String created = "";
    private String language = "";
    private String category = "";


    /**
     * Basic constructor used to create an object from a String, representing a
     * JSON Object
     *
     * @param json The String, representing the JSON Object
     * @throws JSONException Thrown if the String cannot be converted to JSON
     */
    public Tags(String json) throws JSONException {
        this(new JSONObject(json));
    }

    /**
     * Constructor used to create an Object from a given JSON Object
     *
     * @param json JSON Object used to create the Tags
     */
    public Tags(JSONObject json) {
        if (json != null) {
            this.uuid = json.optString(UUID);
            this.admin_name = json.optString(ADMIN_NAME);
            this.name = json.optString(NAME);
            this.created = json.optString(CREATED);
            this.language = json.optString(LANGUAGE);
            this.category = json.optString(CATEGORY);
        }
    }

    public Tags(Parcel source) {
        this.uuid = source.readString();
        this.admin_name = source.readString();
        this.name = source.readString();
        this.created = source.readString();
        this.language = source.readString();
        this.category = source.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.uuid);
        dest.writeString(this.admin_name);
        dest.writeString(this.name);
        dest.writeString(this.created);
        dest.writeString(this.language);
        dest.writeString(this.category);
    }

    /**
     * Converts the Tags into a JSON Object
     *
     * @return The JSON Object created from this Tags
     */
    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.putOpt(UUID, this.uuid);
            jObj.putOpt(ADMIN_NAME, this.admin_name);
            jObj.putOpt(NAME, this.name);
            jObj.putOpt(CREATED, this.created);
            jObj.putOpt(LANGUAGE, this.language);
            jObj.putOpt(CATEGORY, this.category);
        } catch (JSONException e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
        }
        return jObj;
    }

    /**
     * String representation of the Tags, as a JSON object
     *
     * @return A String representation of JSON object
     */
    public String toString() {
        if (toJSONObject() != null)
            return toJSONObject().toString();
        return null;
    }

    /**
     * String representation of the Tags, as a human readable JSON object
     *
     * @return A human readable String representation of JSON object
     */
    public String toHumanReadableString() {
        String humanReadableString = null;
        try {
            humanReadableString = toJSONObject().toString(2);
        } catch (JSONException e) {
            WarpUtils.warn("Failed converting Tags JSON object to String", e);
        }
        return humanReadableString;
    }

    // ================================================================================
    // Getters
    // ================================================================================


    public String getUuid() {
        return uuid;
    }

    public String getAdminName() {
        return admin_name;
    }

    public String getName() {
        return name;
    }

    public String getCreated() {
        return created;
    }

    public String getLanguage() {
        return language;
    }

    public String getCategory() {
        return category;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Tags> CREATOR = new Creator<Tags>() {
        public Tags createFromParcel(Parcel source) {
            return new Tags(source);
        }

        public Tags[] newArray(int size) {
            return new Tags[size];
        }
    };
}
