package ly.warp.sdk.io.models;


import org.json.JSONObject;

/**
 * Created by antonis on 12/10/2016.
 */
public class WarpGeoFence {

    // ===========================================================
    // Constants
    // ===========================================================
    private static final String KEY_ID = "id";
    private static final String KEY_LAT = "lat";
    private static final String KEY_LONG = "long";
    private static final String KEY_RADIUS = "radius";

    // ===========================================================
    // Fields
    // ===========================================================
    private double lat,
                  lon;
    private double radius;
    private int id;


    // ===========================================================
    // Constructors
    // ===========================================================
    public WarpGeoFence(JSONObject json) {
        if(json != null){
            lat = json.optDouble(KEY_LAT);
            lon = json.optDouble(KEY_LONG);
            radius = json.optDouble(KEY_RADIUS);
            id = json.optInt(KEY_ID);

        }
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    // ===========================================================
    // Methods
    // ===========================================================

    public boolean isInsideFence(double lat, double lon){
        return distance(getLat(),lat,getLon(),lon,0,0) <= getRadius();
    }

    // ===========================================================
    // Getter & Setter
    // ===========================================================
    public double getLat() {
        return lat;
    }
    public double getLon() {
        return lon;
    }
    public double getRadius() {
        return radius;
    }
    public int getId() {
        return id;
    }
    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================
    public static double distance(double lat1, double lat2, double lon1,
                                  double lon2, double el1, double el2) {

        final int R = 6371; // Radius of the earth

        Double latDistance = Math.toRadians(lat2 - lat1);
        Double lonDistance = Math.toRadians(lon2 - lon1);
        Double a = Math.sin(latDistance / 2) * Math.sin(latDistance / 2)
                + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2))
                * Math.sin(lonDistance / 2) * Math.sin(lonDistance / 2);
        Double c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
        double distance = R * c * 1000; // convert to meters

        double height = el1 - el2;

        distance = Math.pow(distance, 2) + Math.pow(height, 2);

        return Math.sqrt(distance);
    }
}
