package ly.warp.sdk.io.request;

import android.util.Base64;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 04-July-22.
 */

public class CosmoteCouponSharingRequest {

    // ===========================================================
    // Constants
    // ===========================================================

    private final String KEY_MAPP = "coupon";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "share";
    private final String KEY_COUPON = "coupon";
    private final String KEY_SENDER = "sender_msisdn";
    private final String KEY_RECEIVER = "receiver_msisdn";

    // ===========================================================
    // Fields
    // ===========================================================

    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0;
    private String mCoupon = "";
    private String mSender = "";
    private String mReceiver = "";

    // ===========================================================
    // Constructor
    // ===========================================================

    /**
     * Default constructor of CosmoteCouponSharingRequest, initializes an empty filters HashMap
     */
    public CosmoteCouponSharingRequest() {
        mFilters = new HashMap<>();
    }

    public CosmoteCouponSharingRequest(CosmoteCouponSharingRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public boolean equals(Object object) {
        if (object instanceof CosmoteCouponSharingRequest) {
            CosmoteCouponSharingRequest other = (CosmoteCouponSharingRequest) object;
            return other == this || (this.mFilters == other.mFilters || (this.mFilters != null && this.mFilters.equals(other.mFilters)));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return mFilters.hashCode();
    }

    // ===========================================================
    // Methods
    // ===========================================================

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    public CosmoteCouponSharingRequest setCoupon(String coupon) {
        mCoupon = coupon;
        return this;
    }

    public CosmoteCouponSharingRequest setSender(String sender) {
        mSender = sender;
        return this;
    }

    public CosmoteCouponSharingRequest setReceiver(String receiver) {
        mReceiver = receiver;
        return this;
    }

    /**
     * Call this to get how often the cached data will be updated.
     *
     * @return mCacheUpdateInterval
     */
    public long getCacheUpdateInterval() {
        return mCacheUpdateInterval;
    }

    /**
     * Call this to set how often the cached data will be updated.
     *
     * @param updateInterval The time that data will be cached
     * @return CosmoteCouponSharingRequest
     */
    public CosmoteCouponSharingRequest setCacheUpdateInterval(long updateInterval) {

        this.mCacheUpdateInterval = updateInterval;
        if (mCacheUpdateInterval < 0) {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to check if the Application uses Cache
     *
     * @return <p>true - the Application is using Cache</p>
     * <p>false - the Application is not using Cache</p>
     */
    public boolean isUseCache() {
        return mCacheUpdateInterval > 0;
    }

    /**
     * Call this to check whether the cached data need to be updated
     *
     * @param useCache <p>true - the Application is using Cache</p>
     *                 <p>false - the Application is not using Cache</p>
     * @return CosmoteCouponSharingRequest
     */
    public CosmoteCouponSharingRequest setUseCache(boolean useCache) {

        if (useCache) {
            mCacheUpdateInterval = mCacheUpdateInterval > 0 ? mCacheUpdateInterval
                    : WarpConstants.INBOX_UPDATE_INTERVAL;
        } else {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to build the offers Json object
     *
     * @return bodyJsonObject
     */
    public JSONObject toJson() {
        JSONObject bodyJsonObject = new JSONObject();
        try {
            JSONObject extraJson = new JSONObject();
            extraJson.putOpt(KEY_ACTION, KEY_ACTION_VALUE);
            extraJson.putOpt(KEY_COUPON, mCoupon);
            extraJson.putOpt(KEY_SENDER, mSender);
            extraJson.putOpt(KEY_RECEIVER, mReceiver);
            bodyJsonObject.putOpt(KEY_MAPP, extraJson);
        } catch (JSONException e) {
            if (WarpConstants.DEBUG)
                e.printStackTrace();
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = mFilters != null && mFilters.size() > 0 ? String.valueOf(mFilters.hashCode()) : "default_cosmote_coupon_sharing_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString(hash, Base64.NO_WRAP);
        } catch (NullPointerException | NoSuchAlgorithmException
                | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }
}
