package ly.warp.sdk.io.request;

import android.util.Base64;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 19-July-22.
 */

public class CosmotePostEventRequest {

    // ===========================================================
    // Constants
    // ===========================================================

    private final String KEY_MAPP = "consumer_data";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "integration";
    private final String KEY_METHOD = "method";
    private final String KEY_METHOD_VALUE = "postEvent";
    private final String KEY_DATA = "data";
    private final String KEY_PARAMETERS = "parameters";

    // ===========================================================
    // Fields
    // ===========================================================

    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0;
    private String mUserMsisdn = "";
    private String mCommunicationUuid = "";
    private String mOfferAudienceLevel = "";
    private String mUACIOfferTrackingCode = "";
    private String mOfferCode1 = "";
    private String mScore = "";
    private String mZone = "";
    private String mWave = "";
    private String mValidity = "";
    private String mTreatmentCode = "";

    // ===========================================================
    // Constructor
    // ===========================================================

    /**
     * Default constructor of WarplyConsumerRequest, initializes an empty filters HashMap
     */
    public CosmotePostEventRequest() {
        mFilters = new HashMap<>();
    }

    public CosmotePostEventRequest(CosmotePostEventRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public boolean equals(Object object) {
        if (object instanceof CosmotePostEventRequest) {
            CosmotePostEventRequest other = (CosmotePostEventRequest) object;
            return other == this || (this.mFilters == other.mFilters || (this.mFilters != null && this.mFilters.equals(other.mFilters)));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return mFilters.hashCode();
    }

    // ===========================================================
    // Methods
    // ===========================================================

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    public CosmotePostEventRequest setCommunicationUuid(String communicationUuid) {
        this.mCommunicationUuid = communicationUuid;
        return this;
    }

    public CosmotePostEventRequest setUserMsisdn(String userMsisdn) {
        this.mUserMsisdn = userMsisdn;
        return this;
    }

    public CosmotePostEventRequest setOfferAudienceLevel(String offerAudienceLevel) {
        this.mOfferAudienceLevel = offerAudienceLevel;
        return this;
    }

    public CosmotePostEventRequest setUACIOfferTrackingCode(String uaciOfferTrackingCode) {
        this.mUACIOfferTrackingCode = uaciOfferTrackingCode;
        return this;
    }

    public CosmotePostEventRequest setOfferCode1(String offerCode1) {
        this.mOfferCode1 = offerCode1;
        return this;
    }

    public CosmotePostEventRequest setScore(String score) {
        this.mScore = score;
        return this;
    }

    public CosmotePostEventRequest setZone(String zone) {
        this.mZone = zone;
        return this;
    }

    public CosmotePostEventRequest setWave(String wave) {
        this.mWave = wave;
        return this;
    }

    public CosmotePostEventRequest setValidity(String validity) {
        this.mValidity = validity;
        return this;
    }

    public CosmotePostEventRequest setTreatmentCode(String treatmentCode) {
        this.mTreatmentCode = treatmentCode;
        return this;
    }

    /**
     * Call this to get how often the cached data will be updated.
     *
     * @return mCacheUpdateInterval
     */
    public long getCacheUpdateInterval() {
        return mCacheUpdateInterval;
    }

    /**
     * Call this to set how often the cached data will be updated.
     *
     * @param updateInterval The time that data will be cached
     * @return CosmotePostEventRequest
     */
    public CosmotePostEventRequest setCacheUpdateInterval(long updateInterval) {

        this.mCacheUpdateInterval = updateInterval;
        if (mCacheUpdateInterval < 0) {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to check if the Application uses Cache
     *
     * @return <p>true - the Application is using Cache</p>
     * <p>false - the Application is not using Cache</p>
     */
    public boolean isUseCache() {
        return mCacheUpdateInterval > 0;
    }

    /**
     * Call this to check whether the cached data need to be updated
     *
     * @param useCache <p>true - the Application is using Cache</p>
     *                 <p>false - the Application is not using Cache</p>
     * @return CosmotePostEventRequest
     */
    public CosmotePostEventRequest setUseCache(boolean useCache) {

        if (useCache) {
            mCacheUpdateInterval = mCacheUpdateInterval > 0 ? mCacheUpdateInterval
                    : WarpConstants.INBOX_UPDATE_INTERVAL;
        } else {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to build the offers Json object
     *
     * @return bodyJsonObject
     */
    public JSONObject toJson() {
        JSONObject bodyJsonObject = new JSONObject();
        try {
            JSONObject extraJson = new JSONObject();
            extraJson.putOpt(KEY_ACTION, KEY_ACTION_VALUE);
            extraJson.putOpt(KEY_METHOD, KEY_METHOD_VALUE);

            JSONObject data = new JSONObject();
            data.putOpt("InteractiveChannel", "COSMOTE_OMNI");
            data.putOpt("InteractionPoint", mZone);
            data.putOpt("Session_ID", mCommunicationUuid);
            data.putOpt("OfferAudienceLevel", mOfferAudienceLevel);
            data.putOpt("MSISDN", mOfferAudienceLevel.equals("msisdn") ? mUserMsisdn : "");
            data.putOpt("GUID", "");

            JSONArray parameters = new JSONArray();
            JSONObject param1 = new JSONObject();
            param1.putOpt("Name", "UACIOfferTrackingCode");
            param1.putOpt("Value", mUACIOfferTrackingCode);
            param1.putOpt("Type", "string");
            parameters.put(param1);

            JSONObject param2 = new JSONObject();
            param2.putOpt("Name", "UACICustomLoggerTableName");
            param2.putOpt("Value", "VW_WHITELIST");
            param2.putOpt("Type", "string");
            parameters.put(param2);

            JSONObject param3 = new JSONObject();
            param3.putOpt("Name", "MSISDN");
            param3.putOpt("Value", mUserMsisdn);
            param3.putOpt("Type", "string");
            parameters.put(param3);

            JSONObject param4 = new JSONObject();
            param4.putOpt("Name", "OFFERCODE1");
            param4.putOpt("Value", mOfferCode1);
            param4.putOpt("Type", "string");
            parameters.put(param4);

            JSONObject param5 = new JSONObject();
            param5.putOpt("Name", "SCORE");
            param5.putOpt("Value", mScore);
            param5.putOpt("Type", "INT");
            parameters.put(param5);

            JSONObject param6 = new JSONObject();
            param6.putOpt("Name", "PREDICATE");
            param6.putOpt("Value", "0");
            param6.putOpt("Type", "string");
            parameters.put(param6);

            JSONObject param7 = new JSONObject();
            param7.putOpt("Name", "ZONE");
            param7.putOpt("Value", mZone);
            param7.putOpt("Type", "string");
            parameters.put(param7);

            JSONObject param8 = new JSONObject();
            param8.putOpt("Name", "APPLICATIONNAME");
            param8.putOpt("Value", mZone);
            param8.putOpt("Type", "string");
            parameters.put(param8);

            JSONObject param9 = new JSONObject();
            param9.putOpt("Name", "Session_ID");
            param9.putOpt("Value", mCommunicationUuid);
            param9.putOpt("Type", "string");
            parameters.put(param9);

            JSONObject param10 = new JSONObject();
            param10.putOpt("Name", "CAMPAIGN_CODE");
            param10.putOpt("Value", "MCC_00006");
            param10.putOpt("Type", "string");
            parameters.put(param10);

            JSONObject param11 = new JSONObject();
            param11.putOpt("Name", "CAMPAIGN_TYPE");
            param11.putOpt("Value", "Inbound");
            param11.putOpt("Type", "string");
            parameters.put(param11);

            JSONObject param12 = new JSONObject();
            param12.putOpt("Name", "UACIResponseTypeCode");
            param12.putOpt("Value", "CON");
            param12.putOpt("Type", "string");
            parameters.put(param12);

            JSONObject param13 = new JSONObject();
            param13.putOpt("Name", "CHANNEL");
            param13.putOpt("Value", "ONE_APP");
            param13.putOpt("Type", "string");
            parameters.put(param13);

            JSONObject param14 = new JSONObject();
            param14.putOpt("Name", "WAVE");
            param14.putOpt("Value", mWave);
            param14.putOpt("Type", "string");
            parameters.put(param14);

            JSONObject param15 = new JSONObject();
            param15.putOpt("Name", "RESPONSECHANNEL");
            param15.putOpt("Value", "ONE_APP");
            param15.putOpt("Type", "string");
            parameters.put(param15);

            JSONObject param16 = new JSONObject();
            param16.putOpt("Name", "VALIDITY");
            param16.putOpt("Value", mValidity);
            param16.putOpt("Type", "INT");
            parameters.put(param16);

            JSONObject param17 = new JSONObject();
            param17.putOpt("Name", "TREATMENT_CODE");
            param17.putOpt("Value", mTreatmentCode);
            param17.putOpt("Type", "string");
            parameters.put(param17);

            JSONObject param18 = new JSONObject();
            param18.putOpt("Name", "EventName");
            param18.putOpt("Value", "INTEREST_P");
            param18.putOpt("Type", "string");
            parameters.put(param18);

            data.putOpt(KEY_PARAMETERS, parameters);

            extraJson.putOpt(KEY_DATA, data);
            bodyJsonObject.putOpt(KEY_MAPP, extraJson);
        } catch (JSONException e) {
            if (WarpConstants.DEBUG)
                e.printStackTrace();
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = mFilters != null && mFilters.size() > 0 ? String.valueOf(mFilters.hashCode()) : "default_cosmote_post_event_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString(hash, Base64.NO_WRAP);
        } catch (NullPointerException | NoSuchAlgorithmException
                | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }
}
