package ly.warp.sdk.io.request;

import android.util.Base64;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 15-July-22.
 */

public class CosmoteSubmitOrderRequest {

    // ===========================================================
    // Constants
    // ===========================================================

    private final String KEY_MAPP = "wallet";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "add_product";
    private final String KEY_PRODUCT_UUID = "product_uuid";
    private final String KEY_PRODUCT_UUID_VALUE = "011d21908d984e3cbecbdfd2920a5d3b";
    private final String KEY_COMMUNICATION_UUID = "communication_uuid";
    private final String KEY_EXTRA_DATA = "extra_data";
    private final String KEY_USER_MSISDN = "user_msisdn";
    private final String KEY_BUSINESS_SERVICE = "businessService";
    private final String KEY_OFFER_NAME = "offerName";
    private final String KEY_PRODUCT_TYPE = "productType";
    private final String KEY_PROV_DURATION = "provDuration";
    private final String KEY_NO_OF_RECURRANCE = "noOfRecurrance";
    private final String KEY_PRICE = "price";
    private final String KEY_DISCOUNT = "discount";
    private final String KEY_VOICE_CATEGORY = "voiceCategory";
    private final String KEY_DATA_CATEGORY = "dataCategory";
    private final String KEY_MINS_VALUE = "minsValue";
    private final String KEY_DATA_VALUE = "dataValue";
    private final String KEY_PROV_STEP_VALUE_MINS = "provStepValueMins";
    private final String KEY_PARAMETERS = "parameters";

    // ===========================================================
    // Fields
    // ===========================================================

    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0;
    private String mCommunicationUuid = "";
    private String mUserMsisdn = "";
    private String mBusinessService = "";
    private String mOfferName = "";
    private String mProductType = "";
    private String mProvDuration = "";
    private String mNoOfRecurrance = "";
    private String mPrice = "";
    private String mDiscount = "";
    private String mVoiceCategory = "";
    private String mDataCategory = "";
    private String mMinsValue = "";
    private String mDataValue = "";
    private String mProvStepValueMins = "";
    private String mOfferAudienceLevel = "";
    private String mUACIOfferTrackingCode = "";
    private String mOfferCode1 = "";
    private String mScore = "";
    private String mZone = "";
    private String mWave = "";
    private String mValidity = "";
    private String mTreatmentCode = "";
    private String mSessionId = "";
    private String mNotificationMessage = "";

    // ===========================================================
    // Constructor
    // ===========================================================

    /**
     * Default constructor of CosmoteSharingRequest, initializes an empty filters HashMap
     */
    public CosmoteSubmitOrderRequest() {
        mFilters = new HashMap<>();
    }

    public CosmoteSubmitOrderRequest(CosmoteSubmitOrderRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public boolean equals(Object object) {
        if (object instanceof CosmoteSubmitOrderRequest) {
            CosmoteSubmitOrderRequest other = (CosmoteSubmitOrderRequest) object;
            return other == this || (this.mFilters == other.mFilters || (this.mFilters != null && this.mFilters.equals(other.mFilters)));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return mFilters.hashCode();
    }

    // ===========================================================
    // Methods
    // ===========================================================

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    public CosmoteSubmitOrderRequest setCommunicationUuid(String communicationUuid) {
        this.mCommunicationUuid = communicationUuid;
        return this;
    }

    public CosmoteSubmitOrderRequest setUserMsisdn(String userMsisdn) {
        this.mUserMsisdn = userMsisdn;
        return this;
    }

    public CosmoteSubmitOrderRequest setBusinessService(String businessService) {
        this.mBusinessService = businessService;
        return this;
    }

    public CosmoteSubmitOrderRequest setOfferName(String offerName) {
        this.mOfferName = offerName;
        return this;
    }

    public CosmoteSubmitOrderRequest setProductType(String productType) {
        this.mProductType = productType;
        return this;
    }

    public CosmoteSubmitOrderRequest setProvDuration(String provDuration) {
        this.mProvDuration = provDuration;
        return this;
    }

    public CosmoteSubmitOrderRequest setNoOfRecurrance(String noOfRecurrance) {
        this.mNoOfRecurrance = noOfRecurrance;
        return this;
    }

    public CosmoteSubmitOrderRequest setPrice(String price) {
        this.mPrice = price;
        return this;
    }

    public CosmoteSubmitOrderRequest setDiscount(String discount) {
        this.mDiscount = discount;
        return this;
    }

    public CosmoteSubmitOrderRequest setVoiceCategory(String voiceCategory) {
        this.mVoiceCategory = voiceCategory;
        return this;
    }

    public CosmoteSubmitOrderRequest setDataCategory(String dataCategory) {
        this.mDataCategory = dataCategory;
        return this;
    }

    public CosmoteSubmitOrderRequest setMinsValue(String minsValue) {
        this.mMinsValue = minsValue;
        return this;
    }

    public CosmoteSubmitOrderRequest setDataValue(String dataValue) {
        this.mDataValue = dataValue;
        return this;
    }

    public CosmoteSubmitOrderRequest setProvStepValueMins(String provStepValueMins) {
        this.mProvStepValueMins = provStepValueMins;
        return this;
    }

    public CosmoteSubmitOrderRequest setOfferAudienceLevel(String offerAudienceLevel) {
        this.mOfferAudienceLevel = offerAudienceLevel;
        return this;
    }

    public CosmoteSubmitOrderRequest setUACIOfferTrackingCode(String uaciOfferTrackingCode) {
        this.mUACIOfferTrackingCode = uaciOfferTrackingCode;
        return this;
    }

    public CosmoteSubmitOrderRequest setOfferCode1(String offerCode1) {
        this.mOfferCode1 = offerCode1;
        return this;
    }

    public CosmoteSubmitOrderRequest setScore(String score) {
        this.mScore = score;
        return this;
    }

    public CosmoteSubmitOrderRequest setZone(String zone) {
        this.mZone = zone;
        return this;
    }

    public CosmoteSubmitOrderRequest setWave(String wave) {
        this.mWave = wave;
        return this;
    }

    public CosmoteSubmitOrderRequest setValidity(String validity) {
        this.mValidity = validity;
        return this;
    }

    public CosmoteSubmitOrderRequest setTreatmentCode(String treatmentCode) {
        this.mTreatmentCode = treatmentCode;
        return this;
    }

    public CosmoteSubmitOrderRequest setSessionId(String sessionId) {
        this.mSessionId = sessionId;
        return this;
    }

    public CosmoteSubmitOrderRequest setNotificationMessage(String notificationMessage) {
        this.mNotificationMessage = notificationMessage;
        return this;
    }

    /**
     * Call this to get how often the cached data will be updated.
     *
     * @return mCacheUpdateInterval
     */
    public long getCacheUpdateInterval() {
        return mCacheUpdateInterval;
    }

    /**
     * Call this to set how often the cached data will be updated.
     *
     * @param updateInterval The time that data will be cached
     * @return CosmoteSubmitOrderRequest
     */
    public CosmoteSubmitOrderRequest setCacheUpdateInterval(long updateInterval) {

        this.mCacheUpdateInterval = updateInterval;
        if (mCacheUpdateInterval < 0) {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to check if the Application uses Cache
     *
     * @return <p>true - the Application is using Cache</p>
     * <p>false - the Application is not using Cache</p>
     */
    public boolean isUseCache() {
        return mCacheUpdateInterval > 0;
    }

    /**
     * Call this to check whether the cached data need to be updated
     *
     * @param useCache <p>true - the Application is using Cache</p>
     *                 <p>false - the Application is not using Cache</p>
     * @return CosmoteSubmitOrderRequest
     */
    public CosmoteSubmitOrderRequest setUseCache(boolean useCache) {

        if (useCache) {
            mCacheUpdateInterval = mCacheUpdateInterval > 0 ? mCacheUpdateInterval
                    : WarpConstants.INBOX_UPDATE_INTERVAL;
        } else {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to build the offers Json object
     *
     * @return bodyJsonObject
     */
    public JSONObject toJson() {
        JSONObject bodyJsonObject = new JSONObject();
        try {
            JSONObject extraJson = new JSONObject();
            extraJson.putOpt(KEY_ACTION, KEY_ACTION_VALUE);
            extraJson.putOpt(KEY_PRODUCT_UUID, KEY_PRODUCT_UUID_VALUE);
            extraJson.putOpt(KEY_COMMUNICATION_UUID, mCommunicationUuid);

            JSONObject extraData = new JSONObject();
            extraData.putOpt(KEY_USER_MSISDN, mUserMsisdn);
            extraData.putOpt(KEY_BUSINESS_SERVICE, mBusinessService);
            extraData.putOpt(KEY_OFFER_NAME, mOfferName);
            extraData.putOpt(KEY_PRODUCT_TYPE, mProductType);
            extraData.putOpt(KEY_PROV_DURATION, mProvDuration);
            extraData.putOpt(KEY_NO_OF_RECURRANCE, mNoOfRecurrance);
            extraData.putOpt(KEY_PRICE, mPrice);
            extraData.putOpt(KEY_DISCOUNT, mDiscount);
            extraData.putOpt(KEY_VOICE_CATEGORY, mVoiceCategory);
            extraData.putOpt(KEY_DATA_CATEGORY, mDataCategory);
            extraData.putOpt(KEY_MINS_VALUE, mMinsValue);
            extraData.putOpt(KEY_DATA_VALUE, mDataValue);
            extraData.putOpt(KEY_PROV_STEP_VALUE_MINS, mProvStepValueMins);
            extraData.putOpt("InteractiveChannel", "COSMOTE_OMNI");
            extraData.putOpt("InteractionPoint", mZone);
            extraData.putOpt("Session_ID", mSessionId);
            extraData.putOpt("OfferAudienceLevel", mOfferAudienceLevel);
            extraData.putOpt("MSISDN", mOfferAudienceLevel.equals("msisdn") ? mUserMsisdn : "");
            extraData.putOpt("GUID", "");
            extraData.putOpt("notificationMessage", mNotificationMessage);

            JSONArray parameters = new JSONArray();
            JSONObject param1 = new JSONObject();
            param1.putOpt("Name", "UACIOfferTrackingCode");
            param1.putOpt("Value", mUACIOfferTrackingCode);
            param1.putOpt("Type", "string");
            parameters.put(param1);

            JSONObject param2 = new JSONObject();
            param2.putOpt("Name", "UACICustomLoggerTableName");
            param2.putOpt("Value", "VW_WHITELIST");
            param2.putOpt("Type", "string");
            parameters.put(param2);

            JSONObject param3 = new JSONObject();
            param3.putOpt("Name", "MSISDN");
            param3.putOpt("Value", mUserMsisdn);
            param3.putOpt("Type", "string");
            parameters.put(param3);

            JSONObject param4 = new JSONObject();
            param4.putOpt("Name", "OFFERCODE1");
            param4.putOpt("Value", mOfferCode1);
            param4.putOpt("Type", "string");
            parameters.put(param4);

            JSONObject param5 = new JSONObject();
            param5.putOpt("Name", "SCORE");
            param5.putOpt("Value", mScore);
            param5.putOpt("Type", "INT");
            parameters.put(param5);

            JSONObject param6 = new JSONObject();
            param6.putOpt("Name", "PREDICATE");
            param6.putOpt("Value", "0");
            param6.putOpt("Type", "string");
            parameters.put(param6);

            JSONObject param7 = new JSONObject();
            param7.putOpt("Name", "ZONE");
            param7.putOpt("Value", mZone);
            param7.putOpt("Type", "string");
            parameters.put(param7);

            JSONObject param8 = new JSONObject();
            param8.putOpt("Name", "APPLICATIONNAME");
            param8.putOpt("Value", mZone);
            param8.putOpt("Type", "string");
            parameters.put(param8);

            JSONObject param9 = new JSONObject();
            param9.putOpt("Name", "Session_ID");
            param9.putOpt("Value", mSessionId);
            param9.putOpt("Type", "string");
            parameters.put(param9);

            JSONObject param10 = new JSONObject();
            param10.putOpt("Name", "CAMPAIGN_CODE");
            param10.putOpt("Value", "MCC_00006");
            param10.putOpt("Type", "string");
            parameters.put(param10);

            JSONObject param11 = new JSONObject();
            param11.putOpt("Name", "CAMPAIGN_TYPE");
            param11.putOpt("Value", "Inbound");
            param11.putOpt("Type", "string");
            parameters.put(param11);

            JSONObject param12 = new JSONObject();
            param12.putOpt("Name", "UACIResponseTypeCode");
            param12.putOpt("Value", "CON");
            param12.putOpt("Type", "string");
            parameters.put(param12);

            JSONObject param13 = new JSONObject();
            param13.putOpt("Name", "CHANNEL");
            param13.putOpt("Value", "ONE_APP");
            param13.putOpt("Type", "string");
            parameters.put(param13);

            JSONObject param14 = new JSONObject();
            param14.putOpt("Name", "WAVE");
            param14.putOpt("Value", mWave);
            param14.putOpt("Type", "string");
            parameters.put(param14);

            JSONObject param15 = new JSONObject();
            param15.putOpt("Name", "RESPONSECHANNEL");
            param15.putOpt("Value", "ONE_APP");
            param15.putOpt("Type", "string");
            parameters.put(param15);

            JSONObject param16 = new JSONObject();
            param16.putOpt("Name", "VALIDITY");
            param16.putOpt("Value", mValidity);
            param16.putOpt("Type", "INT");
            parameters.put(param16);

            JSONObject param17 = new JSONObject();
            param17.putOpt("Name", "TREATMENT_CODE");
            param17.putOpt("Value", mTreatmentCode);
            param17.putOpt("Type", "string");
            parameters.put(param17);

            JSONObject param18 = new JSONObject();
            param18.putOpt("Name", "EventName");
            param18.putOpt("Value", "INTEREST_P");
            param18.putOpt("Type", "string");
            parameters.put(param18);

            extraData.putOpt(KEY_PARAMETERS, parameters);

            extraJson.putOpt(KEY_EXTRA_DATA, extraData);
            bodyJsonObject.putOpt(KEY_MAPP, extraJson);
        } catch (JSONException e) {
            if (WarpConstants.DEBUG)
                e.printStackTrace();
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = mFilters != null && mFilters.size() > 0 ? String.valueOf(mFilters.hashCode()) : "default_cosmote_submit_order_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString(hash, Base64.NO_WRAP);
        } catch (NullPointerException | NoSuchAlgorithmException
                | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }
}
