package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 17-Jan-22.
 */

public class WarplyAddAddressRequest {

    // ===========================================================
    // Constants
    // ===========================================================

    private final String KEY_MAPP = "consumer_data";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "handle_addresses_new";
    private final String KEY_PROCESS = "process";
    private final String KEY_PROCESS_VALUE = "add";
    private final String KEY_DATA = "data";
    private final String KEY_FRIENDLY_NAME = "friendly_name";
    private final String KEY_ADDRESS_NAME = "address_name";
    private final String KEY_ADDRESS_NUMBER = "address_number";
    private final String KEY_POSTAL_CODE = "postal_code";
    private final String KEY_FLOOR_NUMBER = "floor_number";
    private final String KEY_DOORBELL = "doorbel";
    private final String KEY_REGION = "region";
    private final String KEY_LATITUDE = "latitude";
    private final String KEY_LONGITUTDE = "longitude";
    private final String KEY_NOTES = "notes";

    // ===========================================================
    // Fields
    // ===========================================================

    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0;
    private String mFriendlyName = "";
    private String mAddressName = "";
    private String mAddressNumber = "0";
    private String mPostalCode = "";
    private int mFloorNumber = 0;
    private String mDoorbell = "";
    private String mRegion = "";
    private String mLat = null;
    private String mLon = null;
    private String mNotes = "";

    // ===========================================================
    // Constructor
    // ===========================================================

    /**
     * Default constructor of WarplyAddAddressRequest, initializes an empty filters HashMap
     */
    public WarplyAddAddressRequest() {
        mFilters = new HashMap<>();
    }

    public WarplyAddAddressRequest(WarplyAddAddressRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public boolean equals(Object object) {
        if (object instanceof WarplyAddAddressRequest) {
            WarplyAddAddressRequest other = (WarplyAddAddressRequest) object;
            return other == this || (this.mFilters == other.mFilters || (this.mFilters != null && this.mFilters.equals(other.mFilters)));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return mFilters.hashCode();
    }

    // ===========================================================
    // Methods
    // ===========================================================

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    public WarplyAddAddressRequest setFriendlyName(String friendlyName) {
        mFriendlyName = friendlyName;
        return this;
    }

    public WarplyAddAddressRequest setAddressName(String addressName) {
        mAddressName = addressName;
        return this;
    }

    public WarplyAddAddressRequest setAddressNumber(String addressNumber) {
        mAddressNumber = addressNumber;
        return this;
    }

    public WarplyAddAddressRequest setPostalCode(String postalCode) {
        mPostalCode = postalCode;
        return this;
    }

    public WarplyAddAddressRequest setFloorNumber(int floorNumber) {
        mFloorNumber = floorNumber;
        return this;
    }

    public WarplyAddAddressRequest setDoorbell(String doorbell) {
        mDoorbell = doorbell;
        return this;
    }

    public WarplyAddAddressRequest setRegion(String region) {
        mRegion = region;
        return this;
    }

    public WarplyAddAddressRequest setLatitude(String lat) {
        mLat = lat;
        return this;
    }

    public WarplyAddAddressRequest setLongitude(String lon) {
        mLon = lon;
        return this;
    }

    public WarplyAddAddressRequest setNotes(String notes) {
        mNotes = notes;
        return this;
    }

    /**
     * Call this to get how often the cached data will be updated.
     *
     * @return mCacheUpdateInterval
     */
    public long getCacheUpdateInterval() {
        return mCacheUpdateInterval;
    }

    /**
     * Call this to set how often the cached data will be updated.
     *
     * @param updateInterval The time that data will be cached
     * @return WarplyEditConsumerRequest
     */
    public WarplyAddAddressRequest setCacheUpdateInterval(long updateInterval) {

        this.mCacheUpdateInterval = updateInterval;
        if (mCacheUpdateInterval < 0) {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to check if the Application uses Cache
     *
     * @return <p>true - the Application is using Cache</p>
     * <p>false - the Application is not using Cache</p>
     */
    public boolean isUseCache() {
        return mCacheUpdateInterval > 0;
    }

    /**
     * Call this to check whether the cached data need to be updated
     *
     * @param useCache <p>true - the Application is using Cache</p>
     *                 <p>false - the Application is not using Cache</p>
     * @return WarplyEditConsumerRequest
     */
    public WarplyAddAddressRequest setUseCache(boolean useCache) {

        if (useCache) {
            mCacheUpdateInterval = mCacheUpdateInterval > 0 ? mCacheUpdateInterval
                    : WarpConstants.INBOX_UPDATE_INTERVAL;
        } else {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to build the offers Json object
     *
     * @return bodyJsonObject
     */
    public JSONObject toJson() {
        JSONObject bodyJsonObject = new JSONObject();
        try {
            JSONObject extraJson = new JSONObject();
            extraJson.putOpt(KEY_ACTION, KEY_ACTION_VALUE);
            extraJson.putOpt(KEY_PROCESS, KEY_PROCESS_VALUE);

            JSONObject data = new JSONObject();
            data.putOpt(KEY_FRIENDLY_NAME, mFriendlyName);
            data.putOpt(KEY_ADDRESS_NAME, mAddressName);
            data.putOpt(KEY_ADDRESS_NUMBER, mAddressNumber);
            data.putOpt(KEY_POSTAL_CODE, mPostalCode);
            data.putOpt(KEY_FLOOR_NUMBER, mFloorNumber);
            data.putOpt(KEY_DOORBELL, mDoorbell);
            data.putOpt(KEY_REGION, mRegion);
            data.putOpt(KEY_LATITUDE, mLat);
            data.putOpt(KEY_LONGITUTDE, mLon);
            data.putOpt(KEY_NOTES, mNotes);
            extraJson.putOpt(KEY_DATA, data);
            bodyJsonObject.putOpt(KEY_MAPP, extraJson);
        } catch (JSONException e) {
            if (WarpConstants.DEBUG)
                e.printStackTrace();
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = mFilters != null && mFilters.size() > 0 ? String.valueOf(mFilters.hashCode()) : "default_add_address_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString(hash, Base64.NO_WRAP);
        } catch (NullPointerException | NoSuchAlgorithmException
                | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }
}
