package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 07-Jan-22.
 */

public class WarplyEditConsumerRequest {

    // ===========================================================
    // Constants
    // ===========================================================

    private final String KEY_MAPP = "consumer_data";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "handle_user_details";
    private final String KEY_PROCESS = "process";
    private final String KEY_PROCESS_VALUE = "edit";
    private final String KEY_DEL_EMPTY = "del_empty";
    private final String KEY_DATA = "data";
    private final String KEY_FIRST_NAME = "firstname";
    private final String KEY_LAST_NAME = "lastname";
    private final String KEY_EMAIL = "email";
    private final String KEY_SALUTATION = "salutation";
    private final String KEY_MSISDN = "msisdn";
    private final String KEY_NICKNAME = "nickname";
    private final String KEY_GENDER = "gender";
    private final String KEY_BIRTHDAY = "birthday";
    private final String KEY_OPTIN = "optin";
    private final String KEY_NEWSLETTER = "newsletter";
    private final String KEY_SMS = "sms";
    private final String KEY_PERSON_NEWSLETTER = "segmentation";
    private final String KEY_PERSON_SMS = "sms_segmentation";
    private final String KEY_NAMEDAY = "nameday";
    private final String KEY_PROFILE_METADATA = "profile_metadata";
    private final String KEY_TAX_ID = "tax_id";

    // ===========================================================
    // Fields
    // ===========================================================

    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0;
    private String mFirstName = "";
    private String mLastName = "";
    private String mEmail = "";
    private String mSalutation = "";
    private String mMsisdn = "";
    private String mNickname = "";
    private String mGender = "";
    private String mBirthday = "";
    private boolean mNewsletter = false;
    private boolean mSms = false;
    private boolean mPersonalizedNewsletter = false;
    private boolean mPersonalizedSms = false;
    private boolean mOptin = false;
    private String mNameday = "";
    private boolean mHasProfileMetadata = false;
    private JSONObject mProfileMetadata = new JSONObject();
    private String mTaxId = "";

    // ===========================================================
    // Constructor
    // ===========================================================

    /**
     * Default constructor of WarplyEditConsumerRequest, initializes an empty filters HashMap
     */
    public WarplyEditConsumerRequest() {
        mFilters = new HashMap<>();
    }

    public WarplyEditConsumerRequest(WarplyEditConsumerRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public boolean equals(Object object) {
        if (object instanceof WarplyEditConsumerRequest) {
            WarplyEditConsumerRequest other = (WarplyEditConsumerRequest) object;
            return other == this || (this.mFilters == other.mFilters || (this.mFilters != null && this.mFilters.equals(other.mFilters)));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return mFilters.hashCode();
    }

    // ===========================================================
    // Methods
    // ===========================================================

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    public WarplyEditConsumerRequest setOptin(boolean optin) {
        mOptin = optin;
        return this;
    }

    public WarplyEditConsumerRequest setHasProfileMetadata(boolean hasProfileMetadata) {
        mHasProfileMetadata = hasProfileMetadata;
        return this;
    }

    public WarplyEditConsumerRequest setProfileMetadata(JSONObject profileMetadata) {
        mProfileMetadata = profileMetadata;
        return this;
    }

    public WarplyEditConsumerRequest setFirstName(String firstname) {
        mFirstName = firstname;
        return this;
    }

    public WarplyEditConsumerRequest setLastName(String lastname) {
        mLastName = lastname;
        return this;
    }

    public WarplyEditConsumerRequest setEmail(String email) {
        mEmail = email;
        return this;
    }

    public WarplyEditConsumerRequest setSalutation(String salutation) {
        mSalutation = salutation;
        return this;
    }

    public WarplyEditConsumerRequest setMsisdn(String msisdn) {
        mMsisdn = msisdn;
        return this;
    }

    public WarplyEditConsumerRequest setNickname(String nickname) {
        mNickname = nickname;
        return this;
    }

    public WarplyEditConsumerRequest setGender(String gender) {
        mGender = gender;
        return this;
    }

    public WarplyEditConsumerRequest setBirthDate(String birthDate) {
        mBirthday = birthDate;
        return this;
    }

    public WarplyEditConsumerRequest setNameday(String nameday) {
        mNameday = nameday;
        return this;
    }

    public WarplyEditConsumerRequest setNewsletter(boolean newsletter) {
        mNewsletter = newsletter;
        return this;
    }

    public WarplyEditConsumerRequest setSms(boolean sms) {
        mSms = sms;
        return this;
    }

    public WarplyEditConsumerRequest setPersonalizedNewsletter(boolean personalizedNewsletter) {
        mPersonalizedNewsletter = personalizedNewsletter;
        return this;
    }

    public WarplyEditConsumerRequest setPersonalizedSms(boolean personalizedSms) {
        mPersonalizedSms = personalizedSms;
        return this;
    }

    public WarplyEditConsumerRequest setTaxId(String taxId) {
        mTaxId = mTaxId;
        return this;
    }

    /**
     * Call this to get how often the cached data will be updated.
     *
     * @return mCacheUpdateInterval
     */
    public long getCacheUpdateInterval() {
        return mCacheUpdateInterval;
    }

    /**
     * Call this to set how often the cached data will be updated.
     *
     * @param updateInterval The time that data will be cached
     * @return WarplyEditConsumerRequest
     */
    public WarplyEditConsumerRequest setCacheUpdateInterval(long updateInterval) {

        this.mCacheUpdateInterval = updateInterval;
        if (mCacheUpdateInterval < 0) {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to check if the Application uses Cache
     *
     * @return <p>true - the Application is using Cache</p>
     * <p>false - the Application is not using Cache</p>
     */
    public boolean isUseCache() {
        return mCacheUpdateInterval > 0;
    }

    /**
     * Call this to check whether the cached data need to be updated
     *
     * @param useCache <p>true - the Application is using Cache</p>
     *                 <p>false - the Application is not using Cache</p>
     * @return WarplyEditConsumerRequest
     */
    public WarplyEditConsumerRequest setUseCache(boolean useCache) {

        if (useCache) {
            mCacheUpdateInterval = mCacheUpdateInterval > 0 ? mCacheUpdateInterval
                    : WarpConstants.INBOX_UPDATE_INTERVAL;
        } else {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to build the offers Json object
     *
     * @return bodyJsonObject
     */
    public JSONObject toJson() {
        JSONObject bodyJsonObject = new JSONObject();
        try {
            JSONObject extraJson = new JSONObject();
            extraJson.putOpt(KEY_ACTION, KEY_ACTION_VALUE);
            extraJson.putOpt(KEY_PROCESS, KEY_PROCESS_VALUE);
            extraJson.putOpt(KEY_DEL_EMPTY, false);

            JSONObject data = new JSONObject();
            if (!TextUtils.isEmpty(mFirstName))
                data.putOpt(KEY_FIRST_NAME, mFirstName);
            if (!TextUtils.isEmpty(mLastName))
                data.putOpt(KEY_LAST_NAME, mLastName);
            if (!TextUtils.isEmpty(mEmail))
                data.putOpt(KEY_EMAIL, mEmail);
            if (!TextUtils.isEmpty(mSalutation))
                data.putOpt(KEY_SALUTATION, mSalutation);
            if (!TextUtils.isEmpty(mMsisdn))
                data.putOpt(KEY_MSISDN, mMsisdn);
            if (!TextUtils.isEmpty(mNickname))
                data.putOpt(KEY_NICKNAME, mNickname);
            if (!TextUtils.isEmpty(mGender))
                data.putOpt(KEY_GENDER, mGender);
            if (!TextUtils.isEmpty(mBirthday))
                data.putOpt(KEY_BIRTHDAY, mBirthday);
            if (!TextUtils.isEmpty(mNameday))
                data.putOpt(KEY_NAMEDAY, mNameday);
            if (mOptin) {
                JSONObject optin = new JSONObject();
                optin.put(KEY_NEWSLETTER, mNewsletter);
                optin.put(KEY_SMS, mSms);
                optin.put(KEY_PERSON_NEWSLETTER, mPersonalizedNewsletter);
                optin.put(KEY_PERSON_SMS, mPersonalizedSms);
                data.putOpt(KEY_OPTIN, optin);
            }
            if (mHasProfileMetadata) {
                data.putOpt(KEY_PROFILE_METADATA, mProfileMetadata);
            }
            if (!TextUtils.isEmpty(mTaxId))
                data.putOpt(KEY_TAX_ID, mTaxId);
            extraJson.putOpt(KEY_DATA, data);

            bodyJsonObject.putOpt(KEY_MAPP, extraJson);
        } catch (JSONException e) {
            if (WarpConstants.DEBUG)
                e.printStackTrace();
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = mFilters != null && mFilters.size() > 0 ? String.valueOf(mFilters.hashCode()) : "default_edit_consumer_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString(hash, Base64.NO_WRAP);
        } catch (NullPointerException | NoSuchAlgorithmException
                | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }
}
