/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.io.request;

import android.content.Context;
import android.text.format.DateFormat;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

import ly.warp.sdk.Warply;
import ly.warp.sdk.io.volley.AuthFailureError;
import ly.warp.sdk.io.volley.Response.ErrorListener;
import ly.warp.sdk.io.volley.Response.Listener;
import ly.warp.sdk.io.volley.toolbox.JsonObjectRequest;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyDeviceInfoCollector;
import ly.warp.sdk.utils.constants.WarpConstants;

public class WarplyJsonObjectRequest extends JsonObjectRequest {

    public WarplyJsonObjectRequest(int method, String url,
                                   JSONObject jsonRequest, Listener<JSONObject> listener,
                                   ErrorListener errorListener) {
        super(method, url, jsonRequest, listener, errorListener);
    }

    @Override
    public Map<String, String> getHeaders() throws AuthFailureError {
        Map<String, String> headers = new HashMap<>();
        Context context = Warply.getWarplyContext();
        String timeStamp = DateFormat.format("yyyy-MM-dd hh:mm:ss", System.currentTimeMillis()).toString();
        headers.put(WarpConstants.HEADER_LOYALTY_BUNDLE_ID, "android:" + context.getPackageName());
        headers.put(WarpConstants.HEADER_DATE, timeStamp);
        headers.put(WarpConstants.HEADER_UNIQUE_DEVICE_ID, new WarplyDeviceInfoCollector(context).getUniqueDeviceId());
//        headers.put(WarpConstants.HEADER_ADVERTISING_ID, new WarplyDeviceInfoCollector(context).getAdvertisementId());
        headers.put(WarpConstants.HEADER_CHANNEL, "mobile");
        if (WarpUtils.isRegisteredWarply(context)) {
            String apiKey = WarpUtils.getApiKey(context);
            String webId = WarpUtils.getWebId(context);
            headers.put(WarpConstants.HEADER_WEB_ID, webId);
            headers.put(WarpConstants.HEADER_SIGNATURE, WarpUtils.produceSignature(apiKey + timeStamp));
        }
        return headers;
    }
}
