package ly.warp.sdk.io.request;

import android.util.Base64;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 04-Feb-22.
 */

public class WarplyRedeemCouponRequest {

    // ===========================================================
    // Constants
    // ===========================================================

    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "retrieve_coupon";
    private final String KEY_COUPONSET = "coupon_set";
    private final String KEY_COMMUNICATION_UUID = "communication_uuid";
    private final String KEY_EXTRA_DATA = "extra_data";
    private final String KEY_USER_MSISDN = "user_msisdn";
    private final String KEY_BUSINESS_SERVICE = "businessService";
    private final String KEY_OFFER_NAME = "offerName";
    private final String KEY_PRODUCT_TYPE = "productType";
    private final String KEY_PROV_DURATION = "provDuration";
    private final String KEY_NO_OF_RECURRANCE = "noOfRecurrance";
    private final String KEY_PRICE = "price";
    private final String KEY_DISCOUNT = "discount";
    private final String KEY_VOICE_CATEGORY = "voiceCategory";
    private final String KEY_DATA_CATEGORY = "dataCategory";
    private final String KEY_MINS_VALUE = "minsValue";
    private final String KEY_DATA_VALUE = "dataValue";
    private final String KEY_PROV_STEP_VALUE_MINS = "provStepValueMins";
    private final String KEY_PARAMETERS = "parameters";

    // ===========================================================
    // Fields
    // ===========================================================

    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0;
    private String mCouponsetUuid = "";
    private String mCommunicationUuid = "";
    private boolean mHasContextualOffer = false;
    private String mUserMsisdn = "";
    private String mBusinessService = "";
    private String mOfferName = "";
    private String mProductType = "";
    private String mProvDuration = "";
    private String mNoOfRecurrance = "";
    private String mPrice = "";
    private String mDiscount = "";
    private String mVoiceCategory = "";
    private String mDataCategory = "";
    private String mMinsValue = "";
    private String mDataValue = "";
    private String mProvStepValueMins = "";
    private String mOfferAudienceLevel = "";
    private String mUACIOfferTrackingCode = "";
    private String mOfferCode1 = "";
    private String mScore = "";
    private String mZone = "";
    private String mWave = "";
    private String mValidity = "";
    private String mTreatmentCode = "";
    private String mSessionId = "";

    // ===========================================================
    // Constructor
    // ===========================================================

    /**
     * Default constructor of WarplyRedeemCouponRequest, initializes an empty filters HashMap
     */
    public WarplyRedeemCouponRequest() {
        mFilters = new HashMap<>();
    }

    public WarplyRedeemCouponRequest(WarplyRedeemCouponRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public boolean equals(Object object) {
        if (object instanceof WarplyRedeemCouponRequest) {
            WarplyRedeemCouponRequest other = (WarplyRedeemCouponRequest) object;
            return other == this || (this.mFilters == other.mFilters || (this.mFilters != null && this.mFilters.equals(other.mFilters)));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return mFilters.hashCode();
    }

    // ===========================================================
    // Methods
    // ===========================================================

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    public WarplyRedeemCouponRequest setCouponsetUuid(String uuid) {
        mCouponsetUuid = uuid;
        return this;
    }

    public WarplyRedeemCouponRequest setCommunicationUuid(String uuid) {
        mCommunicationUuid = uuid;
        return this;
    }

    public WarplyRedeemCouponRequest setHasContextualOffer(boolean hasContextualOffer) {
        mHasContextualOffer = hasContextualOffer;
        return this;
    }

    public WarplyRedeemCouponRequest setUserMsisdn(String userMsisdn) {
        this.mUserMsisdn = userMsisdn;
        return this;
    }

    public WarplyRedeemCouponRequest setBusinessService(String businessService) {
        this.mBusinessService = businessService;
        return this;
    }

    public WarplyRedeemCouponRequest setOfferName(String offerName) {
        this.mOfferName = offerName;
        return this;
    }

    public WarplyRedeemCouponRequest setProductType(String productType) {
        this.mProductType = productType;
        return this;
    }

    public WarplyRedeemCouponRequest setProvDuration(String provDuration) {
        this.mProvDuration = provDuration;
        return this;
    }

    public WarplyRedeemCouponRequest setNoOfRecurrance(String noOfRecurrance) {
        this.mNoOfRecurrance = noOfRecurrance;
        return this;
    }

    public WarplyRedeemCouponRequest setPrice(String price) {
        this.mPrice = price;
        return this;
    }

    public WarplyRedeemCouponRequest setDiscount(String discount) {
        this.mDiscount = discount;
        return this;
    }

    public WarplyRedeemCouponRequest setVoiceCategory(String voiceCategory) {
        this.mVoiceCategory = voiceCategory;
        return this;
    }

    public WarplyRedeemCouponRequest setDataCategory(String dataCategory) {
        this.mDataCategory = dataCategory;
        return this;
    }

    public WarplyRedeemCouponRequest setMinsValue(String minsValue) {
        this.mMinsValue = minsValue;
        return this;
    }

    public WarplyRedeemCouponRequest setDataValue(String dataValue) {
        this.mDataValue = dataValue;
        return this;
    }

    public WarplyRedeemCouponRequest setProvStepValueMins(String provStepValueMins) {
        this.mProvStepValueMins = provStepValueMins;
        return this;
    }

    public WarplyRedeemCouponRequest setOfferAudienceLevel(String offerAudienceLevel) {
        this.mOfferAudienceLevel = offerAudienceLevel;
        return this;
    }

    public WarplyRedeemCouponRequest setUACIOfferTrackingCode(String uaciOfferTrackingCode) {
        this.mUACIOfferTrackingCode = uaciOfferTrackingCode;
        return this;
    }

    public WarplyRedeemCouponRequest setOfferCode1(String offerCode1) {
        this.mOfferCode1 = offerCode1;
        return this;
    }

    public WarplyRedeemCouponRequest setScore(String score) {
        this.mScore = score;
        return this;
    }

    public WarplyRedeemCouponRequest setZone(String zone) {
        this.mZone = zone;
        return this;
    }

    public WarplyRedeemCouponRequest setWave(String wave) {
        this.mWave = wave;
        return this;
    }

    public WarplyRedeemCouponRequest setValidity(String validity) {
        this.mValidity = validity;
        return this;
    }

    public WarplyRedeemCouponRequest setTreatmentCode(String treatmentCode) {
        this.mTreatmentCode = treatmentCode;
        return this;
    }

    public WarplyRedeemCouponRequest setSessionId(String sessionId) {
        this.mSessionId = sessionId;
        return this;
    }

    /**
     * Call this to get how often the cached data will be updated.
     *
     * @return mCacheUpdateInterval
     */
    public long getCacheUpdateInterval() {
        return mCacheUpdateInterval;
    }

    /**
     * Call this to set how often the cached data will be updated.
     *
     * @param updateInterval The time that data will be cached
     * @return WarplyRedeemCouponRequest
     */
    public WarplyRedeemCouponRequest setCacheUpdateInterval(long updateInterval) {

        this.mCacheUpdateInterval = updateInterval;
        if (mCacheUpdateInterval < 0) {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to check if the Application uses Cache
     *
     * @return <p>true - the Application is using Cache</p>
     * <p>false - the Application is not using Cache</p>
     */
    public boolean isUseCache() {
        return mCacheUpdateInterval > 0;
    }

    /**
     * Call this to check whether the cached data need to be updated
     *
     * @param useCache <p>true - the Application is using Cache</p>
     *                 <p>false - the Application is not using Cache</p>
     * @return WarplyRedeemCouponRequest
     */
    public WarplyRedeemCouponRequest setUseCache(boolean useCache) {

        if (useCache) {
            mCacheUpdateInterval = mCacheUpdateInterval > 0 ? mCacheUpdateInterval
                    : WarpConstants.INBOX_UPDATE_INTERVAL;
        } else {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to build the redeem coupon Json object
     *
     * @return bodyJsonObject
     */
    public JSONObject toJson() {
        JSONObject bodyJsonObject = new JSONObject();
        try {
            bodyJsonObject.putOpt(KEY_ACTION, KEY_ACTION_VALUE);
            bodyJsonObject.putOpt(KEY_COUPONSET, mCouponsetUuid);
            bodyJsonObject.putOpt(KEY_COMMUNICATION_UUID, mCommunicationUuid);
            if (mHasContextualOffer) {
                JSONObject extraJson = new JSONObject();
                extraJson.putOpt(KEY_USER_MSISDN, mUserMsisdn);
                extraJson.putOpt(KEY_BUSINESS_SERVICE, mBusinessService);
                extraJson.putOpt(KEY_OFFER_NAME, mOfferName);
                extraJson.putOpt(KEY_PRODUCT_TYPE, mProductType);
                extraJson.putOpt(KEY_PROV_DURATION, mProvDuration);
                extraJson.putOpt(KEY_NO_OF_RECURRANCE, mNoOfRecurrance);
                extraJson.putOpt(KEY_PRICE, mPrice);
                extraJson.putOpt(KEY_DISCOUNT, mDiscount);
                extraJson.putOpt(KEY_VOICE_CATEGORY, mVoiceCategory);
                extraJson.putOpt(KEY_DATA_CATEGORY, mDataCategory);
                extraJson.putOpt(KEY_MINS_VALUE, mMinsValue);
                extraJson.putOpt(KEY_DATA_VALUE, mDataValue);
                extraJson.putOpt(KEY_PROV_STEP_VALUE_MINS, mProvStepValueMins);
                extraJson.putOpt("InteractiveChannel", "COSMOTE_OMNI");
                extraJson.putOpt("InteractionPoint", mZone);
                extraJson.putOpt("Session_ID", mSessionId);
                extraJson.putOpt("OfferAudienceLevel", mOfferAudienceLevel);
                extraJson.putOpt("MSISDN", mOfferAudienceLevel.equals("msisdn") ? mUserMsisdn : "");
                extraJson.putOpt("GUID", "");

                JSONArray parameters = new JSONArray();
                JSONObject param1 = new JSONObject();
                param1.putOpt("Name", "UACIOfferTrackingCode");
                param1.putOpt("Value", mUACIOfferTrackingCode);
                param1.putOpt("Type", "string");
                parameters.put(param1);

                JSONObject param2 = new JSONObject();
                param2.putOpt("Name", "UACICustomLoggerTableName");
                param2.putOpt("Value", "VW_WHITELIST");
                param2.putOpt("Type", "string");
                parameters.put(param2);

                JSONObject param3 = new JSONObject();
                param3.putOpt("Name", "MSISDN");
                param3.putOpt("Value", mUserMsisdn);
                param3.putOpt("Type", "string");
                parameters.put(param3);

                JSONObject param4 = new JSONObject();
                param4.putOpt("Name", "OFFERCODE1");
                param4.putOpt("Value", mOfferCode1);
                param4.putOpt("Type", "string");
                parameters.put(param4);

                JSONObject param5 = new JSONObject();
                param5.putOpt("Name", "SCORE");
                param5.putOpt("Value", mScore);
                param5.putOpt("Type", "INT");
                parameters.put(param5);

                JSONObject param6 = new JSONObject();
                param6.putOpt("Name", "PREDICATE");
                param6.putOpt("Value", "0");
                param6.putOpt("Type", "string");
                parameters.put(param6);

                JSONObject param7 = new JSONObject();
                param7.putOpt("Name", "ZONE");
                param7.putOpt("Value", mZone);
                param7.putOpt("Type", "string");
                parameters.put(param7);

                JSONObject param8 = new JSONObject();
                param8.putOpt("Name", "APPLICATIONNAME");
                param8.putOpt("Value", mZone);
                param8.putOpt("Type", "string");
                parameters.put(param8);

                JSONObject param9 = new JSONObject();
                param9.putOpt("Name", "Session_ID");
                param9.putOpt("Value", mSessionId);
                param9.putOpt("Type", "string");
                parameters.put(param9);

                JSONObject param10 = new JSONObject();
                param10.putOpt("Name", "CAMPAIGN_CODE");
                param10.putOpt("Value", "MCC_00006");
                param10.putOpt("Type", "string");
                parameters.put(param10);

                JSONObject param11 = new JSONObject();
                param11.putOpt("Name", "CAMPAIGN_TYPE");
                param11.putOpt("Value", "Inbound");
                param11.putOpt("Type", "string");
                parameters.put(param11);

                JSONObject param12 = new JSONObject();
                param12.putOpt("Name", "UACIResponseTypeCode");
                param12.putOpt("Value", "CON");
                param12.putOpt("Type", "string");
                parameters.put(param12);

                JSONObject param13 = new JSONObject();
                param13.putOpt("Name", "CHANNEL");
                param13.putOpt("Value", "ONE_APP");
                param13.putOpt("Type", "string");
                parameters.put(param13);

                JSONObject param14 = new JSONObject();
                param14.putOpt("Name", "WAVE");
                param14.putOpt("Value", mWave);
                param14.putOpt("Type", "string");
                parameters.put(param14);

                JSONObject param15 = new JSONObject();
                param15.putOpt("Name", "RESPONSECHANNEL");
                param15.putOpt("Value", "ONE_APP");
                param15.putOpt("Type", "string");
                parameters.put(param15);

                JSONObject param16 = new JSONObject();
                param16.putOpt("Name", "VALIDITY");
                param16.putOpt("Value", mValidity);
                param16.putOpt("Type", "INT");
                parameters.put(param16);

                JSONObject param17 = new JSONObject();
                param17.putOpt("Name", "TREATMENT_CODE");
                param17.putOpt("Value", mTreatmentCode);
                param17.putOpt("Type", "string");
                parameters.put(param17);

                JSONObject param18 = new JSONObject();
                param18.putOpt("Name", "EventName");
                param18.putOpt("Value", "INTEREST_P");
                param18.putOpt("Type", "string");
                parameters.put(param18);

                extraJson.putOpt(KEY_PARAMETERS, parameters);

                bodyJsonObject.putOpt(KEY_EXTRA_DATA, extraJson);
            }
        } catch (JSONException e) {
            if (WarpConstants.DEBUG)
                e.printStackTrace();
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = mFilters != null && mFilters.size() > 0 ? String.valueOf(mFilters.hashCode()) : "default_redeem_coupon_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString(hash, Base64.NO_WRAP);
        } catch (NullPointerException | NoSuchAlgorithmException
                | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }
}
