package ly.warp.sdk.io.request;

import android.text.TextUtils;
import android.util.Base64;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;

/**
 * Created by Panagiotis Triantafyllou on 24-Dec-21.
 */

public class WarplyRegisterRequest {

    // ===========================================================
    // Constants
    // ===========================================================

    private final String KEY_ID = "id";
    private final String KEY_PASSWORD = "password";
    private final String KEY_WEB_ID = "web_id";
    private final String KEY_FIRST_NAME = "first_name";
    private final String KEY_LAST_NAME = "last_name";
    private final String KEY_EMAIL = "email";
    private final String KEY_SALUTATION = "salutation";
    private final String KEY_MSISDN = "msisdn";
    private final String KEY_NICKNAME = "nickname";
    private final String KEY_GENDER = "gender";
    private final String KEY_BIRTHDAY = "birthday";
    private final String KEY_OPTIN = "optin";
    private final String KEY_NEWSLETTER = "newsletter";
    private final String KEY_SMS = "sms";
    private final String KEY_PERSON_NEWSLETTER = "segmentation";
    private final String KEY_PERSON_SMS = "sms_segmentation";

    // ===========================================================
    // Fields
    // ===========================================================

    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0;
    private String mId = "";
    private String mPassword = "";
    private String mFirstName = "";
    private String mLastName = "";
    private String mEmail = "";
    private String mSalutation = "";
    private String mMsisdn = "";
    private String mNickname = "";
    private String mGender = "";
    private String mBirthday = "";
    private boolean mNewsletter = false;
    private boolean mSms = false;
    private boolean mPersonalizedNewsletter = false;
    private boolean mPersonalizedSms = false;
    private boolean mAutologin = false;

    // ===========================================================
    // Constructor
    // ===========================================================

    /**
     * Default constructor of WarplyRegisterRequest, initializes an empty filters HashMap
     */
    public WarplyRegisterRequest() {
        mFilters = new HashMap<>();
    }

    public WarplyRegisterRequest(WarplyRegisterRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public boolean equals(Object object) {
        if (object instanceof WarplyRegisterRequest) {
            WarplyRegisterRequest other = (WarplyRegisterRequest) object;
            return other == this || (this.mFilters == other.mFilters || (this.mFilters != null && this.mFilters.equals(other.mFilters)));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return mFilters.hashCode();
    }

    // ===========================================================
    // Methods
    // ===========================================================

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    public WarplyRegisterRequest setId(String id) {
        mId = id;
        return this;
    }

    public WarplyRegisterRequest setPassword(String password) {
        mPassword = password;
        return this;
    }

    public WarplyRegisterRequest setFirstName(String firstname) {
        mFirstName = firstname;
        return this;
    }

    public WarplyRegisterRequest setLastName(String lastname) {
        mLastName = lastname;
        return this;
    }

    public WarplyRegisterRequest setEmail(String email) {
        mEmail = email;
        return this;
    }

    public WarplyRegisterRequest setSalutation(String salutation) {
        mSalutation = salutation;
        return this;
    }

    public WarplyRegisterRequest setMsisdn(String msisdn) {
        mMsisdn = msisdn;
        return this;
    }

    public WarplyRegisterRequest setNickname(String nickname) {
        mNickname = nickname;
        return this;
    }

    public WarplyRegisterRequest setGender(String gender) {
        mGender = gender;
        return this;
    }

    public WarplyRegisterRequest setBirthDate(String birthDate) {
        mBirthday = birthDate;
        return this;
    }

    public WarplyRegisterRequest setNewsletter(boolean newsletter) {
        mNewsletter = newsletter;
        return this;
    }

    public WarplyRegisterRequest setSms(boolean sms) {
        mSms = sms;
        return this;
    }

    public WarplyRegisterRequest setPersonalizedNewsletter(boolean personalizedNewsletter) {
        mPersonalizedNewsletter = personalizedNewsletter;
        return this;
    }

    public WarplyRegisterRequest setPersonalizedSms(boolean personalizedSms) {
        mPersonalizedSms = personalizedSms;
        return this;
    }

    public WarplyRegisterRequest setAutologin(boolean autologin) {
        mAutologin = autologin;
        return this;
    }

    /**
     * Call this to get how often the cached data will be updated.
     *
     * @return mCacheUpdateInterval
     */
    public long getCacheUpdateInterval() {
        return mCacheUpdateInterval;
    }

    public boolean getAutologin() { return mAutologin; }

    /**
     * Call this to set how often the cached data will be updated.
     *
     * @param updateInterval The time that data will be cached
     * @return WarplyRegisterRequest
     */
    public WarplyRegisterRequest setCacheUpdateInterval(long updateInterval) {

        this.mCacheUpdateInterval = updateInterval;
        if (mCacheUpdateInterval < 0) {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to check if the Application uses Cache
     *
     * @return <p>true - the Application is using Cache</p>
     * <p>false - the Application is not using Cache</p>
     */
    public boolean isUseCache() {
        return mCacheUpdateInterval > 0;
    }

    /**
     * Call this to check whether the cached data need to be updated
     *
     * @param useCache <p>true - the Application is using Cache</p>
     *                 <p>false - the Application is not using Cache</p>
     * @return WarplyRegisterRequest
     */
    public WarplyRegisterRequest setUseCache(boolean useCache) {

        if (useCache) {
            mCacheUpdateInterval = mCacheUpdateInterval > 0 ? mCacheUpdateInterval
                    : WarpConstants.INBOX_UPDATE_INTERVAL;
        } else {
            mCacheUpdateInterval = 0;
        }
        return this;
    }

    /**
     * Call this to build the offers Json object
     *
     * @return bodyJsonObject
     */
    public JSONObject toJson() {
        JSONObject bodyJsonObject = new JSONObject();
        try {
            bodyJsonObject.putOpt(KEY_ID, TextUtils.isEmpty(mId) ? "" : mId);
            bodyJsonObject.putOpt(KEY_PASSWORD, TextUtils.isEmpty(mPassword) ? "" : mPassword);
            bodyJsonObject.putOpt(KEY_FIRST_NAME, TextUtils.isEmpty(mFirstName) ? "" : mFirstName);
            bodyJsonObject.putOpt(KEY_LAST_NAME, TextUtils.isEmpty(mLastName) ? "" : mLastName);
            bodyJsonObject.putOpt(KEY_EMAIL, TextUtils.isEmpty(mEmail) ? "" : mEmail);
            bodyJsonObject.putOpt(KEY_SALUTATION, TextUtils.isEmpty(mSalutation) ? "" : mSalutation);
            bodyJsonObject.putOpt(KEY_MSISDN, TextUtils.isEmpty(mMsisdn) ? "" : mMsisdn);
            bodyJsonObject.putOpt(KEY_NICKNAME, TextUtils.isEmpty(mNickname) ? "" : mNickname);
            bodyJsonObject.putOpt(KEY_GENDER, TextUtils.isEmpty(mGender) ? "" : mGender);
            bodyJsonObject.putOpt(KEY_BIRTHDAY, TextUtils.isEmpty(mBirthday) ? "" : mBirthday);
            bodyJsonObject.putOpt(KEY_WEB_ID, WarpUtils.getWebId(Warply.getWarplyContext()));
            JSONObject optin = new JSONObject();
            optin.put(KEY_NEWSLETTER, mNewsletter);
            optin.put(KEY_SMS, mSms);
            optin.put(KEY_PERSON_NEWSLETTER, mPersonalizedNewsletter);
            optin.put(KEY_PERSON_SMS, mPersonalizedSms);
            bodyJsonObject.putOpt(KEY_OPTIN, optin);
        } catch (JSONException e) {
            if (WarpConstants.DEBUG)
                e.printStackTrace();
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = mFilters != null && mFilters.size() > 0 ? String.valueOf(mFilters.hashCode()) : "default_register_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString(hash, Base64.NO_WRAP);
        } catch (NullPointerException | NoSuchAlgorithmException
                | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }
}
