package ly.warp.sdk.io.volley;

import ly.warp.sdk.utils.constants.WarpConstants;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * Created by Panagiotis Triantafyllou on 24/Νοε/2022.
 */
public interface ApiService {
    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    // ===========================================================
    // Methods
    // ===========================================================

    @Headers("Content-Type: application/json")
    @POST("/api/mobile/v2/{appUuid}/context/")
    Call<ResponseBody> getCouponsets(@Path("appUuid") String appUuid,
                                     @Body RequestBody request,
                                     @Header(WarpConstants.HEADER_DATE) String timeStamp,
                                     @Header(WarpConstants.HEADER_LOYALTY_BUNDLE_ID) String bundleId,
                                     @Header(WarpConstants.HEADER_UNIQUE_DEVICE_ID) String deviceId,
                                     @Header(WarpConstants.HEADER_CHANNEL) String channel,
                                     @Header(WarpConstants.HEADER_WEB_ID) String webId,
                                     @Header(WarpConstants.HEADER_SIGNATURE) String signature);

    @Headers("Content-Type: application/json")
    @POST("/oauth/{appUuid}/context")
    Call<ResponseBody> getUserCoupons(@Path("appUuid") String appUuid,
                                      @Body RequestBody request,
                                      @Header(WarpConstants.HEADER_DATE) String timeStamp,
                                      @Header(WarpConstants.HEADER_LOYALTY_BUNDLE_ID) String bundleId,
                                      @Header(WarpConstants.HEADER_UNIQUE_DEVICE_ID) String deviceId,
                                      @Header(WarpConstants.HEADER_CHANNEL) String channel,
                                      @Header(WarpConstants.HEADER_WEB_ID) String webId,
                                      @Header(WarpConstants.HEADER_SIGNATURE) String signature,
                                      @Header(WarpConstants.HEADER_AUTHORIZATION) String bearer);

    @Headers("Content-Type: application/json")
    @POST("/oauth/{appUuid}/context")
    Call<ResponseBody> getUnifiedCoupons(@Path("appUuid") String appUuid,
                                         @Body RequestBody request,
                                         @Header(WarpConstants.HEADER_DATE) String timeStamp,
                                         @Header(WarpConstants.HEADER_LOYALTY_BUNDLE_ID) String bundleId,
                                         @Header(WarpConstants.HEADER_UNIQUE_DEVICE_ID) String deviceId,
                                         @Header(WarpConstants.HEADER_CHANNEL) String channel,
                                         @Header(WarpConstants.HEADER_WEB_ID) String webId,
                                         @Header(WarpConstants.HEADER_SIGNATURE) String signature,
                                         @Header(WarpConstants.HEADER_AUTHORIZATION) String bearer);

    @Headers("Content-Type: application/json")
    @POST("/api/mobile/v2/{appUuid}/context/")
    Call<ResponseBody> getMerchants(@Path("appUuid") String appUuid,
                                    @Body RequestBody request,
                                    @Header(WarpConstants.HEADER_DATE) String timeStamp,
                                    @Header(WarpConstants.HEADER_LOYALTY_BUNDLE_ID) String bundleId,
                                    @Header(WarpConstants.HEADER_UNIQUE_DEVICE_ID) String deviceId,
                                    @Header(WarpConstants.HEADER_CHANNEL) String channel,
                                    @Header(WarpConstants.HEADER_WEB_ID) String webId,
                                    @Header(WarpConstants.HEADER_SIGNATURE) String signature);

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================
}
