package ly.warp.sdk.receivers;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarpUtils;

/**
 * A {@link BroadcastReceiver} used to receive a Bluetooth state change event
 * <p/>
 * The receiver must be specified on the application's AndroidManifest.xml file
 * with an {@link android.content.IntentFilter} that has the action below:
 * <p/>
 * {@code <action android:name="android.bluetooth.adapter.action.STATE_CHANGED" />}
 * <p/>
 * if Bluetooth is activated, the receiver will initialize the {@link WarplyBeaconsApplication} if needed
 */
public class BluetoothStateChangeReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {

        final String action = intent.getAction();

        if (BluetoothAdapter.ACTION_STATE_CHANGED.equals(action)) {
            final int state = intent.getIntExtra(BluetoothAdapter.EXTRA_STATE,
                    BluetoothAdapter.ERROR);

            WarpUtils.log(WarplyBeaconsApplication.TAG + "onReceive BluetoothStateChangeReceiver");

            switch (state) {
                case BluetoothAdapter.STATE_ON:

                    if (!Warply.isInitialized()) {
                        Warply.getInitializer(context).init();
                    }
                    Warply.initBeaconsApplicationIfNeed();

                    break;
                default:
                    break;
            }
        }
    }
}
