/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package ly.warp.sdk.receivers;

import ly.warp.sdk.utils.managers.WarplyLocationManager;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarplyPreferences;
import ly.warp.sdk.services.UpdateUserLocationService;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationManager;

import java.util.HashMap;
import java.util.Map;

public class LocationChangedReceiver extends BroadcastReceiver {

    protected static String TAG = "LocationChangedReceiver";
    public static Warply wClient;
    public static boolean isAppShutDown;

    @Override
    public void onReceive(Context context, Intent intent) {
        isAppShutDown = WarplyLocationManager.waprplyContext == null;

        /**
         * if app is in foreground or in background then warpClient instance is
         * active. If app is closed warpClient instance is inactive(null) thus
         * we have to create a new one.
         */
        if (wClient == null) {
            Warply.getInitializer(context).init();
            wClient = Warply.INSTANCE;
        }

        if (intent.hasExtra(LocationManager.KEY_PROVIDER_ENABLED) && !intent.getBooleanExtra(LocationManager.KEY_PROVIDER_ENABLED, true)) {
            context.sendBroadcast(new Intent("ACTIVE_LOCATION_UPDATE_PROVIDER_DISABLED"));
        }

        if (intent.hasExtra(LocationManager.KEY_LOCATION_CHANGED)) {
            new WarplyPreferences(context).saveUpdateLocationServiceStatus("on");

            Location location = (Location) intent.getExtras().get(LocationManager.KEY_LOCATION_CHANGED);

            Map<String, Object> mLocValues = new HashMap<>();
            mLocValues.put("latitude", location.getLatitude());
            mLocValues.put("longitude", location.getLongitude());
            UpdateUserLocationService.scheduleWork(context, mLocValues);
        }
    }
}