package ly.warp.sdk.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

import ly.warp.sdk.services.WarpInAppNotificationService;

import static ly.warp.sdk.services.WarpInAppNotificationService.KEY_BUTTON;
import static ly.warp.sdk.services.WarpInAppNotificationService.KEY_HEADS_UP;
import static ly.warp.sdk.services.WarpInAppNotificationService.KEY_SUBTITLE;
import static ly.warp.sdk.services.WarpInAppNotificationService.KEY_TITLE;
import static ly.warp.sdk.services.WarpInAppNotificationService.KEY_UID;

/**
 * Created by Panos Triantafyllou on 14/03/2018.
 */
public class WarplyInAppNotificationReceiver extends BroadcastReceiver {

    public WarplyInAppNotificationReceiver() {
    }

    @Override
    public void onReceive(Context context, Intent intent) {

        Intent intentService = new Intent(context, WarpInAppNotificationService.class)
                .putExtra(KEY_UID, intent.getIntExtra(KEY_UID, 0))
                .putExtra(KEY_TITLE, intent.getStringExtra(KEY_TITLE))
                .putExtra(KEY_SUBTITLE, intent.getStringExtra(KEY_SUBTITLE))
                .putExtra(KEY_HEADS_UP, intent.getBooleanExtra(KEY_HEADS_UP, false));
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
//            context.startForegroundService(intentService);
//        } else {
            context.startService(intentService);
//        }
    }
}