package ly.warp.sdk.services;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.Worker;
import androidx.work.WorkerParameters;

import org.greenrobot.eventbus.EventBus;

import java.util.ArrayList;

import ly.warp.sdk.Warply;
import ly.warp.sdk.activities.CouponsetInfoActivity;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.CouponsEventModel;
import ly.warp.sdk.io.models.LoyaltyEventModel;
import ly.warp.sdk.io.models.WarplyCouponsChangedEventModel;
import ly.warp.sdk.io.request.WarplyGetCampaignsRequest;
import ly.warp.sdk.io.request.WarplyUserCouponsRequest;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;

/**
 * Created by Panagiotis Triantafyllou on 05/Sept/2022.
 */
public class EventCampaignCouponService extends Worker {

    public EventCampaignCouponService(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    @Override
    public Result doWork() {
        WarplyManager.getUserCouponsWithCouponsets(mUserCouponsReceiver);
        WarplyManager.getCampaigns(new WarplyGetCampaignsRequest().setLanguage("en"), mCampaignsCallback);

        return Result.success();
    }

    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>() {
        @Override
        public void onSuccess(CouponList result) {
            WarplyCouponsChangedEventModel couponsChanged = new WarplyCouponsChangedEventModel();
            couponsChanged.setChanged(true);
            EventBus.getDefault().post(new WarplyEventBusManager(couponsChanged));
        }

        @Override
        public void onFailure(int errorCode) {
            Thread.currentThread().interrupt();
        }
    };

    private CallbackReceiver<ArrayList<Campaign>> mCampaignsCallback = new CallbackReceiver<ArrayList<Campaign>>() {
        @Override
        public void onSuccess(ArrayList<Campaign> result) {
            LoyaltyEventModel campaignsAdded = new LoyaltyEventModel();
            EventBus.getDefault().post(new WarplyEventBusManager(campaignsAdded));
        }

        @Override
        public void onFailure(int errorCode) {
            Thread.currentThread().interrupt();
        }
    };
}
