package ly.warp.sdk.services;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.work.Worker;
import androidx.work.WorkerParameters;

import org.greenrobot.eventbus.EventBus;

import ly.warp.sdk.io.models.LoyaltyEventModel;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;

/**
 * Created by Panagiotis Triantafyllou on 21/Ιουλ/2022.
 */
public class EventCampaignService extends Worker {

    public EventCampaignService(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    @Override
    public Result doWork() {
        LoyaltyEventModel campaignsAdded = new LoyaltyEventModel();
        EventBus.getDefault().post(new WarplyEventBusManager(campaignsAdded));

        return Result.success();
    }
}
