package ly.warp.sdk.services;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.work.Worker;
import androidx.work.WorkerParameters;

import org.greenrobot.eventbus.EventBus;

import ly.warp.sdk.io.models.CouponsEventModel;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;

/**
 * Created by Panagiotis Triantafyllou on 05/Sept/2022.
 */
public class EventCouponsService extends Worker {

    public EventCouponsService(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    @Override
    public Result doWork() {
        CouponsEventModel couponsAdded = new CouponsEventModel();
        EventBus.getDefault().post(new WarplyEventBusManager(couponsAdded));

        return Result.success();
    }
}
