package ly.warp.sdk.services;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.work.Worker;
import androidx.work.WorkerParameters;

import org.json.JSONObject;

import java.util.ArrayList;

import ly.warp.sdk.Warply;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.Consumer;
import ly.warp.sdk.io.request.WarplyConsumerRequest;
import ly.warp.sdk.io.request.WarplyGetCampaignsRequest;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyManager;

/**
 * Created by Panagiotis Triantafyllou on 22/Ιουλ/2022.
 */
public class EventQuestionnaireService extends Worker {

    public EventQuestionnaireService(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    @Override
    public Result doWork() {
        WarplyManager.getConsumer(new WarplyConsumerRequest(), new CallbackReceiver<Consumer>() {
            @Override
            public void onSuccess(Consumer result) {
                WarplyManagerHelper.setConsumerInternal(result);

                if (result != null) {
                    JSONObject profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata());
                    if (profMetadata != null && profMetadata.has("nonTelco")) {
                        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), profMetadata.optBoolean("nonTelco"));
                    } else {
                        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
                    }
                }

                WarplyManager.getCampaigns(new WarplyGetCampaignsRequest().setLanguage("en"), new CallbackReceiver<ArrayList<Campaign>>() {
                    @Override
                    public void onSuccess(ArrayList<Campaign> result) {
                        WarpUtils.log("SUCCESS_QUESTIONNAIRE_EVENT");
                    }

                    @Override
                    public void onFailure(int errorCode) {
                        WarpUtils.log("ERROR_QUESTIONNAIRE_EVENT " + String.valueOf(errorCode));
                    }
                });
            }

            @Override
            public void onFailure(int errorCode) {
                WarpUtils.log("ERROR_QUESTIONNAIRE_CONSUMER_EVENT " + String.valueOf(errorCode));
            }
        });

        return Result.success();
    }
}
