/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.services;

import static ly.warp.sdk.utils.constants.WarpConstants.CHANNEL_ID;

import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.RemoteViews;

import androidx.core.app.NotificationCompat;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.List;

import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.PushCampaign;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyProperty;

public abstract class WarpBaseIntentService extends IntentService {

    private static final String KEY_TITLE = "alert";
    private static final String KEY_SUBTITLE = "subtitle";
    private static final String KEY_TICKER = "alert";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_PAYLOAD = "payload";

    public WarpBaseIntentService() {
        super("WarpBaseIntentService");
    }

    public static void showCampaignNotification(Context context, PushCampaign pc) {
        showCampaignNotification(context, pc, null);
    }

    public static void showCampaignNotification(Context context, PushCampaign pc, List<NotificationCompat.Action> actions) {
        showCampaignNotification(context, pc, null, null);
    }

    public static void showCampaignNotification(Context context, PushCampaign pc, List<NotificationCompat.Action> actions, RemoteViews remoteViews) {

        WarpUtils.log("Showing campaign with session UUID: " + pc.getSessionUUID());

        SecureRandom randomGenerator = new SecureRandom();

        int uid = randomGenerator.nextInt(1000);
        if (!TextUtils.isEmpty(pc.getSessionUUID())) {
            uid = 0;
        }

        Intent newIntent = WarpViewActivity.createIntentFromSessionUUID(
                context, pc.getSessionUUID(), "from_notification_status");
        newIntent.setAction(Long.toString(System.currentTimeMillis()));

        NotificationCompat.Builder b = new NotificationCompat.Builder(context, CHANNEL_ID);

        if (pc.getNotificationStyle().equalsIgnoreCase(PushCampaign.NOTIFICATION_STYLE_BIG_PICTURE)
                && !TextUtils.isEmpty(pc.getBigPictureUrl())) {
            //get big picture style
            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
            bigPictureStyle.bigPicture(loadDrawable(pc.getBigPictureUrl()));
            if (!TextUtils.isEmpty(pc.getSubtitle())) {
                bigPictureStyle.setSummaryText(pc.getSubtitle());
            }
            b.setStyle(bigPictureStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase(PushCampaign.NOTIFICATION_STYLE_BIG_TEXT)
                && !TextUtils.isEmpty(pc.getBigText())) {
            //get big picture style
            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            bigTextStyle.bigText(pc.getBigText());
            if (!TextUtils.isEmpty(pc.getSummaryText())) {
                bigTextStyle.setSummaryText(pc.getSummaryText());
            }

            b.setStyle(bigTextStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase(PushCampaign.NOTIFICATION_STYLE_INBOX_STYLE)) {
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            for (int i = 0; i < pc.getInboxLines().size(); i++) {
                inboxStyle.addLine(pc.getInboxLines().get(i));
            }
            if (!TextUtils.isEmpty(pc.getSummaryText())) {
                inboxStyle.setSummaryText(pc.getSummaryText());
            }
            b.setStyle(inboxStyle);
        }

        b.setDefaults(Notification.DEFAULT_VIBRATE | Notification.DEFAULT_LIGHTS);
        b.setTicker(pc.getTicker());
//        b.setChannelId(CHANNEL_ID);
        b.setContentTitle(pc.getTitle());
        b.setContentText(pc.getSubtitle());
        b.setSubText(pc.getContent());
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            b.setContentIntent(PendingIntent.getActivity(context, uid, newIntent, PendingIntent.FLAG_ONE_SHOT | PendingIntent.FLAG_MUTABLE));
        } else {
            b.setContentIntent(PendingIntent.getActivity(context, uid, newIntent, PendingIntent.FLAG_ONE_SHOT));
        }
        b.setAutoCancel(true);
        b.setOngoing(true);
        b.setAutoCancel(true);
        b.setSmallIcon(WarplyProperty.getPushIconResId(context));
        b.setLargeIcon(loadDrawable(pc.getImageUrl()));

        //Add remote view as content if exists
        if (remoteViews != null) {
            b.setContent(remoteViews);
        }

        if (pc.getSoundUri(context) == null)
            b.setSound(RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION));
        else
            b.setSound(pc.getSoundUri(context));


        //If push has color
        int color = WarplyProperty.getPushColor(context);
        if (!TextUtils.isEmpty(pc.getColor())) {
            try {
                color = Color.parseColor(pc.getColor());
            } catch (IllegalArgumentException iae) {
            }
        }
        b.setColor(color);

        //add actions
        if (actions != null) {
            if (actions.size() > 0) {
                for (NotificationCompat.Action action : actions) {
                    b.addAction(action);
                }
            }
        }


        NotificationManager nm = (NotificationManager) context.getSystemService(NOTIFICATION_SERVICE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && nm != null) {
            NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID, "notification_channel", NotificationManager.IMPORTANCE_DEFAULT);

//            notificationChannel.setDescription("Channel description");
//            notificationChannel.enableLights(true);
//            notificationChannel.setLightColor(color);
//            notificationChannel.setVibrationPattern(new long[]{0, 1000, 500, 1000});
//            notificationChannel.enableVibration(true);

            nm.createNotificationChannel(notificationChannel);
//            Notification notification_build_with_largeicon = b.setChannelId(CHANNEL_ID).build();
            b.build().flags = Notification.FLAG_AUTO_CANCEL; //notification with only large icon due to the two build notificaition is not canceled from bar
            nm.notify(pc.getSessionUUID(), uid, b.build());
        } else {
            Notification notification_build_with_largeicon = b.build();
            b.build().flags = Notification.FLAG_AUTO_CANCEL; //notification with only large icon due to the two build notificaition is not canceled from bar
            nm.notify(pc.getSessionUUID(), uid, b.build());
        }
    }


    public void showDefaultNotification(Context context, Bundle data) {

        String title = getNotificationTitle(data);
        String ticker = getNotificationTicker(data);
        String message = getNotificationMessage(data);

        PushCampaign pc = new PushCampaign(data);

        if (pc != null) {
            PackageManager pm = context.getPackageManager();
            Intent newIntent = pm.getLaunchIntentForPackage(context
                    .getPackageName());

            showNotification(context, pc, newIntent, null, null, null, 0);
        }

    }

    /*
    public void showNotification(Context context, String title, String ticker,
                                 String message, Intent newIntent, String tag, int id) {

        SecureRandom randomGenerator = new SecureRandom();
        int uid = randomGenerator.nextInt(1000);
        WarpUtils.log("Showing notification with tag: " + tag + " and id: "
                + id);

        NotificationCompat.Builder builder = new NotificationCompat.Builder(
                context);
        int imageResource;
        int colorResource = 0;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            imageResource = context.getResources().getIdentifier("ic_notification_24dp",
                    "drawable", context.getPackageName());
            colorResource = context.getResources().getIdentifier("push_notifications_color", "color", context.getPackageName());
        } else {
            imageResource = context.getResources().getIdentifier("ic_notification_logo",
                    "drawable", context.getPackageName());
        }
        if (imageResource == 0) {
            imageResource = android.R.drawable.btn_star;
        }
        if (colorResource != 0) {
            builder.setColor(context.getResources().getColor(colorResource));
        }

        builder.setSmallIcon(imageResource);
        builder.setContentTitle(title).setContentText(message)
                .setSmallIcon(imageResource)
                .setAutoCancel(true);
        builder.setDefaults(Notification.DEFAULT_ALL);
        builder.setAutoCancel(true);
        builder.setOngoing(true);

        newIntent.setAction(Long.toString(System.currentTimeMillis()));
        PendingIntent pi;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            pi = PendingIntent.getActivity(context, uid, newIntent, PendingIntent.FLAG_ONE_SHOT | PendingIntent.FLAG_MUTABLE);
        } else {
            pi = PendingIntent.getActivity(context, uid, newIntent, PendingIntent.FLAG_ONE_SHOT);
        }
        builder.setContentIntent(pi);

        NotificationManager nm = (NotificationManager) context
                .getSystemService(NOTIFICATION_SERVICE);
        Notification notification_build = builder.build();
        notification_build.flags = Notification.FLAG_AUTO_CANCEL;
        nm.notify(tag, uid, notification_build);
    }*/

    public void showNotification(Context context, PushCampaign pc, Intent newIntent, List<NotificationCompat.Action> actions, RemoteViews remoteViews, String tag, int id) {

        SecureRandom randomGenerator = new SecureRandom();
        int uid = randomGenerator.nextInt(1000);
        if (id > 0) {
            uid = id;
        }
        WarpUtils.log("Showing notification with tag: " + tag + " and id: "
                + id);

        NotificationCompat.Builder b = new NotificationCompat.Builder(context, CHANNEL_ID);

        if (pc.getNotificationStyle().equalsIgnoreCase(PushCampaign.NOTIFICATION_STYLE_BIG_PICTURE)
                && !TextUtils.isEmpty(pc.getBigPictureUrl())) {
            //get big picture style
            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
            bigPictureStyle.bigPicture(loadDrawable(pc.getBigPictureUrl()));
            if (!TextUtils.isEmpty(pc.getSubtitle())) {
                bigPictureStyle.setSummaryText(pc.getSubtitle());
            }
            b.setStyle(bigPictureStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase(PushCampaign.NOTIFICATION_STYLE_BIG_TEXT)
                && !TextUtils.isEmpty(pc.getBigText())) {
            //get big picture style
            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            bigTextStyle.bigText(pc.getBigText());
            if (!TextUtils.isEmpty(pc.getSummaryText())) {
                bigTextStyle.setSummaryText(pc.getSummaryText());
            }

            b.setStyle(bigTextStyle);
        } else if (pc.getNotificationStyle().equalsIgnoreCase(PushCampaign.NOTIFICATION_STYLE_INBOX_STYLE)) {
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            for (int i = 0; i < pc.getInboxLines().size(); i++) {
                inboxStyle.addLine(pc.getInboxLines().get(i));
            }
            if (!TextUtils.isEmpty(pc.getSummaryText())) {
                inboxStyle.setSummaryText(pc.getSummaryText());
            }
            b.setStyle(inboxStyle);
        }

        b.setDefaults(Notification.DEFAULT_VIBRATE | Notification.DEFAULT_LIGHTS);
        b.setTicker(pc.getTicker());
//        b.setChannelId(CHANNEL_ID);
        b.setContentTitle(pc.getTitle());
        b.setContentText(pc.getSubtitle());
        b.setSubText(pc.getContent());
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            b.setContentIntent(PendingIntent.getActivity(context, uid, newIntent, PendingIntent.FLAG_ONE_SHOT | PendingIntent.FLAG_MUTABLE));
        } else {
            b.setContentIntent(PendingIntent.getActivity(context, uid, newIntent, PendingIntent.FLAG_ONE_SHOT));
        }
        b.setAutoCancel(true);
        b.setOngoing(true);
        b.setAutoCancel(true);
        b.setSmallIcon(WarplyProperty.getPushIconResId(context));
        b.setLargeIcon(loadDrawable(pc.getImageUrl()));

        if (remoteViews != null) {
            b.setContent(remoteViews);
        }

        if (pc.getSoundUri(context) == null)
            b.setSound(RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION));
        else
            b.setSound(pc.getSoundUri(context));

        //If push has color
        int color = WarplyProperty.getPushColor(context);
        if (!TextUtils.isEmpty(pc.getColor())) {
            try {
                color = Color.parseColor(pc.getColor());
            } catch (IllegalArgumentException iae) {
            }
        }
        b.setColor(color);

        //add actions
        if (actions != null) {
            if (actions.size() > 0) {
                for (NotificationCompat.Action action : actions) {
                    b.addAction(action);
                }
            }
        }

//      Notification notification_build=b.build();
//      nm.notify(pc.getSessionUUID(), uid, notification_build);

        // Load bitmap from server and update the notification.
        // Do not allow sound or anything else.

        newIntent.setAction(Long.toString(System.currentTimeMillis()));
        PendingIntent pi;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            pi = PendingIntent.getActivity(context, uid, newIntent, PendingIntent.FLAG_ONE_SHOT | PendingIntent.FLAG_MUTABLE);
        } else {
            pi = PendingIntent.getActivity(context, uid, newIntent, PendingIntent.FLAG_ONE_SHOT);
        }
        b.setContentIntent(pi);

        NotificationManager nm = (NotificationManager) context.getSystemService(NOTIFICATION_SERVICE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && nm != null) {
            NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID, "notification_channel", NotificationManager.IMPORTANCE_DEFAULT);
            // Configure the notification channel.
//            notificationChannel.setDescription("Channel description");
//            notificationChannel.enableLights(true);
//            notificationChannel.setLightColor(color);
//            notificationChannel.setVibrationPattern(new long[]{0, 1000, 500, 1000});
//            notificationChannel.enableVibration(true);

            nm.createNotificationChannel(notificationChannel);
//            Notification notification_build = b.setChannelId(CHANNEL_ID).build();
            b.build().flags = Notification.FLAG_AUTO_CANCEL;
            nm.notify(pc.getSessionUUID(), uid, b.build());
        } else {
//            Notification notification_build = b.build();
            b.build().flags = Notification.FLAG_AUTO_CANCEL;
            nm.notify(pc.getSessionUUID(), uid, b.build());
        }
    }


    public JSONObject getPayload(Bundle data) {

        String payloadStr = data.getString(KEY_PAYLOAD);

        try {

            JSONObject payload = new JSONObject(payloadStr);
            return payload;

        } catch (JSONException e) {

            WarpUtils.log("Error with payload", e);
            return null;
        }
    }

    public String getNotificationTitle(Bundle data) {
        return data.getString(KEY_TITLE);
    }

    public String getNotificationMessage(Bundle data) {
        return data.getString(KEY_MESSAGE);
    }

    public String getNotificationTicker(Bundle data) {
        return data.getString(KEY_TICKER);
    }

    public String getNotificationSubtitle(Bundle data) {
        return data.getString(KEY_SUBTITLE);
    }

    private static Bitmap loadDrawable(String url) {
        if (url == null || TextUtils.isEmpty(url))
            return null;


        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(url);
        try {
            HttpResponse response = client.execute(get);
            if (!(response.getStatusLine().getStatusCode() == HttpStatus.SC_OK))
                return null;

            HttpEntity entity = response.getEntity();
            if (entity == null)
                return null;

            InputStream is = entity.getContent();
            if (is == null) {

                entity.consumeContent();
                return null;
            }

            Bitmap b = BitmapFactory.decodeStream(is);
            is.close();
            entity.consumeContent();
            WarpUtils.log("Notification Large Icon Loading: " + "success" + url);
            return b;

        } catch (IOException e) {
            WarpUtils.log("Notification Large Icon Loading: ", e);
            return null;
        }
    }

    private void getSmallIcon(Context context, PushCampaign pc) {


    }


}