package ly.warp.sdk.utils;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Set;

import ly.warp.sdk.utils.constants.WarpConstants;

public class WarplyPreferences {

    private static final String WARPLY_SHARED_PREFS = "ly.warp.sdk.preferences";
    private SharedPreferences warplySharedPrefs;

    public WarplyPreferences(Context context) {
        try {
            MasterKey masterKey = new
                    MasterKey.Builder(context, MasterKey.DEFAULT_MASTER_KEY_ALIAS).
                    setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();

            SharedPreferences encryptedSharedPreferences = EncryptedSharedPreferences.create(
                    context,
                    WARPLY_SHARED_PREFS,
                    masterKey,
                    EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV,
                    EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM
            );

            this.warplySharedPrefs = encryptedSharedPreferences;
        } catch (Exception e) {
            WarpUtils.log("WarplyPreferences Encrypted Shared Preferences Error", e);
            this.warplySharedPrefs = context.
                    getSharedPreferences(WARPLY_SHARED_PREFS, Activity.MODE_PRIVATE);
        }
    }

    public void saveLocationChangedReceiverStatus(String status) {
        warplySharedPrefs.edit().
                putString("locChangedReceiverStatus", status).apply();
    }

    public String getLocationChangedReceiverStatus() {
        return warplySharedPrefs.getString("locChangedReceiverStatus", "off");
    }

    public void saveUpdateLocationServiceStatus(String status) {
        warplySharedPrefs.edit().putString("updateLocServiceStatus", status).apply();
    }

    public String getUpdateLocationServiceStatus() {
        return warplySharedPrefs.getString("updateLocServiceStatus", "off");
    }

    public void saveAppStatus(String appStatus) {
        warplySharedPrefs.edit().putString("appStatus", appStatus).apply();
    }

    public String getAppStatus() {
        return warplySharedPrefs.getString("appStatus", "background");
    }

    public boolean isForeground() {
        return !getAppStatus().equals("background");
    }

    //------------ micro app statuses ------------
    public void saveConsumerAppStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("consumerApp", microAppStatus).apply();
    }

    public boolean getConsumerAppStatus() {
        return warplySharedPrefs.getBoolean("consumerApp", true);
    }

    public void saveAppDataStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("appData", microAppStatus).apply();
    }

    public boolean getAppDataStatus() {
        return warplySharedPrefs.getBoolean("appData", true);
    }

    public void saveOffersStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("offers", microAppStatus).apply();
    }

    public boolean getOffersStatus() {
        return warplySharedPrefs.getBoolean("offers", true);
    }

    public void saveLifeCycleAnalyticsStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("life_cycle_analytics", microAppStatus).apply();
    }

    public boolean getLifeCycleAnalyticsStatus() {
        return warplySharedPrefs.getBoolean("life_cycle_analytics", true);
    }

    public void saveCustomAnalyticsStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("custom_analytics", microAppStatus).apply();
    }

    public boolean getCustomAnalyticsStatus() {
        return warplySharedPrefs.getBoolean("custom_analytics", true);
    }

    public void saveUserTaggingStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("userTagging", microAppStatus).apply();
    }

    public boolean getUserTaggingStatus() {
        return warplySharedPrefs.getBoolean("userTagging", true);
    }

    public void saveDeviceInfoStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("deviceInfo", microAppStatus).apply();
    }

    public boolean getDeviceInfoStatus() {
        return warplySharedPrefs.getBoolean("deviceInfo", true);
    }

    public void saveUserSessionStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("userSession", microAppStatus).apply();
    }

    public boolean getUserSessionStatus() {
        return warplySharedPrefs.getBoolean("userSession", true);
    }

    public void saveBeaconsStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("beacons", microAppStatus).apply();
    }

    public boolean getBeaconsStatus() {
        return warplySharedPrefs.getBoolean("beacons", true);
    }

    public void saveRadioSilentStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("radioSilent", microAppStatus).apply();
    }

    public boolean getRadioSilentStatus() {
        return warplySharedPrefs.getBoolean("radioSilent", false);
    }

    public void saveGeofencingStatus(boolean microAppStatus) {
        warplySharedPrefs.edit().putBoolean("geofencing", microAppStatus).apply();
    }

    public boolean getGeofencingStatus() {
        return warplySharedPrefs.getBoolean("geofencing", true);
    }

    public void saveInboxLastCachedTimeStamp(String requestSignature, long timeStamp) {
        warplySharedPrefs.edit().putLong("inbox_time_stamp_" + requestSignature, timeStamp).apply();
    }

    public long getInboxLastCachedTimeStamp(String requestSignature) {
        return warplySharedPrefs.getLong("inbox_time_stamp_" + requestSignature, 0);
    }

    public void clearInboxLastCachedTimeStamps() {

        SharedPreferences.Editor editor = warplySharedPrefs.edit();
        Map<String, ?> mapPref = warplySharedPrefs.getAll();
        Set<String> keys = mapPref.keySet();
        for (String key : keys) {
            if (key.contains("inbox_time_stamp")) {
                editor.putLong(key, 0);
            }
        }
        editor.apply();
    }

    public void saveInt(String key, int value) {
        warplySharedPrefs.edit().putInt(key, value).apply();
    }

    public int getInt(String key, int defaultValue) {
        return warplySharedPrefs.getInt(key, defaultValue);
    }

    public void saveBoolean(String key, boolean value) {
        warplySharedPrefs.edit().putBoolean(key, value).apply();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return warplySharedPrefs.getBoolean(key, defaultValue);
    }

    public void saveLong(String key, long value) {
        warplySharedPrefs.edit().putLong(key, value).apply();
    }

    public long getLong(String key, long defaultValue) {
        return warplySharedPrefs.getLong(key, defaultValue);
    }

    public void saveString(String key, String value) {
        warplySharedPrefs.edit().putString(key, value).apply();
    }

    public String getString(String key, String defaultValue) {
        return warplySharedPrefs.getString(key, defaultValue);
    }

    public void saveStringArray(String key, String[] value) {

        try {
            if (value != null && value.length > 0) {

                JSONArray arrayJson = new JSONArray();
                for (int i = 0; i < value.length; i++) {
                    arrayJson.put(value[i]);
                }

                JSONObject json = new JSONObject();
                json.put(key, arrayJson);
                warplySharedPrefs.edit().putString(key, json.toString()).apply();
            }
        } catch (JSONException e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
        }
    }

    public String[] getStringArray(String key, String[] defaultValue) {

        String[] value = defaultValue;
        String jsonStr = warplySharedPrefs.getString(key, null);
        if (!TextUtils.isEmpty(jsonStr)) {
            try {
                JSONObject json = new JSONObject(jsonStr);
                JSONArray jsonArray = json.optJSONArray(key);
                if (jsonArray != null && jsonArray.length() > 0) {
                    value = new String[jsonArray.length()];
                    for (int i = 0; i < jsonArray.length(); i++) {
                        value[i] = jsonArray.optString(i);
                    }
                }
            } catch (JSONException e) {
                if (WarpConstants.DEBUG) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

}
