/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.utils.constants;

import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

public class WarpConstants {

    /**
     * The version of the SDK installed in the device
     */
    public static final String SDK_VERSION = "4.5.4.6";

    /**
     * The URL of the server where it should ping
     */
//    public static final String WARPLY_PRODUCTION_BASE_URL = "https://engage.warp.ly";
//    public static final String WARPLY_PRODUCTION_BASE_URL = "https://engage-stage.warp.ly";
    public static final String BASE_REMOTE_PAGE_URL = "/api/session/";
    public static final String BASE_URL_MOBILE = "/api/mobile/v2/";
    public static final String BASE_URL_AUTH = "/oauth/";
    public static final String BASE_URL_API = "/api/";
    public static final String BASE_URL_USER_AUTH = "/user/";
    public static final String BASE_URL_VERIFY = "/partners/gapp/verify";
    public static final String WARPLY_CAMPAIGN_VIEW_BASE_URL = "https://warply.s3-eu-west-1.amazonaws.com";
    public static final boolean POST_DATA_ON_REGISTRATION = true;
    public static final String WARPLY_ASYNC = "/api/async/";
    public static final String WARPLY_ANALYTICS = "analytics/";
    public static final String WARPLY_DEVICE_INFO = "info/";
    public static final String BASE_URL_OTP = "otp/";

    public static final String PATH_CONTEXT = "context";
    public static final String PATH_REGISTER = "register";

    public static final String HEADER_CHANNEL = "channel";
    public static final String HEADER_WEB_ID = "loyalty-web-id";
    public static final String HEADER_DATE = "loyalty-date";
    public static final String HEADER_SIGNATURE = "loyalty-signature";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_LOYALTY_BUNDLE_ID = "loyalty-bundle-id";
    public static final String HEADER_UNIQUE_DEVICE_ID = "unique-device-id";
    public static final String HEADER_ADVERTISING_ID = "advertising-id";
    public static final String HEADER_AUTHORIZATION = "Authorization";

    public static final String GZIP = "gzip";
    public static final String JSON = "application/json";

    public static final long GCM_WAIT_LIMIT = 1000 * 60 * 60;
    public static final String WARPLY_THEME_COLOR = "#384550";
    public static final String WARPLY_THEME_TRANSPARENT_COLOR = "#A0384550";
    public static final long INBOX_UPDATE_INTERVAL = 1000 * 60 * 10;
    public static final int RANDOM_MIN = 20;
    public static final int RANDOM_MAX = 60;
    public static final int JOB_SERVICE_ID = 10001;

    public static final LatLngBounds GREECE_BOUNDS = new LatLngBounds(
            new LatLng(34.75261, 19.33079),
            new LatLng(41.97761, 28.62522)
    );

    public static final com.huawei.hms.maps.model.LatLngBounds GREECE_BOUNDS_HUAWEI = new com.huawei.hms.maps.model.LatLngBounds(
            new com.huawei.hms.maps.model.LatLng(34.75261, 19.33079),
            new com.huawei.hms.maps.model.LatLng(41.97761, 28.62522)
    );

    /* Result codes */

    public static final int RESULT_CODE_SUCCESS = 1;
    public static final int RESULT_CODE_ERROR = 2;
    /**
     * Read-only or Invalid context property
     */
    public static final int RESULT_CODE_NO_ACCESS = 3;
    public static final int RESULT_CODE_INVALID_CAMPAIGN = 4;
    public static final int RESULT_CODE_INVALID_APPLICATION = 5;
    public static final int RESULT_CODE_DEVICE_REGISTRATION_FAILED = 6;
    public static final int RESULT_CODE_INVALID_JSON = 7;
    /**
     * The specified microapp is not implemented
     */
    public static final int RESULT_CODE_NOT_IMPLEMENTED = 8;
    public static final int RESULT_CODE_INVALID_WEB_ID = 9;
    public static final int RESULT_CODE_AUTHORISATION_FAILED = 10;
    public static final int RESULT_CODE_ERROR_COMMUNICATING_WITH_THIRD_PARTY_SERVICE = 11;
    public static final int RESULT_CODE_INVALID_API_IMPLEMENTATION = 12;

    public static final int RESULT_CODE_NO_INTERNET = -1;
    public static final int RESULT_CODE_PARSING_ERROR = -2;
    public static final int RESULT_CODE_SERVER_ERROR = -3;
    public static final int RESULT_CODE_NOT_REGISTERED = -4;
    public static final int RESULT_CODE_TIMEOUT = -5;
    public static final int RESULT_CODE_UNKNOWN = -6;
    public static final int RESULT_CODE_NOT_FOUND = 404;
    public static final int RESULT_CODE_UNAUTHORIZED = 401;

    public static boolean DEBUG;
    public static String GCM_SENDER_ID;

    /* Rate Dialog */
    public final static String PACKAGE_TITLE_GOOGLE = "Google";
    public final static String PACKAGE_ADDRESS_GOOGLE = "market://details?id=";

    /*
     * if was received the campaign with this category need expires date define
     * as 0 (for no show it in app need check on 0 or if the date is correct)
     */
    public static final String MICROAPP_CAMPAIGNS_STANDARD_OFFER_NO_DATE = "standard-offer-no-date";
    public static final String MICROAPP_CAMPAIGNS_STANDARD_OFFER = "standard-offer";

    public static final String MICROAPP_CAMPAIGNS = "offers";
    public static final String MICROAPP_PRODUCTS = "products";
    public static final String MICROAPP_SHOPS = "shops";
    public static final String MICROAPP_TAGS = "tags";
    public static final String MICROAPP_CONTACT = "contact";
    public static final String MICROAPP_CARDS = "cards";
    public static final String MICROAPP_COUPONS = "coupon";
    public static final String MICROAPP_NEW_CAMPAIGNS = "campaigns";
    public static final String MICROAPP_TRANSACTIONS = "transactions";
    public static final String MICROAPP_CONTENT = "content";
    public static final String MICROAPP_APPLICATION_DATA = "application_data";
    public static final String MICROAPP_DEVICE_INFO = "device_info";
    public static final String MICROAPP_INAPP_ANALYTICS = "inapp_analytics";
    public static final String MICROAPP_CONSUMER_DATA = "consumer_data";

    public static final String MICROAPP_GEOFENCING = "geofencing";
    public static final String MICROAPP_GEOFENCING_ACTION = "tracking";
    public static final String MICROAPP_GEOFENCING_ACTION_GET_POIS = "get_pois";

    public static final String MICROAPP_LOGIN_DATA = "login_data";
    public static final String MICROAPP_USER_SESSION = "user_session";
    public static final String MICROAPP_USER_TAG = "tags";
    public static final String MICROAPP_USER_INVITE = "invite_user";
    public static final String MICROAPP_APPLICATION_PAGE_ID = "NB_APP";
    public static final String MICROAPP_USER_TAG_ADD_ACTION = "add_tags";
    public static final String MICROAPP_USER_TAG_REMOVE_ACTION = "remove_tags";

    public static final String MICROAPP_USER_PACKAGES = "user_packages";
    public static final String MICROAPP_BEACON = "beacon";

    public static final String DEVICE_STATUS = "device_status";
    public static final String WARP_ENABLED = "warp_enabled";

    public static final String METADATA_KEY_API_KEY = "warp_uuid";
    public static final String METADATA_KEY_DEBUG = "warp_debug_mode";
    public static final String METADATA_KEY_ACTION_HANDLER = "warply_custom_action_handler";
    public static final String METADATA_KEY_CUSTOM_GCM_INTENT_SERVICE = "warply_custom_gcm_intent_service";

    public static final String CHANNEL_ID = "warply_channel";// The id of the channel. Required for notifications on Oreo and up.


    public enum ServiceRegistrationCallback {
        REGISTERED_GCM, REGISTERED_WARPLY, UNREGISTERED_GCM, UNREGISTERED_WARPLY
    }

    public enum MicroApp {

        // @formatter:off

        CONSUMER("CONSUMER_DATA_ENABLED"),
        APPLICATION_DATA("APPLICATION_DATA_ENABLED"),
        OFFERS("OFFERS_ENABLED"),
        PRODUCTS("PRODUCTS_ENABLED"),
        LIFECYCLE_ANALYTICS("LIFECYCLE_ANALYTICS_ENABLED"),
        CUSTOM_ANALYTICS("CUSTOM_ANALYTICS_ENABLED"),
        USER_TAGGING("USER_TAGGING_ENABLED"),
        DEVICE_INFO("DEVICE_INFO_ENABLED"),
        USER_SESSION("USER_SESSION_ENABLED"),
        BEACONS("BEACON_ENABLED"),
        RADIO_SILENT("WARPLY_ENABLED");

        // @formatter:on

        private String jsonKey;

        MicroApp(String key) {
            this.jsonKey = key;
        }

        public String getJsonKey() {
            return jsonKey;
        }

       /* @Nullable
        public static MicroApp fromValue(String jsonKey) {
            for (MicroApp app : values()) {
                if (app.belongsTo(jsonKey)) {
                    return app;
                }
            }
            return null;
        }

        private boolean belongsTo(String value) {
            return this.jsonKey.equals(value);
        }*/
    }

    public enum LocationSetting {

        // @formatter:off

        LOCATION_FOREGROUND_MODE("ANDROID_LOCATION_FOREGROUND_MODE"),
        FOREGROUND_MIN_TIME("ANDROID_FOREGROUND_MIN_TIME_FILTER"),
        FOREGROUND_MIN_DISTANCE("ANDROID_FOREGROUND_MIN_DISTANCE_FILTER"),
        LOCATION_BACKGROUND_MODE("ANDROID_LOCATION_BACKGROUND_MODE"),
        BACKGROUND_MIN_TIME("ANDROID_BACKGROUND_MIN_TIME_FILTER"),
        BACKGROUND_MIN_DISTANCE("ANDROID_BACKGROUND_MIN_DISTANCE_FILTER"),
        FEATURES_CHECK_INTERVAL("FEATURES_CHECK_INTERVAL"),
        GEOFENCING_POIS_ENABLED("GEOFENCING_POIS_ENABLED");

        // @formatter:on

        private String jsonKey;

        LocationSetting(String key) {
            this.jsonKey = key;
        }

        public String getJsonKey() {
            return jsonKey;
        }
    }

    public enum LocationModes {

        // @formatter:off

        OFF("off"),
        PASSIVE("passive"),
        NETWORK("network"),
        GPS("gps");

        // @formatter:on

        private String jsonKey;

        LocationModes(String key) {
            this.jsonKey = key;
        }

        public String getJsonKey() {
            return jsonKey;
        }
    }

    public static final String KEY_APP_VAR_BEACON_LAYOUTS = "BEACON_LAYOUTS";
    public static final String KEY_APP_VAR_BEACON_MAX_DISTANCE = "BEACON_MAX_DISTANCE";
    public static final String KEY_APP_VAR_BEACON_TIME_INTERVAL = "BEACON_TIME_INTERVAL";
    public static final String KEY_APP_VAR_BEACON_TIME_INTERVAL_TO_RESEND = "BEACON_TIME_INTERVAL_TO_RESEND";

    //updater
    public static final String KEY_APP_VAR_UPDATE_HAS = "ANDROID_HAS_UPDATE";
    public static final String KEY_APP_VAR_UPDATE_FORCE = "ANDROID_FORCE_UPDATE";
    public static final String KEY_APP_VAR_UPDATE_VERSION_CODE = "ANDROID_NEW_VERSION";

    //In App events
    public static final String IN_APP_FILTER_ALL = "all";
    public static final String EVENT_PAGE_VIEW = "pageview:";

}
