package ly.warp.sdk.utils.managers;

import java.util.HashMap;

import ly.warp.sdk.io.models.ActiveDFYCouponEventModel;
import ly.warp.sdk.io.models.ContexualEventModel;
import ly.warp.sdk.io.models.CouponEventModel;
import ly.warp.sdk.io.models.CouponsEventModel;
import ly.warp.sdk.io.models.HealthEventModel;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.LoyaltyEventModel;
import ly.warp.sdk.io.models.LoyaltyGiftsForYouOfferClickEvent;
import ly.warp.sdk.io.models.LoyaltySDKDynatraceEventModel;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.LoyaltySDKSessionExpiredEventModel;
import ly.warp.sdk.io.models.QuestionnaireEventModel;
import ly.warp.sdk.io.models.WarplyCCMSEnabledModel;
import ly.warp.sdk.io.models.WarplyCouponsChangedEventModel;
import ly.warp.sdk.io.models.WarplyDealsAnalysisEventModel;
import ly.warp.sdk.io.models.WarplyPacingCardEventModel;
import ly.warp.sdk.io.models.WarplyPacingCardServiceEnabledModel;
import ly.warp.sdk.io.models.WarplyPacingEventModel;
import ly.warp.sdk.io.models.WarplyUnifiedActivatedEventModel;
import ly.warp.sdk.io.models.WarplyWebviewActivityCallbackEventModel;
import ly.warp.sdk.io.models.WarplyWebviewCallbackEventModel;

/**
 * Created by Panagiotis Triantafyllou on 26/Απρ/2022.
 */
public class WarplyEventBusManager {
    private String eventName;
    private LoyaltySDKFirebaseEventModel fireEvent;
    private LoyaltySDKDynatraceEventModel dynatraceEvent;
    private LoyaltyContextualOfferModel ccms;
    protected HashMap<String, Object> mWarplyEventBusManager = new HashMap();
    private WarplyPacingEventModel pacing;
    private WarplyPacingCardServiceEnabledModel pacingService;
    private WarplyDealsAnalysisEventModel dealsAnalysis;
    private WarplyCCMSEnabledModel ccmsActivated;
    private LoyaltyGiftsForYouOfferClickEvent giftsYou;
    private QuestionnaireEventModel questionnaire;
    private CouponEventModel coupon;
    private ActiveDFYCouponEventModel activeCoupon;
    private ContexualEventModel ccmsAdded;
    private CouponsEventModel couponsAdded;
    private LoyaltyEventModel campaignsAdded;
    private HealthEventModel healthAdded;
    private WarplyCouponsChangedEventModel couponsChanged;
    private WarplyPacingCardEventModel widgetChanged;
    private LoyaltySDKSessionExpiredEventModel sessionExpired;

    private WarplyWebviewCallbackEventModel webviewCallback;
    private WarplyWebviewActivityCallbackEventModel webviewActivityCallback;
    private WarplyUnifiedActivatedEventModel unifiedActivated;

    public WarplyEventBusManager() {

    }

    public WarplyEventBusManager(WarplyUnifiedActivatedEventModel unifiedActivated) {
        this.unifiedActivated = unifiedActivated;
    }

    public WarplyEventBusManager(String eventName) {
        this.eventName = eventName;
    }

    public WarplyEventBusManager(QuestionnaireEventModel questionnaire) {
        this.questionnaire = questionnaire;
    }

    public WarplyEventBusManager(WarplyWebviewCallbackEventModel webviewCallback) {
        this.webviewCallback = webviewCallback;
    }

    public WarplyEventBusManager(WarplyWebviewActivityCallbackEventModel webviewActivityCallback) {
        this.webviewActivityCallback = webviewActivityCallback;
    }

    public WarplyEventBusManager(ContexualEventModel ccmsAdded) {
        this.ccmsAdded = ccmsAdded;
    }

    public WarplyEventBusManager(LoyaltySDKSessionExpiredEventModel sessionExpired) {
        this.sessionExpired = sessionExpired;
    }

    public WarplyEventBusManager(CouponsEventModel couponsAdded) {
        this.couponsAdded = couponsAdded;
    }

    public WarplyEventBusManager(WarplyPacingCardEventModel widgetChanged) {
        this.widgetChanged = widgetChanged;
    }

    public WarplyEventBusManager(HealthEventModel healthAdded) {
        this.healthAdded = healthAdded;
    }

    public WarplyEventBusManager(LoyaltyEventModel campaignsAdded) {
        this.campaignsAdded = campaignsAdded;
    }

    public WarplyEventBusManager(CouponEventModel coupon) {
        this.coupon = coupon;
    }

    public WarplyEventBusManager(WarplyCouponsChangedEventModel couponsChanged) {
        this.couponsChanged = couponsChanged;
    }

    public WarplyEventBusManager(ActiveDFYCouponEventModel activeCoupon) {
        this.activeCoupon = activeCoupon;
    }

    public WarplyEventBusManager(LoyaltySDKFirebaseEventModel fireEvent) {
        this.fireEvent = fireEvent;
    }

    public WarplyEventBusManager(LoyaltySDKDynatraceEventModel dynatraceEvent) {
        this.dynatraceEvent = dynatraceEvent;
    }

    public WarplyEventBusManager(WarplyPacingEventModel pacing) {
        this.pacing = pacing;
    }
//
//    public WarplyEventBusManager(WarplyPacingCardServiceEnabledModel pacingService) {
//        this.pacingService = pacingService;
//    }

    public WarplyEventBusManager(WarplyDealsAnalysisEventModel dealsAnalysis) {
        this.dealsAnalysis = dealsAnalysis;
    }

    public WarplyEventBusManager(WarplyCCMSEnabledModel ccmsActivated) {
        this.ccmsActivated = ccmsActivated;
    }

    public WarplyEventBusManager(LoyaltyContextualOfferModel ccms) {
        this.ccms = ccms;
    }

    public WarplyEventBusManager postWarplyEventBus(String eventName, LoyaltySDKFirebaseEventModel fireEvent) {
        mWarplyEventBusManager.clear();
        mWarplyEventBusManager.put(eventName, fireEvent);
        return this;
    }

    public WarplyEventBusManager postWarplyEventBus(String eventName, LoyaltyContextualOfferModel ccms) {
        mWarplyEventBusManager.clear();
        mWarplyEventBusManager.put(eventName, ccms);
        return this;
    }

    public WarplyEventBusManager postWarplyEventBus(String eventName, LoyaltyGiftsForYouOfferClickEvent gifts) {
        mWarplyEventBusManager.clear();
        mWarplyEventBusManager.put(eventName, gifts);
        return this;
    }

    public WarplyEventBusManager(LoyaltyGiftsForYouOfferClickEvent giftsYou) {
        this.giftsYou = giftsYou;
    }

    public HashMap<String, Object> subscribeWarplyEventBus() {
        return mWarplyEventBusManager;
    }

    public String getEventName() {
        return eventName;
    }

    public LoyaltySDKFirebaseEventModel getFireEvent() {
        return fireEvent;
    }

    public LoyaltySDKDynatraceEventModel getDynaEvent() {
        return dynatraceEvent;
    }

    public LoyaltyContextualOfferModel getCcms() {
        return ccms;
    }

    public HashMap<String, Object> getmWarplyEventBusManager() {
        return mWarplyEventBusManager;
    }

    public WarplyPacingCardServiceEnabledModel getPacingService() {
        return pacingService;
    }

    public WarplyDealsAnalysisEventModel getDealsAnalysis() {
        return dealsAnalysis;
    }

    public WarplyCCMSEnabledModel getCcmsActivated() {
        return ccmsActivated;
    }

    public LoyaltyGiftsForYouOfferClickEvent getGiftsYou() {
        return giftsYou;
    }

    public QuestionnaireEventModel getQuestionnaire() {
        return questionnaire;
    }

    public CouponEventModel getCoupon() {
        return coupon;
    }

    public ActiveDFYCouponEventModel getActiveCoupon() {
        return activeCoupon;
    }

    public WarplyPacingEventModel getPacing() {
        return pacing;
    }

    public ContexualEventModel getCcmsAdded() {
        return ccmsAdded;
    }

    public CouponsEventModel getCouponsAdded() {
        return couponsAdded;
    }

    public LoyaltyEventModel getCampaignsAdded() {
        return campaignsAdded;
    }

    public HealthEventModel getHealthAdded() {
        return healthAdded;
    }

    public WarplyCouponsChangedEventModel getCouponsChanged() {
        return couponsChanged;
    }

    public WarplyPacingCardEventModel getWidgetChanged() {
        return widgetChanged;
    }

    public LoyaltySDKSessionExpiredEventModel isLoyaltySessionExpired() {
        return sessionExpired;
    }

    public WarplyWebviewCallbackEventModel getWarplyWebviewCallbackEventModel() {
        return webviewCallback;
    }

    public WarplyWebviewActivityCallbackEventModel getWarplyWebviewActivityCallbackEventModel() {
        return webviewActivityCallback;
    }

    public WarplyUnifiedActivatedEventModel getWarplyUnifiedActivatedEventModel() {
        return unifiedActivated;
    }
}
