/*
 * Copyright 2010-2013 Warply Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE WARPLY LTD ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL WARPLY LTD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ly.warp.sdk.utils.managers;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.format.DateFormat;
import android.util.ArrayMap;

import androidx.annotation.NonNull;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import ly.warp.sdk.Warply;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.io.callbacks.AddressHook;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.callbacks.CardsHook;
import ly.warp.sdk.io.callbacks.ContactHook;
import ly.warp.sdk.io.callbacks.ContentHook;
import ly.warp.sdk.io.callbacks.CouponsHook;
import ly.warp.sdk.io.callbacks.CouponsetsHook;
import ly.warp.sdk.io.callbacks.MerchantCategoriesHook;
import ly.warp.sdk.io.callbacks.MerchantsHook;
import ly.warp.sdk.io.callbacks.NewCampaignsHook;
import ly.warp.sdk.io.callbacks.PacingDetailsHook;
import ly.warp.sdk.io.callbacks.PointsHook;
import ly.warp.sdk.io.callbacks.ProductsHook;
import ly.warp.sdk.io.callbacks.SharingHook;
import ly.warp.sdk.io.callbacks.TagsCategoriesHook;
import ly.warp.sdk.io.callbacks.TagsHook;
import ly.warp.sdk.io.callbacks.TransactionsHook;
import ly.warp.sdk.io.models.AddressList;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.Card;
import ly.warp.sdk.io.models.CardList;
import ly.warp.sdk.io.models.Consumer;
import ly.warp.sdk.io.models.ContentList;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.CouponsetsList;
import ly.warp.sdk.io.models.LoyaltySDKDynatraceEventModel;
import ly.warp.sdk.io.models.Merchant;
import ly.warp.sdk.io.models.MerchantCategoriesList;
import ly.warp.sdk.io.models.MerchantList;
import ly.warp.sdk.io.models.PacingDetails;
import ly.warp.sdk.io.models.PointsList;
import ly.warp.sdk.io.models.ProductList;
import ly.warp.sdk.io.models.SharingList;
import ly.warp.sdk.io.models.TagsCategoriesList;
import ly.warp.sdk.io.models.TagsList;
import ly.warp.sdk.io.models.TransactionsList;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.io.models.WarplyPacingEventModel;
import ly.warp.sdk.io.request.CosmoteCouponSharingRequest;
import ly.warp.sdk.io.request.CosmotePostEventRequest;
import ly.warp.sdk.io.request.CosmoteRetrieveSharingRequest;
import ly.warp.sdk.io.request.CosmoteSharingRequest;
import ly.warp.sdk.io.request.CosmoteSubmitOrderRequest;
import ly.warp.sdk.io.request.PacingCalculateRequest;
import ly.warp.sdk.io.request.PacingDetailsRequest;
import ly.warp.sdk.io.request.WarplyAddAddressRequest;
import ly.warp.sdk.io.request.WarplyAddCardRequest;
import ly.warp.sdk.io.request.WarplyAuthorizeRequest;
import ly.warp.sdk.io.request.WarplyChangePasswordRequest;
import ly.warp.sdk.io.request.WarplyConsumerRequest;
import ly.warp.sdk.io.request.WarplyContactRequest;
import ly.warp.sdk.io.request.WarplyContentRequest;
import ly.warp.sdk.io.request.WarplyCosmoteUserRequest;
import ly.warp.sdk.io.request.WarplyDeleteAddressRequest;
import ly.warp.sdk.io.request.WarplyDeleteCardRequest;
import ly.warp.sdk.io.request.WarplyEditAddressRequest;
import ly.warp.sdk.io.request.WarplyEditConsumerRequest;
import ly.warp.sdk.io.request.WarplyForgotPasswordRequest;
import ly.warp.sdk.io.request.WarplyGetAddressRequest;
import ly.warp.sdk.io.request.WarplyGetCampaignsRequest;
import ly.warp.sdk.io.request.WarplyGetCardsRequest;
import ly.warp.sdk.io.request.WarplyGetCouponsetsRequest;
import ly.warp.sdk.io.request.WarplyIntegrationRequest;
import ly.warp.sdk.io.request.WarplyLoginRequest;
import ly.warp.sdk.io.request.WarplyMerchantCategoriesRequest;
import ly.warp.sdk.io.request.WarplyMerchantsRequest;
import ly.warp.sdk.io.request.WarplyPointHistoryRequest;
import ly.warp.sdk.io.request.WarplyProductsRequest;
import ly.warp.sdk.io.request.WarplyRedeemCouponRequest;
import ly.warp.sdk.io.request.WarplyRedeemProductRequest;
import ly.warp.sdk.io.request.WarplyRefreshTokenRequest;
import ly.warp.sdk.io.request.WarplyRegisterRequest;
import ly.warp.sdk.io.request.WarplyRequestOTPRequest;
import ly.warp.sdk.io.request.WarplyResetPasswordRequest;
import ly.warp.sdk.io.request.WarplySharingHistoryRequest;
import ly.warp.sdk.io.request.WarplyTagsCategoriesRequest;
import ly.warp.sdk.io.request.WarplyTagsRequest;
import ly.warp.sdk.io.request.WarplyTokenAuthorizeRequest;
import ly.warp.sdk.io.request.WarplyTransactionHistoryRequest;
import ly.warp.sdk.io.request.WarplyUploadConsumerPhotoRequest;
import ly.warp.sdk.io.request.WarplyUserCouponsRequest;
import ly.warp.sdk.io.request.WarplyValidateCouponRequest;
import ly.warp.sdk.io.request.WarplyVerifyOTPRequest;
import ly.warp.sdk.io.request.WarplyVerifyTicketRequest;
import ly.warp.sdk.io.volley.ApiClient;
import ly.warp.sdk.io.volley.ApiService;
import ly.warp.sdk.services.EventCampaignService;
import ly.warp.sdk.services.WarplyHealthService;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyDeviceInfoCollector;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Panagiotis Triantafyllou on 15-Dec-21.
 */

public class WarplyManager {
    public static void getProducts(WarplyProductsRequest request, final CallbackReceiver<ProductList> receiver) {
//        String productCategory = "";
//        int resStringId = getWarplyContext().getResources().getIdentifier("products_category", "string", getWarplyContext().getPackageName());
//        if(resStringId != 0){
//            productCategory = getWarplyContext().getResources().getString(resStringId);
//        }

        if (request == null) {
            request = new WarplyProductsRequest();
        }

        WarpUtils.log("************* WARPLY Microapp ********************");
//        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.PRODUCTS)) {
//            WarpUtils.log("[WARP Trace] Products Microapp is not active");
//            WarpUtils.log("**************************************************");
//            receiver.onFailure(2);
//            return;
//        }
        WarpUtils.log("[WARP Trace] Products Microapp is active");
        WarpUtils.log("**************************************************");

        request = request != null ? request : new WarplyProductsRequest();
        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_PRODUCTS, request.toJson(),
                new ProductsHook(receiver, request.getSignature()));
    }

    public static void getMerchants(WarplyMerchantsRequest request, final CallbackReceiver<MerchantList> receiver) {
        if (request == null) {
            request = new WarplyMerchantsRequest();
        }

        WarpUtils.log("************* WARPLY Microapp ********************");
//        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.PRODUCTS)) {
//            WarpUtils.log("[WARP Trace] Shops Microapp is not active");
//            WarpUtils.log("**************************************************");
//            receiver.onFailure(2);
//            return;
//        }
        WarpUtils.log("[WARP Trace] Shops Microapp is active");
        WarpUtils.log("**************************************************");

        request = request != null ? request : new WarplyMerchantsRequest();
        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_SHOPS, request.toJson(),
                new MerchantsHook(receiver, request.getSignature()));
    }

    public static void getContent(WarplyContentRequest request, final CallbackReceiver<ContentList> receiver) {
        if (request == null) {
            request = new WarplyContentRequest();
        }

        WarpUtils.log("************* WARPLY Microapp ********************");
//        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.PRODUCTS)) {
//            WarpUtils.log("[WARP Trace] Content Microapp is not active");
//            WarpUtils.log("**************************************************");
//            receiver.onFailure(2);
//            return;
//        }
        WarpUtils.log("[WARP Trace] Content Microapp is active");
        WarpUtils.log("**************************************************");

        request = request != null ? request : new WarplyContentRequest();
        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_CONTENT, request.toJson(),
                new ContentHook(receiver, request.getSignature()));
    }

    public static void getMerchantCategories(WarplyMerchantCategoriesRequest request, final CallbackReceiver<MerchantCategoriesList> receiver) {
        if (request == null) {
            request = new WarplyMerchantCategoriesRequest();
        }

        WarpUtils.log("************* WARPLY Microapp ********************");
//        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.PRODUCTS)) {
//            WarpUtils.log("[WARP Trace] ShopCategories Microapp is not active");
//            WarpUtils.log("**************************************************");
//            receiver.onFailure(2);
//            return;
//        }
        WarpUtils.log("[WARP Trace] ShopCategories Microapp is active");
        WarpUtils.log("**************************************************");

        request = request != null ? request : new WarplyMerchantCategoriesRequest();
        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_SHOPS, request.toJson(),
                new MerchantCategoriesHook(receiver, request.getSignature()));
    }

    public static void getTagsCategories(WarplyTagsCategoriesRequest request, final CallbackReceiver<TagsCategoriesList> receiver) {
        if (request == null) {
            request = new WarplyTagsCategoriesRequest();
        }

        WarpUtils.log("************* WARPLY Microapp ********************");
//        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.PRODUCTS)) {
//            WarpUtils.log("[WARP Trace] TagsCategories Microapp is not active");
//            WarpUtils.log("**************************************************");
//            receiver.onFailure(2);
//            return;
//        }
        WarpUtils.log("[WARP Trace] TagsCategories Microapp is active");
        WarpUtils.log("**************************************************");

        request = request != null ? request : new WarplyTagsCategoriesRequest();
        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_TAGS, request.toJson(),
                new TagsCategoriesHook(receiver, request.getSignature()));
    }

    public static void getTags(WarplyTagsRequest request, final CallbackReceiver<TagsList> receiver) {
        if (request == null) {
            request = new WarplyTagsRequest();
        }

        WarpUtils.log("************* WARPLY Microapp ********************");
//        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.PRODUCTS)) {
//            WarpUtils.log("[WARP Trace] TagsCategories Microapp is not active");
//            WarpUtils.log("**************************************************");
//            receiver.onFailure(2);
//            return;
//        }
        WarpUtils.log("[WARP Trace] TagsCategories Microapp is active");
        WarpUtils.log("**************************************************");

        request = request != null ? request : new WarplyTagsRequest();
        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_TAGS, request.toJson(),
                new TagsHook(receiver, request.getSignature()));
    }

    public static void sendContact(WarplyContactRequest request, final CallbackReceiver<JSONObject> receiver) {
        if (request == null) {
            request = new WarplyContactRequest();
        }

        WarpUtils.log("************* WARPLY Microapp ********************");
//        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.PRODUCTS)) {
//            WarpUtils.log("[WARP Trace] Contact Microapp is not active");
//            WarpUtils.log("**************************************************");
//            receiver.onFailure(2);
//            return;
//        }
        WarpUtils.log("[WARP Trace] Contact Microapp is active");
        WarpUtils.log("**************************************************");

        request = request != null ? request : new WarplyContactRequest();
        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_CONTACT, request.toJson(),
                new ContactHook(receiver, request.getSignature()));
    }

    public static void login(WarplyLoginRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Login Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Login Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "login", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveClientAccess(
                            result.optString("client_id", ""),
                            result.optString("client_secret", "")
                    );

                    authorize(new WarplyAuthorizeRequest()
                                    .setInitialData(request.toJson())
                                    .setAuthorizeData(result)
                                    .setIsRegister(false),
                            result,
                            false,
                            receiver);
                } else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    private static void authorize(WarplyAuthorizeRequest request, JSONObject receivedData,
                                  boolean isRegister, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Authorize Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Authorize Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "web_authorize", request.toJson(),
                new CallbackReceiver<JSONObject>() {
                    @Override
                    public void onSuccess(JSONObject result) {
                        if (result.has("code")) {
                            try {
                                receivedData.putOpt("code", result.optString("code"));
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }

                            tokenAuthorize(new WarplyTokenAuthorizeRequest()
                                            .setAuthorizeData(receivedData)
                                            .setIsRegister(isRegister),
                                    receiver);
                        } else
                            receiver.onFailure(2);
                    }

                    @Override
                    public void onFailure(int errorCode) {
                        receiver.onFailure(errorCode);
                    }
                });
    }

    private static void tokenAuthorize(WarplyTokenAuthorizeRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Token Authorize Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Token Authorize Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "token", request.toJson(),
                new CallbackReceiver<JSONObject>() {
                    @Override
                    public void onSuccess(JSONObject result) {
                        if (result.has("token_type")) {
                            WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(
                                    result.optString("access_token", ""),
                                    result.optString("refresh_token", "")
                            );

                            JSONObject newResult = new JSONObject();
                            try {
                                newResult.putOpt("status", 1);
                                newResult.putOpt("message", "Success");
                                receiver.onSuccess(newResult);
                            } catch (JSONException e) {
                                e.printStackTrace();
                                receiver.onFailure(2);
                            }
                        } else
                            receiver.onFailure(2);
                    }

                    @Override
                    public void onFailure(int errorCode) {
                        receiver.onFailure(errorCode);
                    }
                });
    }

    private static void refreshToken(WarplyRefreshTokenRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Refresh Authorize Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Refresh Authorize Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "token", request.toJson(),
                new CallbackReceiver<JSONObject>() {
                    @Override
                    public void onSuccess(JSONObject result) {
                        if (result.has("token_type")) {
                            WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(
                                    result.optString("access_token", ""),
                                    result.optString("refresh_token", "")
                            );

                            JSONObject newResult = new JSONObject();
                            try {
                                newResult.putOpt("status", 1);
                                newResult.putOpt("message", "Success");

                                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                dynatraceEvent.setEventName("custom_success_refresh_token_loyalty");
                                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                                receiver.onSuccess(newResult);
                            } catch (JSONException e) {
                                e.printStackTrace();
                                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                dynatraceEvent.setEventName("custom_error_refresh_token_loyalty");
                                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                                receiver.onFailure(2);
                            }
                        } else {
                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                            dynatraceEvent.setEventName("custom_error_refresh_token_loyalty");
                            EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                            receiver.onFailure(2);
                        }
                    }

                    @Override
                    public void onFailure(int errorCode) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_refresh_token_loyalty");
                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                        if (errorCode == 401) {
                            WarplyDBHelper.getInstance(Warply.getWarplyContext()).deleteAuth();
                            WarplyDBHelper.getInstance(Warply.getWarplyContext()).deleteClient();
                            receiver.onFailure(errorCode);
                        }
                    }
                });
    }

    public static void register(WarplyRegisterRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Register Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Register Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "register", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    if (request.getAutologin()) {
                        WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveClientAccess(
                                result.optString("client_id", ""),
                                result.optString("client_secret", "")
                        );

                        authorize(new WarplyAuthorizeRequest()
                                        .setInitialData(request.toJson())
                                        .setAuthorizeData(result)
                                        .setIsRegister(true),
                                result,
                                true,
                                receiver);
                    } else {
                        JSONObject newResult = new JSONObject();
                        try {
                            newResult.putOpt("status", 1);
                            newResult.putOpt("message", "Success");
                            receiver.onSuccess(newResult);
                        } catch (JSONException e) {
                            e.printStackTrace();
                            receiver.onFailure(2);
                        }
                    }
                } else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void getConsumer(WarplyConsumerRequest request, final CallbackReceiver<Consumer> receiver) {
        WarpUtils.log("************* WARPLY Consumer Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Consumer Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_profile_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                    result = result.optJSONObject("result");
                    if (result == null) {
                        receiver.onFailure(2);
                        return;
                    }
                    receiver.onSuccess(new Consumer(result));
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_profile_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getConsumer(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_profile_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void logout(final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Logout ********************");
        WarpUtils.log("[WARP Trace] WARPLY Logout is active");
        WarpUtils.log("**************************************************");

        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
        WarpUtils.setUserTag(Warply.getWarplyContext(), "");
        WarplyManagerHelper.clearCCMSLoyaltyCampaigns();

        WarplyDBHelper.getInstance(Warply.getWarplyContext()).deleteAuth();
        WarplyDBHelper.getInstance(Warply.getWarplyContext()).deleteClient();

        JSONObject newResult = new JSONObject();
        try {
            newResult.putOpt("status", 1);
            newResult.putOpt("message", "Success");
            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
            dynatraceEvent.setEventName("custom_success_logout_loyalty");
            EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
            receiver.onSuccess(newResult);
        } catch (JSONException e) {
            e.printStackTrace();
            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
            dynatraceEvent.setEventName("custom_error_logout_loyalty");
            EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
            receiver.onFailure(2);
        }
    }

    public static void changePassword(WarplyChangePasswordRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Change Password Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Change Password Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "change_password", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                changePassword(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        });
    }

    public static void editConsumer(WarplyEditConsumerRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Edit Consumer Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Edit Consumer Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                editConsumer(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        });
    }

    public static void uploadConsumerPhoto(WarplyUploadConsumerPhotoRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Upload Consumer Photo Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Upload Consumer Photo Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "handle_image", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                uploadConsumerPhoto(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        });
    }

    public static void addCard(WarplyAddCardRequest request, final CallbackReceiver<Card> receiver) {
        WarpUtils.log("************* WARPLY Add Card Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Add Card Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_CARDS, true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    result = result.optJSONObject("result");
                    if (result == null) {
                        receiver.onFailure(2);
                        return;
                    }
                    receiver.onSuccess(new Card(result));
                } else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                addCard(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        });
    }

    public static void getCards(WarplyGetCardsRequest request, final CallbackReceiver<CardList> receiver) {
        WarpUtils.log("************* WARPLY Get Cards Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Cards Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_CARDS, true, "context", request.toJson(), new CardsHook(new CallbackReceiver<CardList>() {
            @Override
            public void onSuccess(CardList result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getCards(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        },
                request.getSignature()));
    }

    public static void deleteCard(WarplyDeleteCardRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Delete Card Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Delete Card Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_CARDS, true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                deleteCard(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        });
    }

    public static void verifyTicket(WarplyVerifyTicketRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Verify Ticket Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Verify Ticket Request is active");
        WarpUtils.log("**************************************************");

        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
        WarpUtils.setUserTag(Warply.getWarplyContext(), "");
        WarplyManagerHelper.clearCCMSLoyaltyCampaigns();
        Warply.postReceiveMicroappData(false, "verify", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("result", 2);
                if (status == 1) {
                    JSONObject tokens = result.optJSONObject("tokens");
                    if (tokens != null) {
                        WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveClientAccess(
                                tokens.optString("client_id", ""),
                                tokens.optString("client_secret", "")
                        );

                        WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(
                                tokens.optString("access_token", ""),
                                tokens.optString("refresh_token", "")
                        );

                        JSONObject newResult = new JSONObject();
                        try {
                            newResult.putOpt("status", 1);
                            newResult.putOpt("message", "Success");
                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                            dynatraceEvent.setEventName("custom_success_login_loyalty");
                            EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                            receiver.onSuccess(newResult);
                        } catch (JSONException e) {
                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                            dynatraceEvent.setEventName("custom_error_login_loyalty");
                            EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                            e.printStackTrace();
                            receiver.onFailure(2);
                        }

                        getConsumer(new WarplyConsumerRequest(), new CallbackReceiver<Consumer>() {
                            @Override
                            public void onSuccess(Consumer result) {
                                WarplyManagerHelper.setConsumerInternal(result);

                                if (result != null) {
                                    JSONObject profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata());
                                    if (profMetadata != null && profMetadata.has("nonTelco")) {
                                        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), profMetadata.optBoolean("nonTelco"));
                                    } else {
                                        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
                                    }
                                }

                                if (result != null) {
                                    JSONObject profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata());
                                    if (profMetadata != null) {
                                        if (profMetadata.has("badge")) {
                                            WarpUtils.setUserTag(Warply.getWarplyContext(), profMetadata.optString("badge"));
                                        }

                                        if (profMetadata.has("steps_enabled") && profMetadata.optBoolean("steps_enabled")) {
                                            if (!isMyServiceRunning(WarplyHealthService.class)) {
                                                Intent stepsServiceIntent = new Intent(Warply.getWarplyContext(), WarplyHealthService.class);
                                                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                                                    AlarmManager mgr = (AlarmManager) Warply.getWarplyContext().getSystemService(Context.ALARM_SERVICE);
                                                    PendingIntent pi = PendingIntent.getService(Warply.getWarplyContext(), 2002, stepsServiceIntent, PendingIntent.FLAG_ONE_SHOT | PendingIntent.FLAG_IMMUTABLE);
                                                    mgr.set(AlarmManager.ELAPSED_REALTIME_WAKEUP, SystemClock.elapsedRealtime() + 1000, pi);
                                                } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                                    Warply.getWarplyContext().startForegroundService(stepsServiceIntent);
                                                } else {
                                                    Warply.getWarplyContext().startService(stepsServiceIntent);
                                                }

                                                WarplyPacingEventModel pacingVisible = new WarplyPacingEventModel();
                                                pacingVisible.setVisible(true);
                                                EventBus.getDefault().post(new WarplyEventBusManager(pacingVisible));
                                            }
                                        }
                                    }
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) {

                            }
                        });
                    } else {
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_login_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_login_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void getUserCoupons(WarplyUserCouponsRequest request, final CallbackReceiver<CouponList> receiver) {
        WarpUtils.log("************* WARPLY User Coupons Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Coupons Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_COUPONS, true, "context", request.toJson(), new CouponsHook(new CallbackReceiver<CouponList>() {
            @Override
            public void onSuccess(CouponList result) {
//                CouponList mCouponList = new CouponList();
//                for (Coupon coupon : result) {
//                    for (Couponset couponset : WarplyManagerHelper.getCouponsets()) {
//                        if (coupon.getCouponsetUuid().equals(couponset.getUuid())) {
//                            coupon.setDescription(couponset.getShortDescription());
//                            coupon.setImage(couponset.getImgPreview());
//                            coupon.setName(couponset.getName());
//                            mCouponList.add(coupon);
//                        }
//                    }
//                }
//                WarplyManagerHelper.setCouponList(mCouponList);

                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_user_coupons_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                receiver.onSuccess(/*mCouponList*/ result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getUserCoupons(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        },
                request.getSignature()));
    }

    public static void getTransactionHistory(WarplyTransactionHistoryRequest request, final CallbackReceiver<TransactionsList> receiver) {
        WarpUtils.log("************* WARPLY Transaction History Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Transaction History Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new TransactionsHook(new CallbackReceiver<TransactionsList>() {
            @Override
            public void onSuccess(TransactionsList result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getTransactionHistory(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        },
                request.getSignature()));
    }

    public static void getPointHistory(WarplyPointHistoryRequest request, final CallbackReceiver<PointsList> receiver) {
        WarpUtils.log("************* WARPLY Point History Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Point History Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new PointsHook(new CallbackReceiver<PointsList>() {
            @Override
            public void onSuccess(PointsList result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getPointHistory(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        },
                request.getSignature()));
    }

    public static void addAddress(WarplyAddAddressRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Add Address Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Add Address Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                addAddress(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        });
    }

    public static void getAddressList(WarplyGetAddressRequest request, final CallbackReceiver<AddressList> receiver) {
        WarpUtils.log("************* WARPLY Get Address Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Address Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new AddressHook(new CallbackReceiver<AddressList>() {
            @Override
            public void onSuccess(AddressList result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getAddressList(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        },
                request.getSignature()));
    }

    public static void editAddress(WarplyEditAddressRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Edit Address Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Edit Address Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                editAddress(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        });
    }

    public static void deleteAddress(WarplyDeleteAddressRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Delete Address Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Delete Address Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                deleteAddress(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        });
    }

    public static void redeemProduct(WarplyRedeemProductRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Redeem Product Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Redeem Product Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_TRANSACTIONS, true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                redeemProduct(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        });
    }

    public static void forgotPassword(WarplyForgotPasswordRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Forgot Password Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Forgot Password Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "password_reset", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void resetPassword(WarplyResetPasswordRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Reset Password Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Reset Password Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "password_reset", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void requestOTP(WarplyRequestOTPRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Request OTP Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Request OTP Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "generate", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void verifyOTP(WarplyVerifyOTPRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Verify OTP Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Verify OTP Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "validate", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1)
                    receiver.onSuccess(result);
                else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void getMerchantsMultilingual(WarplyMerchantsRequest request, final CallbackReceiver<MerchantList> receiver) {
        if (request == null) {
            request = new WarplyMerchantsRequest().setIsMultilingual(true);
        }

        WarpUtils.log("************* WARPLY Microapp ********************");
//        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.PRODUCTS)) {
//            WarpUtils.log("[WARP Trace] Shops Microapp is not active");
//            WarpUtils.log("**************************************************");
//            receiver.onFailure(2);
//            return;
//        }
        WarpUtils.log("[WARP Trace] Shops Microapp is active");
        WarpUtils.log("**************************************************");

        request = request != null ? request : new WarplyMerchantsRequest().setIsMultilingual(true);
        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_SHOPS, request.toJson(),
                new MerchantsHook(receiver, request.getSignature()));
    }

    public static void getCouponsets(WarplyGetCouponsetsRequest request, final CallbackReceiver<CouponsetsList> receiver) {
        WarpUtils.log("************* WARPLY Get Couponsets Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Couponsets Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_COUPONS, request.toJson(), new CouponsetsHook(new CallbackReceiver<CouponsetsList>() {
            @Override
            public void onSuccess(CouponsetsList result) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_couponsets_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                WarplyManagerHelper.setCouponsets(result);
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_couponsets_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(errorCode);
            }
        },
                request.getSignature()));
    }

    public static void redeemCoupon(WarplyRedeemCouponRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Redeem Coupon Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Redeem Coupon Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_COUPONS, true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status");
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_retrieve_coupon_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_retrieve_coupon_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                redeemCoupon(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_retrieve_coupon_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void validateCoupon(WarplyValidateCouponRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Validate Coupon Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Validate Coupon Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_COUPONS, true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                validateCoupon(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else
                    receiver.onFailure(errorCode);
            }
        });
    }

    public static void getCampaigns(WarplyGetCampaignsRequest request, final CallbackReceiver<ArrayList<Campaign>> receiver) {
        WarpUtils.log("************* WARPLY Get Campaigns Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Campaigns Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_NEW_CAMPAIGNS, false, "campaigns", request.toJson(), new NewCampaignsHook(new CallbackReceiver<ArrayList<Campaign>>() {
            @Override
            public void onSuccess(ArrayList<Campaign> result) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_campaigns_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                getCampaignsPersonalized(request, new CallbackReceiver<ArrayList<Campaign>>() {
                    @Override
                    public void onSuccess(ArrayList<Campaign> resultPersonalized) {
                        ArrayList<Campaign> newCampaignList = new ArrayList<Campaign>();
                        newCampaignList.clear();
                        newCampaignList.addAll(result);
                        newCampaignList.addAll(resultPersonalized);
                        Collections.sort(newCampaignList, (obj1, obj2) -> Integer.compare(obj1.getSorting(), obj2.getSorting()));
                        WarplyManagerHelper.setCampaignList(newCampaignList);
                        ArrayList<Campaign> campaignLoyaltyList = new ArrayList<>();
                        campaignLoyaltyList.clear();
                        ArrayList<Campaign> campaignCarouselList = new ArrayList<>();
                        campaignCarouselList.clear();
                        for (Campaign camp : newCampaignList) {
                            JSONObject campMetadata = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                            if (campMetadata != null) {
                                if (campMetadata.has("carousel")) {
                                    campaignCarouselList.add(camp);
                                }
                            }

                            if (camp.getOfferCategory().equals("questionnaire")) {
//                        if (WarplyManagerHelper.getConsumerInternal() != null) {
//                            JSONObject profMetadata = WarpJSONParser.getJSONFromString(WarplyManagerHelper.getConsumerInternal().getProfileMetadata());
//                            if (profMetadata != null) {
//                                if (!profMetadata.has("answered")) {
//                                    try {
//                                        JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
//                                        if (extraFields != null) {
//                                            if (extraFields.length() == 0 || !(extraFields.has("ccms_offer") || extraFields.has("type"))) {
//                                                campaignLoyaltyList.add(camp);
//                                            }
//                                        }
//                                    } catch (Exception exception) {
//                                        campaignLoyaltyList.add(camp);
//                                    }
//                                }
//                            } else {
//                                try {
//                                    JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
//                                    if (extraFields != null) {
//                                        if (extraFields.length() == 0 || !(extraFields.has("ccms_offer") || extraFields.has("type"))) {
//                                            campaignLoyaltyList.add(camp);
//                                        }
//                                    }
//                                } catch (Exception exception) {
//                                    campaignLoyaltyList.add(camp);
//                                }
//                            }
//                        } else {
//                            try {
//                                JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
//                                if (extraFields != null) {
//                                    if (extraFields.length() == 0 || !(extraFields.has("ccms_offer") || extraFields.has("type"))) {
//                                        campaignLoyaltyList.add(camp);
//                                    }
//                                }
//                            } catch (Exception exception) {
//                                campaignLoyaltyList.add(camp);
//                            }
//                        }
                            } else {
                                try {
                                    JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                                    if (extraFields != null) {
                                        if (extraFields.length() == 0 || !(extraFields.has("ccms_offer") || extraFields.has("type"))) {
                                            campaignLoyaltyList.add(camp);
                                        }
                                    }
                                } catch (Exception exception) {
                                    campaignLoyaltyList.add(camp);
                                }
                            }
                        }
                        WarplyManagerHelper.setCarouselList(campaignCarouselList);

                        Set<Campaign> set = new LinkedHashSet<>(campaignLoyaltyList);
                        campaignLoyaltyList.clear();
                        campaignLoyaltyList.addAll(set);
                        receiver.onSuccess(campaignLoyaltyList); //resultPersonalized
                    }

                    @Override
                    public void onFailure(int errorCode) {
                        receiver.onFailure(errorCode);
                    }
                });
            }

            @Override
            public void onFailure(int errorCode) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_campaigns_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(errorCode);
            }
        },
                request.getSignature()));
    }

    public static void getCampaignsPersonalized(WarplyGetCampaignsRequest request, final CallbackReceiver<ArrayList<Campaign>> receiver) {
        WarpUtils.log("************* WARPLY Get Campaigns Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Campaigns Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_NEW_CAMPAIGNS, true, "campaignsPersonalized", request.toJson(), new NewCampaignsHook(new CallbackReceiver<ArrayList<Campaign>>() {
            @Override
            public void onSuccess(ArrayList<Campaign> result) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_campaigns_personalized_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getCampaignsPersonalized(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_campaigns_personalized_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        },
                request.getSignature()));
    }

    public static void consumerIntegration(WarplyIntegrationRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Integration Consumer Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Integration Consumer Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_customer_state_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_customer_state_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                consumerIntegration(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_customer_state_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void cosmoteSharing(CosmoteSharingRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Cosmote Sharing Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Cosmote Sharing Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1 || status == 4 || status == 5 || status == 7) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_sharing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_sharing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                cosmoteSharing(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_sharing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void cosmoteRetrieveSharing(CosmoteRetrieveSharingRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Cosmote Retrieve Sharing Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Cosmote Retrieve Sharing Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_retrieve_sharing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_retrieve_sharing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                cosmoteRetrieveSharing(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_retrieve_sharing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getPacingDetails(PacingDetailsRequest request, final CallbackReceiver<PacingDetails> receiver) {
        WarpUtils.log("************* WARPLY Pacing Details Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Pacing Details Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new PacingDetailsHook(new CallbackReceiver<PacingDetails>() {
            @Override
            public void onSuccess(PacingDetails result) {
//                if (context != null) {
//                    if (result.isGoal_reached()) {
//                        new AlertDialog.Builder(context)
//                                .setTitle(R.string.cos_dlg_success_title)
//                                .setMessage(result.getMsg())
//                                .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
//                                    dialogPositive.dismiss();
//                                })
//                                .show();
//                    }
//                }

                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_pacing_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getPacingDetails(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_pacing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        },
                request.getSignature()));
    }

    public static void cosmoteCouponSharing(CosmoteCouponSharingRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Cosmote Coupon Sharing Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Cosmote Coupon Sharing Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1 || status == 3 || status == 4) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_coupon_sharing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_coupon_sharing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                cosmoteCouponSharing(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_coupon_sharing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getUnifiedCoupons(final CallbackReceiver<ArrayList<UnifiedCoupon>> receiver) {
        WarpUtils.log("************* WARPLY User Coupons Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Coupons Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = ApiClient.getRetrofitInstance().create(ApiService.class);
        getUnifiedCouponsRetro(service, new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> responseCoupons) {
                if (responseCoupons.code() == 200 && responseCoupons.body() != null) {
                    JSONObject jobjCouponsResponse = null;
                    try {
                        jobjCouponsResponse = new JSONObject(responseCoupons.body().string());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjCouponsResponse != null && jobjCouponsResponse.has("status") && jobjCouponsResponse.optInt("status", 2) == 1) {
                        ArrayList<UnifiedCoupon> couponList = new ArrayList<UnifiedCoupon>();
                        ArrayList<UnifiedCoupon> allCouponList = new ArrayList<UnifiedCoupon>();
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_unified_coupons_loyalty");
                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                        JSONObject finalJobjCouponsResponse = jobjCouponsResponse;
                        final ExecutorService executor = Executors.newFixedThreadPool(1);
                        executor.submit(() -> {
                            JSONObject jCouponsBody = null;
                            try {
                                jCouponsBody = finalJobjCouponsResponse.optJSONObject("result");
                                if (jCouponsBody != null && jCouponsBody.length() > 0) {
                                    JSONArray jCouponsInnerBody = null;
                                    jCouponsInnerBody = jCouponsBody.optJSONArray("coupons");
                                    if (jCouponsInnerBody != null && jCouponsInnerBody.length() > 0) {
                                        for (int i = 0; i < jCouponsInnerBody.length(); i++) {
                                            UnifiedCoupon tempUni = new UnifiedCoupon(jCouponsInnerBody.optJSONObject(i));
                                            allCouponList.add(tempUni);
                                            if (tempUni.getStatus().trim().equals("active"))
                                                couponList.add(tempUni);
                                        }

                                        WarplyManagerHelper.setMarketCoupons(allCouponList);
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(couponList));
                            executor.shutdownNow();
                        });
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_unified_coupons_loyalty");
                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_unified_coupons_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(responseCoupons.code());
                }
            }

            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(2);
            }
        });
    }

    public static void getUserCouponsWithCouponsets(WarplyUserCouponsRequest request, final CallbackReceiver<CouponList> receiver) {
        WarpUtils.log("************* WARPLY User Coupons Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Coupons Request is active");
        WarpUtils.log("**************************************************");

        WarplyManager.getMerchantsMultilingual(new WarplyMerchantsRequest()
                        .setIsMultilingual(true)
                , new CallbackReceiver<MerchantList>() {
                    @Override
                    public void onSuccess(MerchantList result) {
                        WarplyManagerHelper.setMerchantList(result);
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_shops_loyalty");
                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                        getCouponsets(new WarplyGetCouponsetsRequest()
                                .setLanguage(WarplyProperty.getLanguage(Warply.getWarplyContext())), new CallbackReceiver<CouponsetsList>() {
                            @Override
                            public void onSuccess(CouponsetsList result) {
                                Warply.postReceiveMicroappData(WarpConstants.MICROAPP_COUPONS, true, "context", request.toJson(), new CouponsHook(new CallbackReceiver<CouponList>() {
                                    @Override
                                    public void onSuccess(CouponList response) {
                                        CouponList mCouponList = new CouponList();
                                        for (Coupon coupon : response) {
                                            for (Couponset couponset : result) {
                                                if (coupon.getCouponsetUuid().equals(couponset.getUuid())) {
                                                    coupon.setDescription(couponset.getShortDescription());
                                                    coupon.setImage(couponset.getImgPreview());
                                                    coupon.setName(couponset.getName());
                                                    coupon.setMerchantUuid(couponset.getMerchantUuid());
                                                    coupon.setInnerText(couponset.getInnerText());
                                                    coupon.setDiscount_type(couponset.getDiscount_type());
                                                    coupon.setFinal_price(couponset.getFinal_price());
                                                    mCouponList.add(coupon);
                                                }
                                            }
                                        }
                                        WarplyManagerHelper.setCouponList(mCouponList);

                                        CouponList mActiveCouponList = new CouponList();
                                        for (Coupon coupon : mCouponList) {
                                            if (coupon.getStatus() == 1) {
                                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                                                Date newDate = new Date();
                                                try {
                                                    newDate = simpleDateFormat.parse(coupon.getExpiration());
                                                } catch (ParseException e) {
                                                    e.printStackTrace();
                                                }
                                                coupon.setExpirationDate(newDate);
                                                mActiveCouponList.add(coupon);
                                            }
                                        }

                                        Collections.sort(mActiveCouponList, (coupon1, coupon2) -> coupon1.getExpirationDate().compareTo(coupon2.getExpirationDate()));

                                        receiver.onSuccess(mActiveCouponList);
                                    }

                                    @Override
                                    public void onFailure(int errorCode) {
                                        if (errorCode == 401) {
                                            refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                                                @Override
                                                public void onSuccess(JSONObject result) {
                                                    int status = result.optInt("status", 2);
                                                    if (status == 1)
                                                        getUserCoupons(request, receiver);
                                                    else
                                                        receiver.onFailure(status);
                                                }

                                                @Override
                                                public void onFailure(int errorCode) {
                                                    receiver.onFailure(errorCode);
                                                }
                                            });
                                        } else
                                            receiver.onFailure(errorCode);
                                    }
                                },
                                        request.getSignature()));
                            }

                            @Override
                            public void onFailure(int errorCode) {
                                receiver.onFailure(errorCode);
                            }
                        });
                    }

                    @Override
                    public void onFailure(int errorCode) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_shops_loyalty");
                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                        receiver.onFailure(errorCode);
                    }
                });
    }

    public static void getUserCouponsWithCouponsets(final CallbackReceiver<CouponList> receiver) {
        WarpUtils.log("************* WARPLY User Coupons Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Coupons Request is active");
        WarpUtils.log("**************************************************");

        ApiService service = ApiClient.getRetrofitInstance().create(ApiService.class);

        getMerchantsRetro(service, new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> responseMerchants) {
                if (responseMerchants.code() == 200 && responseMerchants.body() != null) {
                    JSONObject jobjMerchantsResponse = null;
                    try {
                        jobjMerchantsResponse = new JSONObject(responseMerchants.body().string());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    if (jobjMerchantsResponse != null && jobjMerchantsResponse.has("status") && jobjMerchantsResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_shops_loyalty");
                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                        JSONArray jMerchantsBody = null;
                        try {
                            jMerchantsBody = jobjMerchantsResponse.optJSONObject("context").optJSONObject("MAPP_SHOPS").optJSONArray("result");
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        if (jMerchantsBody != null) {
                            MerchantList mMerchantList = new MerchantList();

                            final ExecutorService executorShops = Executors.newFixedThreadPool(1);
                            JSONArray finalMerchantsJBody = jMerchantsBody;
                            executorShops.submit(() -> {
                                for (int i = 0; i < finalMerchantsJBody.length(); ++i) {
                                    mMerchantList.add(new Merchant(finalMerchantsJBody.optJSONObject(i)));
                                }
                                WarplyManagerHelper.setMerchantList(mMerchantList);
                                executorShops.shutdownNow();
                            });

                            getCouponsetsRetro(service, new Callback<ResponseBody>() {
                                @Override
                                public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> responseCouponsets) {
                                    if (responseCouponsets.code() == 200 && responseCouponsets.body() != null) {
                                        JSONObject jobjCouponsetsResponse = null;
                                        try {
                                            jobjCouponsetsResponse = new JSONObject(responseCouponsets.body().string());
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }

                                        if (jobjCouponsetsResponse != null && jobjCouponsetsResponse.has("status") && jobjCouponsetsResponse.optString("status", "2").equals("1")) {
                                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                            dynatraceEvent.setEventName("custom_success_couponsets_loyalty");
                                            EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                                            JSONObject finalJobjCouponsetsResponse = jobjCouponsetsResponse;
                                            getUserCouponsRetro(service, new Callback<ResponseBody>() {
                                                @Override
                                                public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> responseCoupons) {
                                                    if (responseCoupons.code() == 200 && responseCoupons.body() != null) {
                                                        JSONObject jobjCouponsResponse = null;
                                                        try {
                                                            jobjCouponsResponse = new JSONObject(responseCoupons.body().string());
                                                        } catch (Exception e) {
                                                            e.printStackTrace();
                                                        }

                                                        if (jobjCouponsResponse != null && jobjCouponsResponse.has("status") && jobjCouponsResponse.optInt("status", 2) == 1) {
                                                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                                            dynatraceEvent.setEventName("custom_success_user_coupons_loyalty");
                                                            EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                                                            JSONObject finalJobjCouponsResponse = jobjCouponsResponse;
                                                            final ExecutorService executor = Executors.newFixedThreadPool(1);
                                                            executor.submit(() -> {
                                                                // COUPONS START //
                                                                JSONArray jCouponsBody = null;
                                                                try {
                                                                    jCouponsBody = finalJobjCouponsResponse.optJSONArray("result");
                                                                } catch (Exception e) {
                                                                    e.printStackTrace();
                                                                }
                                                                // COUPONS END //

                                                                // COUPONSETS START //
                                                                JSONArray jCouponsetsBody = null;
                                                                try {
                                                                    jCouponsetsBody = finalJobjCouponsetsResponse.optJSONObject("context").optJSONArray("MAPP_COUPON");
                                                                } catch (Exception e) {
                                                                    e.printStackTrace();
                                                                }
                                                                // COUPONSETS END //

                                                                if (jCouponsetsBody != null && jCouponsBody != null) {
                                                                    CouponList mCouponList = new CouponList();
                                                                    CouponsetsList mCouponsetList = new CouponsetsList();
                                                                    for (int i = 0; i < jCouponsetsBody.length(); ++i) {
                                                                        Couponset tempCouponset = new Couponset(jCouponsetsBody.optJSONObject(i));
                                                                        mCouponsetList.add(tempCouponset);
                                                                        for (int j = 0; j < jCouponsBody.length(); ++j) {
                                                                            Coupon tempCoupon = new Coupon(jCouponsBody.optJSONObject(j));
                                                                            if (tempCoupon.getCouponsetUuid().equals(tempCouponset.getUuid())) {
                                                                                tempCoupon.setDescription(tempCouponset.getShortDescription());
                                                                                tempCoupon.setImage(tempCouponset.getImgPreview());
                                                                                tempCoupon.setName(tempCouponset.getName());
                                                                                tempCoupon.setMerchantUuid(tempCouponset.getMerchantUuid());
                                                                                tempCoupon.setInnerText(tempCouponset.getInnerText());
                                                                                tempCoupon.setDiscount_type(tempCouponset.getDiscount_type());
                                                                                tempCoupon.setFinal_price(tempCouponset.getFinal_price());
                                                                                mCouponList.add(tempCoupon);
                                                                            }
                                                                        }
                                                                    }
                                                                    WarplyManagerHelper.setCouponsets(mCouponsetList);
                                                                    WarplyManagerHelper.setCouponList(mCouponList);

                                                                    CouponList mActiveCouponList = new CouponList();
                                                                    for (Coupon coupon : mCouponList) {
                                                                        if (coupon.getStatus() == 1) {
                                                                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                                                                            Date newDate = new Date();
                                                                            try {
                                                                                newDate = simpleDateFormat.parse(coupon.getExpiration());
                                                                            } catch (
                                                                                    ParseException e) {
                                                                                e.printStackTrace();
                                                                            }
                                                                            coupon.setExpirationDate(newDate);
                                                                            mActiveCouponList.add(coupon);
                                                                        }
                                                                    }

                                                                    Collections.sort(mActiveCouponList, (coupon1, coupon2) -> coupon1.getExpirationDate().compareTo(coupon2.getExpirationDate()));

                                                                    new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(mActiveCouponList));
                                                                    executor.shutdownNow();
                                                                }
                                                            });
                                                        } else {
                                                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                                            dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                                                            EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                                                            receiver.onFailure(2);
                                                        }
                                                    } else {
                                                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                                        dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                                                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                                                        receiver.onFailure(responseCoupons.code());
                                                    }
                                                }

                                                @Override
                                                public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                                                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                                    dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                                                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                                                    receiver.onFailure(2);
                                                }
                                            });

                                        } else {
                                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                            dynatraceEvent.setEventName("custom_error_couponsets_loyalty");
                                            EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                                            receiver.onFailure(2);
                                        }

                                    } else {
                                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                        dynatraceEvent.setEventName("custom_error_couponsets_loyalty");
                                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                                        receiver.onFailure(responseCouponsets.code());
                                    }
                                }

                                @Override
                                public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                    dynatraceEvent.setEventName("custom_error_couponsets_loyalty");
                                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                                    receiver.onFailure(2);
                                }
                            });
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_shops_loyalty");
                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_shops_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                    receiver.onFailure(responseMerchants.code());
                }
            }

            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_shops_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                receiver.onFailure(2);
            }
        });
    }

    private static void getCouponsetsRetro(ApiService service, Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format("yyyy-MM-dd hh:mm:ss", System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());

        Map<String, Object> jsonParamsCouponsets = new ArrayMap<>();
        Map<String, Object> jsonParams = new ArrayMap<>();
        jsonParams.put("action", "retrieve_multilingual");
        jsonParams.put("active", true);
        jsonParams.put("visible", true);
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        JSONObject excludesKey = new JSONObject();
        try {
            excludesKey.putOpt("field", "couponset_type");
            excludesKey.putOpt("value", new JSONArray().put("supermarket"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        jsonParams.put("exclude", new JSONArray().put(excludesKey));

        jsonParamsCouponsets.put("coupon", jsonParams);
        RequestBody couponsetsRequest = RequestBody.create(MediaType.get("application/json; charset=utf-8"), (new JSONObject(jsonParamsCouponsets)).toString());

        Call<ResponseBody> couponsetsCall = service.getCouponsets(
                WarplyProperty.getAppUuid(Warply.getWarplyContext()),
                couponsetsRequest,
                timeStamp,
                "android:" + Warply.getWarplyContext().getPackageName(),
                new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(),
                "mobile",
                webId,
                WarpUtils.produceSignature(apiKey + timeStamp)
        );

        couponsetsCall.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                callback.onResponse(call, response);
            }

            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void getUnifiedCouponsRetro(ApiService service, Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format("yyyy-MM-dd hh:mm:ss", System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        Map<String, Object> jsonParamsCouponsets = new ArrayMap<>();
        Map<String, Object> jsonParams = new ArrayMap<>();
        jsonParams.put("action", "retrieve_unified_coupons");
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        jsonParamsCouponsets.put("coupon", jsonParams);
        RequestBody unifiedCouponsRequest = RequestBody.create(MediaType.get("application/json; charset=utf-8"), (new JSONObject(jsonParamsCouponsets)).toString());
        Call<ResponseBody> unifiedCouponsCall = service.getUnifiedCoupons(
                WarplyProperty.getAppUuid(Warply.getWarplyContext()),
                unifiedCouponsRequest,
                timeStamp,
                "android:" + Warply.getWarplyContext().getPackageName(),
                new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(),
                "mobile",
                webId,
                WarpUtils.produceSignature(apiKey + timeStamp),
                "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token")
        );
        unifiedCouponsCall.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getUnifiedCouponsRetro(service, callback);
                            else
                                callback.onFailure(call, new Throwable());
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onFailure(call, new Throwable());
                        }
                    });
                } else {
                    callback.onResponse(call, response);
                }
            }

            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void getMerchantsRetro(ApiService service, Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format("yyyy-MM-dd hh:mm:ss", System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());

        Map<String, Object> jsonParamsShops = new ArrayMap<>();
        Map<String, Object> jsonParams = new ArrayMap<>();
        jsonParams.put("action", "retrieve_multilingual");
        jsonParams.put("categories", new JSONArray());
        jsonParams.put("active", true);
        jsonParams.put("location", null);
        jsonParams.put("parent_uuids", null);
        jsonParams.put("tags", null);
        jsonParams.put("default_shown", null);
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));

        jsonParamsShops.put("shops", jsonParams);
        RequestBody merchantsRequest = RequestBody.create(MediaType.get("application/json; charset=utf-8"), (new JSONObject(jsonParamsShops)).toString());

        Call<ResponseBody> merchantsCall = service.getMerchants(
                WarplyProperty.getAppUuid(Warply.getWarplyContext()),
                merchantsRequest,
                timeStamp,
                "android:" + Warply.getWarplyContext().getPackageName(),
                new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(),
                "mobile",
                webId,
                WarpUtils.produceSignature(apiKey + timeStamp)
        );

        merchantsCall.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                callback.onResponse(call, response);
            }

            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void getUserCouponsRetro(ApiService service, Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format("yyyy-MM-dd hh:mm:ss", System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());

        Map<String, Object> jsonParamsCoupons = new ArrayMap<>();
        Map<String, Object> jsonParams = new ArrayMap<>();
        jsonParams.put("action", "get_user_coupons");
        JSONArray jArr = new JSONArray();
        jArr.put("transaction");
        jArr.put("communication");
        jsonParams.put("fetch_data", jArr);

        jsonParamsCoupons.put("coupon", jsonParams);
        RequestBody couponsRequest = RequestBody.create(MediaType.get("application/json; charset=utf-8"), (new JSONObject(jsonParamsCoupons)).toString());

        Call<ResponseBody> couponsCall = service.getUserCoupons(
                WarplyProperty.getAppUuid(Warply.getWarplyContext()),
                couponsRequest,
                timeStamp,
                "android:" + Warply.getWarplyContext().getPackageName(),
                new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(),
                "mobile",
                webId,
                WarpUtils.produceSignature(apiKey + timeStamp),
                "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token")
        );

        couponsCall.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getUserCouponsRetro(service, callback);
                            else
                                callback.onFailure(call, new Throwable());
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onFailure(call, new Throwable());
                        }
                    });
                } else {
                    callback.onResponse(call, response);
                }
            }

            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    public static void getCosmoteUser(WarplyCosmoteUserRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Cosmote User Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Cosmote User Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(false, "cosuser", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    JSONObject tokens = result.optJSONObject("result");
                    if (tokens != null) {
                        WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveClientAccess(
                                tokens.optString("client_id", ""),
                                tokens.optString("client_secret", "")
                        );

                        WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(
                                tokens.optString("access_token", ""),
                                tokens.optString("refresh_token", "")
                        );

                        JSONObject newResult = new JSONObject();
                        try {
                            newResult.putOpt("status", 1);
                            newResult.putOpt("message", "Success");
                            receiver.onSuccess(newResult);
                        } catch (JSONException e) {
                            e.printStackTrace();
                            receiver.onFailure(2);
                        }

                        getConsumer(new WarplyConsumerRequest(), new CallbackReceiver<Consumer>() {
                            @Override
                            public void onSuccess(Consumer result) {
                                WarplyManagerHelper.setConsumerInternal(result);

                                if (result != null) {
                                    JSONObject profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata());
                                    if (profMetadata != null && profMetadata.has("nonTelco")) {
                                        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), profMetadata.optBoolean("nonTelco"));
                                    } else {
                                        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
                                    }
                                }

                                if (result != null) {
                                    JSONObject profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata());
                                    if (profMetadata != null) {
                                        if (profMetadata.has("badge")) {
                                            WarpUtils.setUserTag(Warply.getWarplyContext(), profMetadata.optString("badge"));
                                        }

                                        if (profMetadata.has("steps_enabled") && profMetadata.optBoolean("steps_enabled")) {
                                            if (!isMyServiceRunning(WarplyHealthService.class)) {
                                                Intent stepsServiceIntent = new Intent(Warply.getWarplyContext(), WarplyHealthService.class);
                                                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                                                    AlarmManager mgr = (AlarmManager) Warply.getWarplyContext().getSystemService(Context.ALARM_SERVICE);
                                                    PendingIntent pi = PendingIntent.getService(Warply.getWarplyContext(), 2002, stepsServiceIntent, PendingIntent.FLAG_ONE_SHOT | PendingIntent.FLAG_MUTABLE);
                                                    mgr.set(AlarmManager.ELAPSED_REALTIME_WAKEUP, SystemClock.elapsedRealtime() + 1000, pi);
                                                } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                                    Warply.getWarplyContext().startForegroundService(stepsServiceIntent);
                                                } else {
                                                    Warply.getWarplyContext().startService(stepsServiceIntent);
                                                }

                                                WarplyPacingEventModel pacingVisible = new WarplyPacingEventModel();
                                                pacingVisible.setVisible(true);
                                                EventBus.getDefault().post(new WarplyEventBusManager(pacingVisible));
                                            }
                                        }
                                    }
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) {

                            }
                        });
                    } else
                        receiver.onFailure(2);
                } else
                    receiver.onFailure(status);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void submitOrder(CosmoteSubmitOrderRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Submit Order Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Submit Order Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_submit_order_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_submit_order_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                submitOrder(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_submit_order_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getSharingHistory(WarplySharingHistoryRequest request, final CallbackReceiver<SharingList> receiver) {
        WarpUtils.log("************* WARPLY Sharing History Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Sharing History Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(WarpConstants.MICROAPP_COUPONS, true, "context", request.toJson(), new SharingHook(new CallbackReceiver<SharingList>() {
            @Override
            public void onSuccess(SharingList response) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_sharing_history_loyalty");
                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                receiver.onSuccess(response);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                getSharingHistory(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_sharing_history_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        },
                request.getSignature()));
    }

    public static void postEvent(CosmotePostEventRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Post Event Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Post Event Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_post_event_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_post_event_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                postEvent(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_post_event_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void setPacingDetails(PacingCalculateRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Post Event Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Post Event Request is active");
        WarpUtils.log("**************************************************");

        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_save_pacing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_save_pacing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>() {
                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1)
                                setPacingDetails(request, receiver);
                            else
                                receiver.onFailure(status);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_save_pacing_loyalty");
                    EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getSingleCampaign(String sessionUuid) {
        WarpUtils.log("************* WARPLY Get Event Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Event Request is active");
        WarpUtils.log("**************************************************");

        String url = WarplyProperty.getBaseUrl(Warply.getWarplyContext()) + WarpConstants.BASE_REMOTE_PAGE_URL + sessionUuid;

        Warply.INSTANCE.getSingleCampaign(null, url,
                new CallbackReceiver<JSONObject>() {
                    @Override
                    public void onSuccess(JSONObject result) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_read_campaign_loyalty");
                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                        getCampaigns(new WarplyGetCampaignsRequest().setLanguage("en"), new CallbackReceiver<ArrayList<Campaign>>() {
                            @Override
                            public void onSuccess(ArrayList<Campaign> result) {
                                OneTimeWorkRequest mywork = new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
                                WorkManager.getInstance(Warply.getWarplyContext()).enqueue(mywork);
                            }

                            @Override
                            public void onFailure(int errorCode) {

                            }
                        });
                    }

                    @Override
                    public void onFailure(int errorCode) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_read_campaign_loyalty");
                        EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));

                        getCampaigns(new WarplyGetCampaignsRequest().setLanguage("en"), new CallbackReceiver<ArrayList<Campaign>>() {
                            @Override
                            public void onSuccess(ArrayList<Campaign> result) {
                                OneTimeWorkRequest mywork = new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
                                WorkManager.getInstance(Warply.getWarplyContext()).enqueue(mywork);
                            }

                            @Override
                            public void onFailure(int errorCode) {

                            }
                        });
                    }
                }, null);
    }

    public static void makeGetRequest(String url) {
//        Always run it in a new Thread, not in the main, ie Executors
//        new Thread(() -> {
//            makeGetRequest(session_uuid);
//        }).start();

//        Also add those two dependencies
//        api 'com.squareup.retrofit2:retrofit:2.9.0'
//        api 'com.squareup.okhttp3:okhttp:4.10.0'

//        And uncomment the code inside ApiService.java

//        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
//        httpClient.followRedirects(false)
//                .followSslRedirects(false);
//
//        Retrofit retrofit = new Retrofit.Builder()
//                .baseUrl(WarplyProperty.getBaseUrl(Warply.getWarplyContext()))
//                .client(httpClient.build())
//                .build();
//
//        RetrofitInterface service = retrofit.create(RetrofitInterface.class);
//        Call<ResponseBody> respo = service.getSingleCampaign(url);
//        respo.enqueue(new Callback<ResponseBody>() {
//            @Override
//            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
//                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
//                dynatraceEvent.setEventName("custom_success_read_campaign_loyalty");
//                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
//
//                getCampaigns(new WarplyGetCampaignsRequest().setLanguage("en"), new CallbackReceiver<ArrayList<Campaign>>() {
//                    @Override
//                    public void onSuccess(ArrayList<Campaign> result) {
//                        OneTimeWorkRequest mywork = new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
//                        WorkManager.getInstance(Warply.getWarplyContext()).enqueue(mywork);
//                    }
//
//                    @Override
//                    public void onFailure(int errorCode) {
//
//                    }
//                });
//            }
//
//            @Override
//            public void onFailure(Call<ResponseBody> call, Throwable t) {
//                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
//                dynatraceEvent.setEventName("custom_success_read_campaign_loyalty");
//                EventBus.getDefault().post(new WarplyEventBusManager(dynatraceEvent));
//
//                getCampaigns(new WarplyGetCampaignsRequest().setLanguage("en"), new CallbackReceiver<ArrayList<Campaign>>() {
//                    @Override
//                    public void onSuccess(ArrayList<Campaign> result) {
//                        OneTimeWorkRequest mywork = new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
//                        WorkManager.getInstance(Warply.getWarplyContext()).enqueue(mywork);
//                    }
//
//                    @Override
//                    public void onFailure(int errorCode) {
//
//                    }
//                });
//            }
//        });
    }

    private static boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager) Warply.getWarplyContext().getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (serviceClass.getName().equals(service.service.getClassName())) {
                return true;
            }
        }
        return false;
    }
}
