package ly.warp.sdk.utils.managers;

import android.content.Context;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

import ly.warp.sdk.Warply;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.receivers.WarplyBeaconsApplication;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyPreferences;
import ly.warp.sdk.utils.constants.WarpConstants;
import ly.warp.sdk.utils.constants.WarpConstants.LocationSetting;
import ly.warp.sdk.utils.constants.WarpConstants.MicroApp;

public class WarplyServerPreferencesManager {

    private static Map<WarpConstants.MicroApp, Boolean> MICRO_APP_STATUSES_MAP;

    public static void initiateMicroAppStatusesMap() {
        Map<MicroApp, Boolean> map = new HashMap<>();
        WarplyPreferences wPref = new WarplyPreferences(Warply.getWarplyContext());
        map.put(MicroApp.CONSUMER, wPref.getConsumerAppStatus());
        map.put(MicroApp.APPLICATION_DATA, wPref.getAppDataStatus());
        map.put(MicroApp.OFFERS, wPref.getOffersStatus());
        map.put(MicroApp.LIFECYCLE_ANALYTICS, wPref.getLifeCycleAnalyticsStatus());
        map.put(MicroApp.CUSTOM_ANALYTICS, wPref.getCustomAnalyticsStatus());
        map.put(MicroApp.USER_TAGGING, wPref.getUserTaggingStatus());
        map.put(MicroApp.DEVICE_INFO, wPref.getDeviceInfoStatus());
        map.put(MicroApp.USER_SESSION, wPref.getUserSessionStatus());
        map.put(MicroApp.BEACONS, wPref.getBeaconsStatus());
        map.put(MicroApp.RADIO_SILENT, wPref.getRadioSilentStatus());
        MICRO_APP_STATUSES_MAP = map;
    }

    public static void initiateMicroAppStatusesMap(Context context) {
        Map<MicroApp, Boolean> map = new HashMap<>();
        WarplyPreferences wPref = new WarplyPreferences(context);
        map.put(MicroApp.CONSUMER, wPref.getConsumerAppStatus());
        map.put(MicroApp.APPLICATION_DATA, wPref.getAppDataStatus());
        map.put(MicroApp.OFFERS, wPref.getOffersStatus());
        map.put(MicroApp.LIFECYCLE_ANALYTICS, wPref.getLifeCycleAnalyticsStatus());
        map.put(MicroApp.CUSTOM_ANALYTICS, wPref.getCustomAnalyticsStatus());
        map.put(MicroApp.USER_TAGGING, wPref.getUserTaggingStatus());
        map.put(MicroApp.DEVICE_INFO, wPref.getDeviceInfoStatus());
        map.put(MicroApp.USER_SESSION, wPref.getUserSessionStatus());
        map.put(MicroApp.BEACONS, wPref.getBeaconsStatus());
        map.put(MicroApp.RADIO_SILENT, wPref.getRadioSilentStatus());
        MICRO_APP_STATUSES_MAP = map;
    }

    public static boolean isMicroAppActive(MicroApp app) {

        if (MICRO_APP_STATUSES_MAP == null) {
            initiateMicroAppStatusesMap();
        }
        return MICRO_APP_STATUSES_MAP.get(app);
    }

    public static boolean isMicroAppActive(Context context, MicroApp app) {

        if (MICRO_APP_STATUSES_MAP == null) {
            initiateMicroAppStatusesMap(context);
        }
        return MICRO_APP_STATUSES_MAP.get(app);
    }

    public static void checkServerPreferences(
            final ServerPreferencesReceivedListener receiveListener) {

        Warply.getMicroappData(null, new CallbackReceiver<JSONObject>() {
            @Override
            public void onSuccess(JSONObject result) {

                if (result != null) {

                    JSONObject json = result.optJSONObject("context");
                    if (json != null) {

                        // micro app statuses
                        saveMicroAppStatusesAtPreferences(getMicroAppStatuses(result));

                        JSONObject appDataJson = json.optJSONObject("application_data");
                        if (appDataJson != null) {
                            // location settings
                            Warply.LOCATION_SETTINGS_MAP = new HashMap<>();
                            Warply.LOCATION_SETTINGS_MAP.put(LocationSetting.LOCATION_FOREGROUND_MODE, WarpJSONParser
                                    .getIntFromJSONObject(appDataJson, LocationSetting.LOCATION_FOREGROUND_MODE.getJsonKey(), 0));
                            Warply.LOCATION_SETTINGS_MAP.put(LocationSetting.FOREGROUND_MIN_TIME, WarpJSONParser
                                    .getIntFromJSONObject(appDataJson, LocationSetting.FOREGROUND_MIN_TIME.getJsonKey(), 60000));
                            Warply.LOCATION_SETTINGS_MAP.put(LocationSetting.FOREGROUND_MIN_DISTANCE, WarpJSONParser
                                    .getIntFromJSONObject(appDataJson, LocationSetting.FOREGROUND_MIN_DISTANCE.getJsonKey(), 100));
                            Warply.LOCATION_SETTINGS_MAP.put(LocationSetting.LOCATION_BACKGROUND_MODE, WarpJSONParser
                                    .getIntFromJSONObject(appDataJson, LocationSetting.LOCATION_BACKGROUND_MODE.getJsonKey(), 0));
                            Warply.LOCATION_SETTINGS_MAP.put(LocationSetting.BACKGROUND_MIN_TIME, WarpJSONParser
                                    .getIntFromJSONObject(appDataJson, LocationSetting.BACKGROUND_MIN_TIME.getJsonKey(), 60000));
                            Warply.LOCATION_SETTINGS_MAP.put(LocationSetting.BACKGROUND_MIN_DISTANCE, WarpJSONParser
                                    .getIntFromJSONObject(appDataJson, LocationSetting.BACKGROUND_MIN_DISTANCE.getJsonKey(), 100));
                            Warply.LOCATION_SETTINGS_MAP.put(LocationSetting.FEATURES_CHECK_INTERVAL, WarpJSONParser
                                    .getIntFromJSONObject(appDataJson, LocationSetting.FEATURES_CHECK_INTERVAL.getJsonKey(), 86400));

                            // beacons settings
                            WarplyPreferences pref = new WarplyPreferences(Warply.getWarplyContext());

                            pref.saveInt(WarpConstants.KEY_APP_VAR_BEACON_MAX_DISTANCE, WarpJSONParser.getIntFromJSONObject(appDataJson,
                                    WarpConstants.KEY_APP_VAR_BEACON_MAX_DISTANCE,
                                    WarplyBeaconsApplication.DEFAULT_BEACON_DISTANCE_TO_SEND));

                            long scanPeriod = WarpJSONParser.getLongFromJSONObject(appDataJson,
                                    WarpConstants.KEY_APP_VAR_BEACON_TIME_INTERVAL,
                                    WarplyBeaconsApplication.DEFAULT_SCAN_PERIOD);
                            pref.saveLong(WarpConstants.KEY_APP_VAR_BEACON_TIME_INTERVAL, scanPeriod ==
                                    WarplyBeaconsApplication.DEFAULT_SCAN_PERIOD ? scanPeriod : scanPeriod * 1000);

                            long timeInterval = WarpJSONParser.getLongFromJSONObject(appDataJson,
                                    WarpConstants.KEY_APP_VAR_BEACON_TIME_INTERVAL_TO_RESEND,
                                    WarplyBeaconsApplication.DEFAULT_BEACON_TIME_INTERVAL_TO_RESEND);
                            pref.saveLong(WarpConstants.KEY_APP_VAR_BEACON_TIME_INTERVAL_TO_RESEND, timeInterval ==
                                    WarplyBeaconsApplication.DEFAULT_BEACON_TIME_INTERVAL_TO_RESEND ? timeInterval : timeInterval * 1000);

                            String[] layouts = null;
                            JSONArray layoutsJson = appDataJson.optJSONArray(WarpConstants.KEY_APP_VAR_BEACON_LAYOUTS);
                            if (layoutsJson != null && layoutsJson.length() > 0) {
                                layouts = new String[layoutsJson.length()];
                                for (int i = 0; i < layoutsJson.length(); i++) {
                                    layouts[i] = layoutsJson.optString(i);
                                }
                            }
                            pref.saveStringArray(WarpConstants.KEY_APP_VAR_BEACON_LAYOUTS, layouts);

                            //updater
                            int newVersionCode = WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.KEY_APP_VAR_UPDATE_VERSION_CODE, 0);
                            pref.saveInt(WarpConstants.KEY_APP_VAR_UPDATE_VERSION_CODE, newVersionCode);

                            boolean hasUpdate = WarpJSONParser.getBooleanFromJSONObject(appDataJson, WarpConstants.KEY_APP_VAR_UPDATE_HAS, false);
                            pref.saveBoolean(WarpConstants.KEY_APP_VAR_UPDATE_HAS, hasUpdate);

                            boolean forceUpdate = WarpJSONParser.getBooleanFromJSONObject(appDataJson, WarpConstants.KEY_APP_VAR_UPDATE_FORCE, false);
                            pref.saveBoolean(WarpConstants.KEY_APP_VAR_UPDATE_FORCE, forceUpdate);

                        }

                        JSONObject deviceStatusJson = json
                                .optJSONObject("device_status");
                        if (deviceStatusJson != null) {
                            if (!deviceStatusJson
                                    .optBoolean("has_application_info")) {
                                Warply.resetApplicationInfo();
                            }
                            if (deviceStatusJson
                                    .optBoolean("has_device_info")) {
                                Warply.resetDeviceInfo();
                            }
                            if (!deviceStatusJson.optBoolean("is_warped")) {
                                Warply.resetIsWarped();
                            }
                        }
                    }
                }

                receiveListener.onServerPreferencesReceived();
            }


            @Override
            public void onFailure(int errorCode) {
                WarpUtils.log("Error with code " + errorCode
                        + " while checking app statuses");
            }
        });
    }

    private static Map<MicroApp, Boolean> getMicroAppStatuses(JSONObject result) {

        Map<MicroApp, Boolean> statuses = new HashMap<MicroApp, Boolean>(MicroApp.values().length);
        for (int i = 0; i < MicroApp.values().length; i++) {
            statuses.put(MicroApp.values()[i], true);
        }

        // Parse JSON to get application data
        JSONObject json = result.optJSONObject("context");
        if (json != null) {
            json = json.optJSONObject("application_data");
            if (json != null && json.has("WARPLY_ENABLED")) {
                if (json.optBoolean("WARPLY_ENABLED")) {
                    for (int i = 0; i < MicroApp.values().length; i++) {
                        statuses.put(MicroApp.values()[i], WarpJSONParser.getBooleanFromJSONObject(
                                json, MicroApp.values()[i].getJsonKey(), true));
                    }
                } else {
                    for (int i = 0; i < MicroApp.values().length; i++) {
                        statuses.put(MicroApp.values()[i], false);
                    }
                }
            }
        }
        return statuses;
    }

    private static void saveMicroAppStatusesAtPreferences(
            Map<MicroApp, Boolean> map) {
        MICRO_APP_STATUSES_MAP = map;
        WarplyPreferences wPref = new WarplyPreferences(Warply.getWarplyContext());
        wPref.saveConsumerAppStatus(map.get(MicroApp.CONSUMER));
        wPref.saveAppDataStatus(map.get(MicroApp.APPLICATION_DATA));
        wPref.saveOffersStatus(map.get(MicroApp.OFFERS));
        wPref.saveLifeCycleAnalyticsStatus(map.get(MicroApp.LIFECYCLE_ANALYTICS));
        wPref.saveCustomAnalyticsStatus(map.get(MicroApp.CUSTOM_ANALYTICS));
        wPref.saveUserTaggingStatus(map.get(MicroApp.USER_TAGGING));
        wPref.saveDeviceInfoStatus(map.get(MicroApp.DEVICE_INFO));
        wPref.saveUserSessionStatus(map.get(MicroApp.USER_SESSION));
        wPref.saveBeaconsStatus(map.get(MicroApp.BEACONS));
        wPref.saveRadioSilentStatus(map.get(MicroApp.RADIO_SILENT));
    }

    public interface ServerPreferencesReceivedListener {
        void onServerPreferencesReceived();
    }
}
