package ly.warp.sdk.views;

import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;

import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.Campaign;

public abstract class CampaignItemViewHolder extends RecyclerView.ViewHolder
        implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    protected Campaign mCampaign;

    // ===========================================================
    // Constructors
    // ===========================================================

    public CampaignItemViewHolder(ViewGroup root) {
        super(root);
        itemView.setOnClickListener(this);
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================


    @Override
    public void onClick(View v) {
        if (mCampaign != null) {
            v.getContext().startActivity(WarpViewActivity.createIntentFromSessionUUID(v.getContext(),
                    mCampaign.getSessionUUID()));
        }
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    public void bindData(Campaign campaign, int position) {
        this.mCampaign = campaign;
        setData(campaign, position);
    }

    protected abstract void setData(Campaign campaign, int position);

    /**
     * @return bound {@link Campaign} or null if was bound nothing
     */
    @Nullable
    public Campaign getCampaign() {
        return mCampaign;
    }

}
