package ly.warp.sdk.views;


import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.RelativeLayout;


import ly.warp.sdk.BuildConfig;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyDeviceInfoCollector;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.WarplyUrlHandler;
import ly.warp.sdk.utils.constants.WarpConstants;

public class CampaignItemWebHolder extends CampaignItemViewHolder {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private WarpView mWarpView;
    private View mProgress;

    // ===========================================================
    // Constructors
    // ===========================================================

    public CampaignItemWebHolder(ViewGroup root, int itemWidth, int itemHeight) {
        super(getWebItem(root.getContext(), itemWidth, itemHeight));

        itemView.setOnClickListener(null);
        mProgress = ((ViewGroup) itemView)
                .getChildAt(((ViewGroup) itemView).getChildCount() - 2);
        mProgress.setVisibility(View.VISIBLE);

        mWarpView = (WarpView) ((ViewGroup) itemView)
                .getChildAt(((ViewGroup) itemView).getChildCount() - 1);
        mWarpView.setVisibility(View.INVISIBLE);
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private static ViewGroup getWebItem(Context context, int itemWidth, int itemHeight) {

        final RelativeLayout root = new RelativeLayout(context);
        root.setBackgroundColor(Color.WHITE);

        itemWidth = itemWidth < AbsListView.LayoutParams.WRAP_CONTENT || itemWidth == 0 ?
                AbsListView.LayoutParams.MATCH_PARENT : itemWidth;
        itemHeight = itemHeight < AbsListView.LayoutParams.WRAP_CONTENT || itemHeight == 0 ?
                new WarplyDeviceInfoCollector(root.getContext()).getDisplayHeight() / 5 : itemHeight;
        root.setLayoutParams(new AbsListView.LayoutParams(itemWidth, itemHeight));

        // logo
        final ImageView ivLogo = new ImageView(context);
        RelativeLayout.LayoutParams ivLogoParams = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.MATCH_PARENT,
                RelativeLayout.LayoutParams.MATCH_PARENT);
        ivLogo.setPadding(10, 10, 10, 10);
        ivLogoParams.addRule(RelativeLayout.CENTER_IN_PARENT);
        root.addView(ivLogo, ivLogoParams);
        ivLogo.setImageDrawable(WarplyProperty.getProgressDrawable(context));
        ivLogo.startAnimation(WarpUtils.getPulseAnimation());

        // web view
        WarpView warpView = new WarpView(context);
        final RelativeLayout.LayoutParams warpViewParams = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.MATCH_PARENT,
                RelativeLayout.LayoutParams.MATCH_PARENT);
        warpView.setProgressChangeListener(new WarpView.ProgressChangeListener() {

            @Override
            public void onProgressChanged(WebView view, int newProgress) {

                if (view.getProgress() == 100) {

                    WarpUtils.animateVisibility(view, View.VISIBLE);
                    WarpUtils.animateVisibility(ivLogo, View.INVISIBLE);
                }
            }
        });
        warpView.setWarplyUrlHandler(new WarplyUrlHandler() {
            @Override
            public boolean canHandleUrl(String url) {

                if (!TextUtils.isEmpty(url)) {
                    String requestAuthority = Uri.parse(url).getAuthority();
                    return !Uri.parse(WarplyProperty.getBaseUrl(root.getContext()))
                            .getAuthority().equals(requestAuthority) &&
                            !Uri.parse(WarpConstants.WARPLY_CAMPAIGN_VIEW_BASE_URL)
                                    .getAuthority().equals(requestAuthority);
                }
                return false;
            }

            @Override
            public void handleUrl(Context context, String url) {

                try {
                    context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(url)));
                } catch (ActivityNotFoundException e) {
                    if (BuildConfig.DEBUG) {
                        e.printStackTrace();
                    }
                }
            }
        });
        warpView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return (event.getAction() == MotionEvent.ACTION_MOVE);
            }
        });
        warpView.setVerticalScrollBarEnabled(false);
        warpView.setHorizontalScrollBarEnabled(false);
        warpView.setScrollContainer(false);
        root.addView(warpView, warpViewParams);
        return root;
    }

    // ===========================================================
    // Methods
    // ===========================================================


    @Override
    public void bindData(Campaign campaign, int position) {

        if (TextUtils.isEmpty(mWarpView.getLastSessionUUID()) ||
                !mWarpView.getLastSessionUUID().equals(campaign.getSessionUUID())) {

            mWarpView.setVisibility(View.INVISIBLE);
            mProgress.setVisibility(View.VISIBLE);
            mWarpView.loadWarpSessionUUID(campaign.getSessionUUID());
        }
    }

    @Override
    protected void setData(Campaign campaign, int position) {
        // do nothing, call for external holders
    }

    @Override
    public void onClick(View v) {
        // do nothing
        // not possible click in web
    }

    // ===========================================================
    // Getter & Setter
    // ===========================================================


    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================
}
