package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.os.Build;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.Merchant;
import ly.warp.sdk.utils.WarplyManagerHelper;

public class ActiveCouponAdapter extends RecyclerView.Adapter<ActiveCouponAdapter.ActiveCouponViewHolder> {
    private Context mContext;
    private CouponList mCoupons;
    private final PublishSubject<Coupon> onClickSubject = PublishSubject.create();
    private boolean mIsPast = false, mIsCustom = false;

    public ActiveCouponAdapter(Context mContext, CouponList campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsPast = false;
    }

    public ActiveCouponAdapter(Context mContext, CouponList campaignList, boolean past) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsPast = past;
    }

    public ActiveCouponAdapter(Context mContext, CouponList campaignList, boolean past, boolean custom) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsPast = past;
        this.mIsCustom = custom;
    }

    public class ActiveCouponViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivCouponLogo, ivCouponBackground;
        private TextView tvCouponTitle, tvCouponValue, tvCouponDate, tvDateLimit,
                tvCouponDescription, tvCouponDateExpired;
        private ConstraintLayout clCustomLayout;
        private LinearLayout lLDateLimit;

        public ActiveCouponViewHolder(View view) {
            super(view);
            ivCouponBackground = view.findViewById(R.id.iv_past_coupon_background);
            ivCouponLogo = view.findViewById(R.id.iv_active_coupon);
            tvCouponTitle = view.findViewById(R.id.tv_active_coupons_title);
            tvCouponValue = view.findViewById(R.id.tv_active_coupons_value);
            tvCouponDate = view.findViewById(R.id.tv_active_coupons_date);
            tvCouponDescription = view.findViewById(R.id.tv_active_coupons_description);
            clCustomLayout = view.findViewById(R.id.cl_custom_layout);
            tvCouponDateExpired = view.findViewById(R.id.tv_active_coupons_date_expired);
            tvDateLimit = view.findViewById(R.id.tv_active_coupons_date_limit);
            lLDateLimit = view.findViewById(R.id.ll_date_limit);
        }
    }

    @Override
    public int getItemCount() {
        if (mCoupons == null)
            return 0;
        else
            return mCoupons.size();
    }

    public Coupon getItem(int id) {
        return mCoupons.get(id);
    }

    public void updateData(CouponList couponList) {
        mCoupons.clear();
        mCoupons.addAll(couponList);
        notifyDataSetChanged();
    }

    @Override
    public ActiveCouponViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;
        if (mIsPast)
            itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.past_coupon_layout, parent, false);
        else if (mIsCustom)
            itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.custom_coupon_layout, parent, false);
        else
            itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.active_coupon_layout, parent, false);
        return new ActiveCouponViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final ActiveCouponViewHolder holder, int position) {
        Coupon couponItem = mCoupons.get(position);
        Merchant merchant = new Merchant();
        if (mIsPast)
            holder.ivCouponBackground.setColorFilter(ContextCompat.getColor(mContext, R.color.grey_light3), android.graphics.PorterDuff.Mode.MULTIPLY);
        if (couponItem != null) {
            if (mIsCustom) {
                if (couponItem.getStatus() == 1) {
                    holder.ivCouponLogo.setAlpha(1.0f);
                    holder.tvCouponTitle.setAlpha(1.0f);
                    holder.tvCouponValue.setAlpha(1.0f);
                    holder.tvCouponDescription.setAlpha(1.0f);
                    holder.clCustomLayout.setBackgroundResource(R.drawable.ic_coupon_background_new2);
                } else {
                    holder.ivCouponLogo.setAlpha(0.29f);
                    holder.tvCouponTitle.setAlpha(0.29f);
                    holder.tvCouponValue.setAlpha(0.29f);
                    holder.tvCouponDescription.setAlpha(0.29f);
                    holder.clCustomLayout.setBackgroundResource(R.drawable.ic_coupon_background_new2);
                }
                if (WarplyManagerHelper.getMerchantList() != null && WarplyManagerHelper.getMerchantList().size() > 0) {
                    for (Merchant mer : WarplyManagerHelper.getMerchantList()) {
                        if (mer.getUuid().equals(couponItem.getMerchantUuid())) {
                            merchant = mer;
                            break;
                        }
                    }
                }
                if (merchant == null) {
                    if (!TextUtils.isEmpty(couponItem.getImage())) {
                        Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                                .load(couponItem.getImage())
                                .diskCacheStrategy(DiskCacheStrategy.DATA)
                                .into(holder.ivCouponLogo);
                    } else {
                        Glide.with(mContext)
                                .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                                .into(holder.ivCouponLogo);
                    }
                    holder.tvCouponTitle.setText(couponItem.getName());
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        holder.tvCouponDescription.setText(Html.fromHtml(couponItem.getDescription().equals("null") || TextUtils.isEmpty(couponItem.getDescription()) ? "" : couponItem.getDescription(), Html.FROM_HTML_MODE_COMPACT));
                    } else {
                        holder.tvCouponDescription.setText(Html.fromHtml(couponItem.getDescription().equals("null") || TextUtils.isEmpty(couponItem.getDescription()) ? "" : couponItem.getDescription()));
                    }
                } else {
                    if (!TextUtils.isEmpty(merchant.getImgPreview())) {
                        Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                                .load(merchant.getImgPreview())
                                .diskCacheStrategy(DiskCacheStrategy.DATA)
                                .into(holder.ivCouponLogo);
                    } else {
                        Glide.with(mContext)
                                .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                                .into(holder.ivCouponLogo);
                    }
                    holder.tvCouponTitle.setText(merchant.getAdminName());
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        holder.tvCouponDescription.setText(Html.fromHtml(couponItem.getInnerText().equals("null") || TextUtils.isEmpty(couponItem.getInnerText()) ? "" : couponItem.getInnerText(), Html.FROM_HTML_MODE_COMPACT));
                    } else {
                        holder.tvCouponDescription.setText(Html.fromHtml(couponItem.getInnerText().equals("null") || TextUtils.isEmpty(couponItem.getInnerText()) ? "" : couponItem.getInnerText()));
                    }
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                Date newDate = new Date();
                try {
                    newDate = simpleDateFormat.parse(couponItem.getExpiration());
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                if (mIsPast)
                    holder.tvCouponDate.setText(String.format(mContext.getString(R.string.cos_coupon_expired_date), simpleDateFormat.format(newDate != null ? newDate : "")));
                else {
                    long days = getDaysBetweenDates(simpleDateFormat.format(new Date()), simpleDateFormat.format(newDate != null ? newDate : ""));
                    holder.tvCouponDate.setText(String.format(mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
                    if (couponItem.getStatus() == 1) {
                        if (days < 15) {
                            holder.tvCouponDate.setText("");
                            holder.tvCouponDate.setVisibility(View.VISIBLE);
                            holder.tvCouponDateExpired.setVisibility(View.GONE);
                            holder.tvDateLimit.setText(String.format(mContext.getString(R.string.cos_coupon_date_limit2), simpleDateFormat.format(newDate != null ? newDate : "")));
                            holder.lLDateLimit.setVisibility(View.VISIBLE);
                        } else {
                            holder.tvCouponDate.setVisibility(View.VISIBLE);
                            holder.tvCouponDateExpired.setVisibility(View.GONE);
                            holder.tvCouponDate.setText(String.format(mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
                        }
                    } else {
                        holder.tvCouponDate.setVisibility(View.GONE);
                        holder.tvCouponDateExpired.setVisibility(View.VISIBLE);
                        holder.tvCouponDateExpired.setText(mContext.getString(R.string.cos_market_coupon_expired));
                    }
                }
                if (TextUtils.isEmpty(couponItem.getDiscount_type())) {
                    holder.tvCouponValue.setText(couponItem.getDiscount().replace(".", ",") + mContext.getResources().getString(R.string.euro));
                } else {
                    if (couponItem.getDiscount_type().equals("value")) {
                        holder.tvCouponValue.setText(couponItem.getDiscount().replace(".", ",") + mContext.getResources().getString(R.string.euro));
                    } else if (couponItem.getDiscount_type().equals("percentage")) {
                        holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.percentage));
                    } else if (couponItem.getDiscount_type().equals("plus_one")) {
                        holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.plus_one));
                    } else {
                        holder.tvCouponValue.setText(couponItem.getDiscount().replace(".", ",") + mContext.getResources().getString(R.string.euro));
                    }
                }
                holder.itemView.setOnClickListener(v -> onClickSubject.onNext(couponItem));
                return;
            }
            if (WarplyManagerHelper.getMerchantList() != null && WarplyManagerHelper.getMerchantList().size() > 0) {
                for (Merchant mer : WarplyManagerHelper.getMerchantList()) {
                    if (mer.getUuid().equals(couponItem.getMerchantUuid())) {
                        merchant = mer;
                        break;
                    }
                }
            }
            if (merchant == null) {
                if (!TextUtils.isEmpty(couponItem.getImage())) {
                    Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                            .load(couponItem.getImage())
                            .diskCacheStrategy(DiskCacheStrategy.DATA)
                            .into(holder.ivCouponLogo);
                } else {
                    Glide.with(mContext)
                            .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                            .into(holder.ivCouponLogo);
                }
                holder.tvCouponTitle.setText(couponItem.getName());
                if (!mIsPast) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        holder.tvCouponDescription.setText(Html.fromHtml(couponItem.getInnerText(), Html.FROM_HTML_MODE_COMPACT));
                    } else {
                        holder.tvCouponDescription.setText(Html.fromHtml(couponItem.getInnerText()));
                    }
                }
            } else {
                if (!TextUtils.isEmpty(merchant.getImgPreview())) {
                    Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                            .load(merchant.getImgPreview())
                            .diskCacheStrategy(DiskCacheStrategy.DATA)
                            .into(holder.ivCouponLogo);
                } else {
                    Glide.with(mContext)
                            .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                            .into(holder.ivCouponLogo);
                }
                holder.tvCouponTitle.setText(merchant.getAdminName());
                if (!mIsPast) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        holder.tvCouponDescription.setText(Html.fromHtml(couponItem.getInnerText(), Html.FROM_HTML_MODE_COMPACT));
                    } else {
                        holder.tvCouponDescription.setText(Html.fromHtml(couponItem.getInnerText()));
                    }
                }
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(couponItem.getExpiration());
            } catch (ParseException e) {
                e.printStackTrace();
            }
            simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            if (mIsPast)
                holder.tvCouponDate.setText(String.format(mContext.getString(R.string.cos_coupon_expired_date), simpleDateFormat.format(newDate != null ? newDate : "")));
            else
                holder.tvCouponDate.setText(String.format(mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
            if (TextUtils.isEmpty(couponItem.getDiscount_type())) {
                holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.euro));
            } else {
                if (couponItem.getDiscount_type().equals("value")) {
                    holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.euro));
                } else if (couponItem.getDiscount_type().equals("percentage")) {
                    holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.percentage));
                } else if (couponItem.getDiscount_type().equals("plus_one")) {
                    holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.plus_one));
                } else {
                    holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.euro));
                }
            }
            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(couponItem));
        }
    }

    private long getDaysBetweenDates(String start, String end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date startDate, endDate;
        long numberOfDays = 0;
        try {
            startDate = dateFormat.parse(start);
            endDate = dateFormat.parse(end);
            numberOfDays = getUnitBetweenDates(startDate, endDate, TimeUnit.DAYS);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return numberOfDays;
    }

    private long getUnitBetweenDates(Date startDate, Date endDate, TimeUnit unit) {
        long timeDiff = endDate.getTime() - startDate.getTime();
        return unit.convert(timeDiff, TimeUnit.MILLISECONDS);
    }

    public Observable<Coupon> getPositionClicks() {
        return onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }
}