package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;

public class ActiveRewardAdapter extends RecyclerView.Adapter<ActiveRewardAdapter.ActiveRewardViewHolder> {

    private Context mContext;
    private CouponList mRewards;
    private final PublishSubject<Coupon> onClickSubject = PublishSubject.create();

    public ActiveRewardAdapter(Context mContext, CouponList campaignList) {
        this.mContext = mContext;
        this.mRewards = campaignList;
    }

    public class ActiveRewardViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivRewardLogo;
        private TextView tvRewardTitle, tvRewardDescription;

        public ActiveRewardViewHolder(View view) {
            super(view);
            ivRewardLogo = view.findViewById(R.id.iv_active_reward);
            tvRewardTitle = view.findViewById(R.id.tv_active_reward_title);
            tvRewardDescription = view.findViewById(R.id.tv_active_reward_description);
        }
    }

    @Override
    public int getItemCount() {
        if (mRewards == null)
            return 0;
        else
            return mRewards.size();
    }


    public Coupon getItem(int id) {
        return mRewards.get(id);
    }

    public void updateData(CouponList couponList) {
        mRewards.clear();
        mRewards.addAll(couponList);
        notifyDataSetChanged();
    }


    @Override
    public ActiveRewardViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;
        itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.active_rewards_layout, parent, false);
        return new ActiveRewardViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final ActiveRewardViewHolder holder, int position) {
        Coupon couponItem = mRewards.get(position);

        if (couponItem != null) {
            if (!TextUtils.isEmpty(couponItem.getImage())) {
                Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                        .load(couponItem.getImage())
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivRewardLogo);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivRewardLogo);
            }

            holder.tvRewardTitle.setText(couponItem.getName());
            holder.tvRewardDescription.setText(couponItem.getDescription());
            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(couponItem));
        }
    }

    public Observable<Coupon> getPositionClicks() {
        return onClickSubject.cache();
    }
}
