package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.Merchant;
import ly.warp.sdk.utils.WarplyManagerHelper;

public class ExpiredCouponAdapter extends RecyclerView.Adapter<ExpiredCouponAdapter.ExpiredCouponViewHolder> {

    private Context mContext;
    private /*CouponList*/ ArrayList<Coupon> mCoupons;
    private final PublishSubject<Coupon> onClickSubject = PublishSubject.create();
    private boolean mIsCustom = false;

    public ExpiredCouponAdapter(Context mContext, CouponList campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
    }

    public ExpiredCouponAdapter(Context mContext, ArrayList<Coupon> campaignList) {
        this.mContext = mContext;
        this.mCoupons = /*(CouponList)*/ campaignList;
    }

    public ExpiredCouponAdapter(Context mContext, ArrayList<Coupon> campaignList, boolean custom) {
        this.mContext = mContext;
        this.mCoupons = /*(CouponList)*/ campaignList;
        this.mIsCustom = custom;
    }

    public class ExpiredCouponViewHolder extends RecyclerView.ViewHolder {
        private TextView tvCouponTitle, tvCouponValue, tvCouponDate;
        private ImageView ivCouponLogo;

        public ExpiredCouponViewHolder(View view) {
            super(view);
            tvCouponTitle = view.findViewById(R.id.tv_expired_coupons_title);
            tvCouponValue = view.findViewById(R.id.tv_expired_coupons_value);
            tvCouponDate = view.findViewById(R.id.tv_expired_coupons_date);
            ivCouponLogo = view.findViewById(R.id.iv_expired_logo);
        }
    }

    @Override
    public int getItemCount() {
        if (mCoupons == null)
            return 0;
        else
            return mCoupons.size();
    }


    public Coupon getItem(int id) {
        return mCoupons.get(id);
    }

    public void updateData(CouponList couponList) {
        mCoupons.clear();
        mCoupons.addAll(couponList);
        notifyDataSetChanged();
    }


    @Override
    public ExpiredCouponViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;
        itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.expired_coupon_layout, parent, false);
        return new ExpiredCouponViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final ExpiredCouponViewHolder holder, int position) {
        Coupon couponItem = mCoupons.get(position);
        Merchant merchant = new Merchant();

        if (couponItem != null) {
            if (mIsCustom) {
                if (WarplyManagerHelper.getMerchantList() != null && WarplyManagerHelper.getMerchantList().size() > 0) {
                    for (Merchant mer : WarplyManagerHelper.getMerchantList()) {
                        if (mer.getUuid().equals(couponItem.getMerchantUuid())) {
                            merchant = mer;
                            break;
                        }
                    }
                }

                if (merchant == null) {
                    holder.tvCouponTitle.setText(couponItem.getName());
                    if (!TextUtils.isEmpty(couponItem.getImage())) {
                        Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                                .load(couponItem.getImage())
                                .diskCacheStrategy(DiskCacheStrategy.DATA)
                                .into(holder.ivCouponLogo);
                    }
                } else {
                    holder.tvCouponTitle.setText(merchant.getAdminName());
                    if (!TextUtils.isEmpty(merchant.getImgPreview())) {
                        Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                                .load(merchant.getImgPreview())
                                .diskCacheStrategy(DiskCacheStrategy.DATA)
                                .into(holder.ivCouponLogo);
                    }
                }

                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                Date newDate = new Date();
                try {
                    newDate = simpleDateFormat.parse(couponItem.getChangesDates().optString("redeemed"));
                    simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                    holder.tvCouponDate.setText(simpleDateFormat.format(newDate != null ? newDate : ""));
                } catch (ParseException e) {
                    e.printStackTrace();
                    holder.tvCouponDate.setVisibility(View.GONE);
                }

                String itemValue = String.format("%.02f", Float.valueOf(couponItem.getDiscount()));
                holder.tvCouponValue.setText(itemValue + mContext.getResources().getString(R.string.euro));
                holder.itemView.setOnClickListener(v -> onClickSubject.onNext(couponItem));
                return;
            }

            if (WarplyManagerHelper.getMerchantList() != null && WarplyManagerHelper.getMerchantList().size() > 0) {
                for (Merchant mer : WarplyManagerHelper.getMerchantList()) {
                    if (mer.getUuid().equals(couponItem.getMerchantUuid())) {
                        merchant = mer;
                        break;
                    }
                }
            }

            if (merchant == null) {
                holder.tvCouponTitle.setText(couponItem.getName());
            } else {
                holder.tvCouponTitle.setText(merchant.getAdminName());
                if (!TextUtils.isEmpty(merchant.getImgPreview())) {
                    Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                            .load(merchant.getImgPreview())
                            .diskCacheStrategy(DiskCacheStrategy.DATA)
                            .into(holder.ivCouponLogo);
                }
            }

            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(couponItem.getChangesDates().optString("redeemed"));
                simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                holder.tvCouponDate.setText(simpleDateFormat.format(newDate != null ? newDate : ""));
            } catch (ParseException e) {
                e.printStackTrace();
                holder.tvCouponDate.setVisibility(View.GONE);
            }

            String itemValue = String.format("%.02f", couponItem.getFinal_price());
            holder.tvCouponValue.setText(itemValue + mContext.getResources().getString(R.string.euro));
            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(couponItem));
        }
    }

    public Observable<Coupon> getPositionClicks() {
        return onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }
}
