package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;


public class HomeCampaignAdapter extends RecyclerView.Adapter<HomeCampaignAdapter.HomeCampaignViewHolder> {

    private Context mContext;
    private CampaignList mCampaigns;
    private final PublishSubject<Campaign> onClickSubject = PublishSubject.create();

    public HomeCampaignAdapter(Context mContext, CampaignList campaignList) {
        this.mContext = mContext;
        this.mCampaigns = campaignList;
    }

    public class HomeCampaignViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivCampaignTitle;
        private TextView tvCampaignTitle;

        public HomeCampaignViewHolder(View view) {
            super(view);
            ivCampaignTitle = view.findViewById(R.id.imageView);
            tvCampaignTitle = view.findViewById(R.id.textView);
        }
    }

    @Override
    public int getItemCount() {
        if (mCampaigns == null)
            return 0;
        else
            return mCampaigns.size();
    }


    public Campaign getItem(int id) {
        return mCampaigns.get(id);
    }

    public void updateData(CampaignList campaignList) {
        mCampaigns.clear();
        mCampaigns.addAll(campaignList);
        notifyDataSetChanged();
    }


    @Override
    public HomeCampaignViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.carousel_item, parent, false);
        return new HomeCampaignViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final HomeCampaignViewHolder holder, int position) {
        Campaign campaignItem = mCampaigns.get(position);

        if (campaignItem != null) {
            if (!TextUtils.isEmpty(campaignItem.getLogoUrl())) {
                Glide.with(mContext)
                        .load(campaignItem.getLogoUrl())
                        .transform(new CenterCrop(), new RoundedCorners(10))
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivCampaignTitle);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivCampaignTitle);
            }

            holder.tvCampaignTitle.setText(campaignItem.getTitle());

            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(campaignItem));
        }
    }

    public Observable<Campaign> getPositionClicks() {
        return onClickSubject.cache();
    }
}
