package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;

public class HomeCouponAdapter extends RecyclerView.Adapter<HomeCouponAdapter.HomeCouponViewHolder> {

    private Context mContext;
    private CouponList mCoupons;
    private final PublishSubject<Coupon> onClickSubject = PublishSubject.create();
    private boolean isBurnt = false;

    public HomeCouponAdapter(Context mContext, CouponList campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.isBurnt = false;
    }

    public HomeCouponAdapter(Context mContext, CouponList campaignList, boolean isBurnt) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.isBurnt = isBurnt;
    }

    public class HomeCouponViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivCouponBackground;
        private TextView tvCouponTitle;

        public HomeCouponViewHolder(View view) {
            super(view);
            ivCouponBackground = view.findViewById(R.id.imageView2);
            tvCouponTitle = view.findViewById(R.id.tv_coupon_subtitle);
        }
    }

    @Override
    public int getItemCount() {
        if (mCoupons == null)
            return 0;
        else
            return mCoupons.size();
    }


    public Coupon getItem(int id) {
        return mCoupons.get(id);
    }

    public void updateData(CouponList couponList) {
        mCoupons.clear();
        mCoupons.addAll(couponList);
        notifyDataSetChanged();
    }


    @Override
    public HomeCouponViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;
        if (isBurnt)
            itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.burnt_coupon_layout, parent, false);
        else
            itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.coupon_layout, parent, false);
        return new HomeCouponViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final HomeCouponViewHolder holder, int position) {
        Coupon couponItem = mCoupons.get(position);

        if (couponItem != null) {
//            if (!TextUtils.isEmpty(couponItem.getImage())) {
//                Glide.with(mContext)
////                        .setDefaultRequestOptions(
////                                RequestOptions
////                                        .placeholderOf(R.drawable.ic_default_contact_photo)
////                                        .error(R.drawable.ic_default_contact_photo))
//                        .load(couponItem.getImage())
//                        .diskCacheStrategy(DiskCacheStrategy.DATA)
//                        .into(holder.ivCouponTitle);
//            } else {
//                Glide.with(mContext)
//                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
//                        .into(holder.ivCouponTitle);
//            }

            holder.tvCouponTitle.setText(couponItem.getName());

            if (isBurnt)
                holder.ivCouponBackground.setColorFilter(ContextCompat.getColor(mContext, R.color.grey_light2), android.graphics.PorterDuff.Mode.MULTIPLY);
            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(couponItem));
        }
    }

    public Observable<Coupon> getPositionClicks() {
        return onClickSubject.cache();
    }
}
