package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.UnifiedCoupon;

public class MarketCouponAdapter extends RecyclerView.Adapter<MarketCouponAdapter.ActiveCouponViewHolder> {

    private Context mContext;
    private ArrayList<UnifiedCoupon> mCoupons;
    private final PublishSubject<UnifiedCoupon> onClickSubject = PublishSubject.create();
    private boolean mIsPast = false;

    public MarketCouponAdapter(Context mContext, ArrayList<UnifiedCoupon> campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsPast = false;
    }

    public MarketCouponAdapter(Context mContext, ArrayList<UnifiedCoupon> campaignList, boolean past) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsPast = past;
    }

    public class ActiveCouponViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivCouponBackground;
        private TextView tvCouponTitle, tvCouponDate, tvCouponCount;

        public ActiveCouponViewHolder(View view) {
            super(view);
            ivCouponBackground = view.findViewById(R.id.iv_past_coupon_background);
            tvCouponTitle = view.findViewById(R.id.tv_market_coupons_title);
            tvCouponDate = view.findViewById(R.id.tv_market_coupons_date);
            tvCouponCount = view.findViewById(R.id.tv_market_coupons_count);
        }
    }

    @Override
    public int getItemCount() {
        if (mCoupons == null)
            return 0;
        else
            return mCoupons.size();
    }


    public UnifiedCoupon getItem(int id) {
        return mCoupons.get(id);
    }

    public void updateData(ArrayList<UnifiedCoupon> couponList) {
        mCoupons.clear();
        mCoupons.addAll(couponList);
        notifyDataSetChanged();
    }


    @Override
    public ActiveCouponViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;
        if (mIsPast)
            itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.past_coupon_layout, parent, false);
        else
            itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.market_coupon_layout, parent, false);
        return new ActiveCouponViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final ActiveCouponViewHolder holder, int position) {
        UnifiedCoupon couponItem = mCoupons.get(position);

        if (couponItem != null) {
            int count = 0;
            if (couponItem.getCoupons() != null && couponItem.getCoupons().size() > 0) {
                ArrayList<Coupon> couponList = new ArrayList<Coupon>();
                for (Coupon item : couponItem.getCoupons()) {
                    if (item.getStatus() == 1) {
                        count++;
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        Date newDate = new Date();
                        try {
                            newDate = simpleDateFormat.parse(item.getExpiration());
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                        item.setExpirationDate(newDate);
                        couponList.add(item);
                    }
                }

                Collections.sort(couponList, (coupon1, coupon2) -> coupon1.getExpirationDate().compareTo(coupon2.getExpirationDate()));

                if (couponList != null && couponList.size() > 0) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    Date newDate = new Date();
                    try {
                        newDate = simpleDateFormat.parse(couponList.get(0).getExpiration());
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                    holder.tvCouponDate.setText(String.format(mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
                }
            }

            if (count > 1) {
                holder.tvCouponCount.setText(String.format(mContext.getString(R.string.cos_market_active_coupons), String.valueOf(count)));
            } else if (count == 1) {
                holder.tvCouponCount.setText(String.format(mContext.getString(R.string.cos_market_active_coupons_single), String.valueOf(count)));
            }


//            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
//            Date newDate = new Date();
//            try {
//                newDate = simpleDateFormat.parse(couponItem.getExpiration());
//            } catch (ParseException e) {
//                e.printStackTrace();
//            }
//            simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
//            if (mIsPast)
//                holder.tvCouponDate.setText(String.format(mContext.getString(R.string.cos_coupon_expired_date), simpleDateFormat.format(newDate != null ? newDate : "")));
//            else
//                holder.tvCouponDate.setText(String.format(mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));

//            if (TextUtils.isEmpty(couponItem.getDiscount_type())) {
//                holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.euro));
//            } else {
//                if (couponItem.getDiscount_type().equals("value")) {
//                    holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.euro));
//                } else if (couponItem.getDiscount_type().equals("percentage")) {
//                    holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.percentage));
//                } else if (couponItem.getDiscount_type().equals("plus_one")) {
//                    holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.plus_one));
//                } else {
//                    holder.tvCouponValue.setText(couponItem.getDiscount() + mContext.getResources().getString(R.string.euro));
//                }
//            }
            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(couponItem));
        }
    }

    public Observable<UnifiedCoupon> getPositionClicks() {
        return onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }
}
