package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.MergedActiveGifts;
import ly.warp.sdk.io.models.MergedGifts;

public class MergedActiveGiftsAdapter extends RecyclerView.Adapter<MergedActiveGiftsAdapter.MergedActiveGiftsViewHolder> {

    private Context mContext;
    private ArrayList<MergedActiveGifts> mMergedActiveGifts;
    private final PublishSubject<MergedActiveGifts> onClickSubject = PublishSubject.create();

    public MergedActiveGiftsAdapter(Context mContext, ArrayList<MergedActiveGifts> mergedactivegifts) {
        this.mContext = mContext;
        this.mMergedActiveGifts = mergedactivegifts;
    }

    public class MergedActiveGiftsViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivMergedActiveGiftsLogo;
        private TextView tvMergedActiveGiftsTitle, tvMergedActiveGiftsValue, tvMergedActiveGiftsDate,
                tvMergedActiveGiftsDescription;

        public MergedActiveGiftsViewHolder(View view) {
            super(view);
            ivMergedActiveGiftsLogo = view.findViewById(R.id.iv_active_coupon);
            tvMergedActiveGiftsTitle = view.findViewById(R.id.tv_active_coupons_title);
            tvMergedActiveGiftsValue = view.findViewById(R.id.tv_active_coupons_value);
            tvMergedActiveGiftsDate = view.findViewById(R.id.tv_active_coupons_date);
            tvMergedActiveGiftsDescription = view.findViewById(R.id.tv_active_coupons_description);
        }
    }

    @Override
    public int getItemCount() {
        if (mMergedActiveGifts == null)
            return 0;
        else
            return mMergedActiveGifts.size();
    }


    public MergedActiveGifts getItem(int id) {
        return mMergedActiveGifts.get(id);
    }

    public void updateData(ArrayList<MergedActiveGifts> mergedactivegifts) {
        mMergedActiveGifts.clear();
        mMergedActiveGifts.addAll(mergedactivegifts);
        notifyDataSetChanged();
    }

    @Override
    public MergedActiveGiftsViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;
//        if ()
//            itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_merged_gifts_recycler, parent, false);
//        else
        itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.active_coupon_layout, parent, false);
        return new MergedActiveGiftsViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final MergedActiveGiftsViewHolder holder, int position) {
        MergedActiveGifts mergedgiftsItem = mMergedActiveGifts.get(position);
        if (mergedgiftsItem != null && mergedgiftsItem.getDataType() == 1) {
            if (!TextUtils.isEmpty(mergedgiftsItem.getCampaign().getLogoUrl())) {
                Glide.with(mContext)
                        .load(mergedgiftsItem.getCampaign().getLogoUrl())
                        .transform(new CenterCrop(), new RoundedCorners(4))
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivMergedActiveGiftsLogo);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivMergedActiveGiftsLogo);
            }

            holder.tvMergedActiveGiftsTitle.setText(mergedgiftsItem.getCampaign().getTitle());
        } else if (mergedgiftsItem != null && mergedgiftsItem.getDataType() == 2) {
            if (!TextUtils.isEmpty(mergedgiftsItem.getCoupon().getImage())) {
                Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                        .load(mergedgiftsItem.getCoupon().getImage())
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivMergedActiveGiftsLogo);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivMergedActiveGiftsLogo);
            }

            holder.tvMergedActiveGiftsTitle.setText(mergedgiftsItem.getCoupon().getName());
            holder.tvMergedActiveGiftsDescription.setText(mergedgiftsItem.getCoupon().getDescription());

            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(mergedgiftsItem.getCoupon().getExpiration());
            } catch (ParseException e) {
                e.printStackTrace();
            }
            simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            holder.tvMergedActiveGiftsDate.setText(String.format(mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));

            holder.tvMergedActiveGiftsValue.setText(mergedgiftsItem.getCoupon().getDiscount() + mContext.getResources().getString(R.string.euro));
        }
        holder.itemView.setOnClickListener(v -> onClickSubject.onNext(mergedgiftsItem));
    }

    public Observable<MergedActiveGifts> getPositionClicks() {
        return onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }
}
