package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;

import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.GiftsForYouActivity;
import ly.warp.sdk.activities.TelcoActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.MergedGifts;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;

public class MergedGiftsAdapter extends RecyclerView.Adapter<MergedGiftsAdapter.MergedGiftsViewHolder> {

    private Context mContext;
    private ArrayList<MergedGifts> mMergedGifts = new ArrayList<>();
    private final PublishSubject<MergedGifts> onClickSubject = PublishSubject.create();

    public MergedGiftsAdapter(Context mContext, ArrayList<MergedGifts> mergedgifts) {
        this.mContext = mContext;
        this.mMergedGifts.clear();
        this.mMergedGifts.addAll(mergedgifts);
    }

    public class MergedGiftsViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivMergedGiftsLogo, ivIsNew;
        private TextView tvMergedGiftsTitle;

        public MergedGiftsViewHolder(View view) {
            super(view);
            ivMergedGiftsLogo = view.findViewById(R.id.iv_campaign_logo);
            tvMergedGiftsTitle = view.findViewById(R.id.tv_campaign_title);
            ivIsNew = view.findViewById(R.id.iv_campaign_new);
        }
    }

    @Override
    public int getItemCount() {
        if (mMergedGifts == null)
            return 0;
        else
            return mMergedGifts.size();
    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    public MergedGifts getItem(int id) {
        return mMergedGifts.get(id);
    }

    public void updateData(ArrayList<MergedGifts> mergedgifts) {
        mMergedGifts.clear();
        mMergedGifts.addAll(mergedgifts);
        notifyDataSetChanged();
    }


    @Override
    public MergedGiftsViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;
        itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_merged_gifts_recycler, parent, false);
        return new MergedGiftsViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final MergedGiftsViewHolder holder, int position) {
        MergedGifts mergedgiftsItem = mMergedGifts.get(position);
        if (mergedgiftsItem != null && mergedgiftsItem.getDataType() == 1) {
            JSONObject extraFields = WarpJSONParser.getJSONFromString(mergedgiftsItem.getCampaign().getExtraFields());
            if (extraFields != null) {
                if (extraFields.has("type") && extraFields.optString("type").equals("telco")) {
                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                        if (ccms.getLoyaltyCampaignId().equals(mergedgiftsItem.getCampaign().getSessionUUID())) {
                            if (!TextUtils.isEmpty(ccms.getImageUrl())) {
                                Glide.with(mContext)
                                        .load(ccms.getImageUrl())
                                        .transform(new CenterCrop(), new RoundedCorners(4))
                                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                                        .into(holder.ivMergedGiftsLogo);
                            } else {
                                Glide.with(mContext)
                                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                                        .into(holder.ivMergedGiftsLogo);
                            }

                            holder.tvMergedGiftsTitle.setText(ccms.getTitle());
                            if (mergedgiftsItem.getCampaign().getIsNew())
                                holder.ivIsNew.setVisibility(View.VISIBLE);
                            else
                                holder.ivIsNew.setVisibility(View.GONE);
                            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(mergedgiftsItem));
                            return;
                        }
                    }
                    return;
                }

                if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                        if (ccms.getLoyaltyCampaignId().equals(mergedgiftsItem.getCampaign().getSessionUUID()) && ccms.getZone().equals("COSMOTE_APP_GIFTS4U")) {
                            if (!TextUtils.isEmpty(ccms.getImageUrl())) {
                                Glide.with(mContext)
                                        .load(ccms.getImageUrl())
                                        .transform(new CenterCrop(), new RoundedCorners(4))
                                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                                        .into(holder.ivMergedGiftsLogo);
                            } else {
                                Glide.with(mContext)
                                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                                        .into(holder.ivMergedGiftsLogo);
                            }

                            holder.tvMergedGiftsTitle.setText(ccms.getTitle());
                            if (mergedgiftsItem.getCampaign().getIsNew())
                                holder.ivIsNew.setVisibility(View.VISIBLE);
                            else
                                holder.ivIsNew.setVisibility(View.GONE);
                            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(mergedgiftsItem));
                            return;
                        }
                    }
                    return;
                }
            }


            if (!TextUtils.isEmpty(mergedgiftsItem.getCampaign().getLogoUrl())) {
                Glide.with(mContext)
                        .load(mergedgiftsItem.getCampaign().getLogoUrl())
                        .transform(new CenterCrop(), new RoundedCorners(4))
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivMergedGiftsLogo);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivMergedGiftsLogo);
            }

            holder.tvMergedGiftsTitle.setText(mergedgiftsItem.getCampaign().getTitle());

            if (mergedgiftsItem.getCampaign().getIsNew())
                holder.ivIsNew.setVisibility(View.VISIBLE);
            else
                holder.ivIsNew.setVisibility(View.GONE);
        } else if (mergedgiftsItem != null && mergedgiftsItem.getDataType() == 2) {
            if (!TextUtils.isEmpty(mergedgiftsItem.getSeasonalList().getImageUrl())) {
                Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                        .load(mergedgiftsItem.getSeasonalList().getImageUrl())
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivMergedGiftsLogo);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivMergedGiftsLogo);
            }

            holder.tvMergedGiftsTitle.setText(mergedgiftsItem.getSeasonalList().getTitle());
//            holder.tvMergedGiftsTitle.setText(HtmlCompat.fromHtml(mergedgiftsItem.getCouponset().getDescription(), HtmlCompat.FROM_HTML_MODE_COMPACT));

//            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
//            Date newDate = new Date();
//            try {
//                newDate = simpleDateFormat.parse(mergedgiftsItem.getExpiration());
//            } catch (ParseException e) {
//                e.printStackTrace();
//            }
//            simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
//            holder.tvCouponDate.setText(String.format(mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
//
//            holder.tvCouponValue.setText(mergedgiftsItem.getDiscount());
        } else if (mergedgiftsItem != null && mergedgiftsItem.getDataType() == 3) {
            if (!TextUtils.isEmpty(mergedgiftsItem.getCCMS().getImageUrl())) {
                Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                        .load(mergedgiftsItem.getCCMS().getImageUrl())
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivMergedGiftsLogo);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivMergedGiftsLogo);
            }

            holder.tvMergedGiftsTitle.setText(mergedgiftsItem.getCCMS().getTitle());
        }
        holder.itemView.setOnClickListener(v -> onClickSubject.onNext(mergedgiftsItem));
    }

    public Observable<MergedGifts> getPositionClicks() {
        return onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }
}
