package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.MergedMore;

public class MergedMoreAdapter extends RecyclerView.Adapter<MergedMoreAdapter.MergedMoreViewHolder> {

    private Context mContext;
    private ArrayList<MergedMore> mMergedMore;
    private final PublishSubject<MergedMore> onClickSubject = PublishSubject.create();

    public MergedMoreAdapter(Context mContext, ArrayList<MergedMore> mergedmore) {
        this.mContext = mContext;
        this.mMergedMore = mergedmore;
    }

    public class MergedMoreViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivCampaignTitle, ivIsNew;
        private TextView tvCampaignTitle, tvCampaignSubtitle, tvCampaignMessage;

        public MergedMoreViewHolder(View view) {
            super(view);
            ivCampaignTitle = view.findViewById(R.id.iv_campaign_logo);
            tvCampaignTitle = view.findViewById(R.id.tv_campaign_title);
            ivIsNew = view.findViewById(R.id.iv_campaign_new);
            tvCampaignSubtitle = view.findViewById(R.id.tv_campaign_subtitle);
            tvCampaignMessage = view.findViewById(R.id.tv_campaign_message);
        }
    }

    @Override
    public int getItemCount() {
        if (mMergedMore == null)
            return 0;
        else
            return mMergedMore.size();
    }


    public MergedMore getItem(int id) {
        return mMergedMore.get(id);
    }

    public void updateData(ArrayList<MergedMore> mergedmore) {
        mMergedMore.clear();
        mMergedMore.addAll(mergedmore);
        notifyDataSetChanged();
    }


    @Override
    public MergedMoreViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;
        itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_profile_recycler_vertical, parent, false);
        return new MergedMoreViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final MergedMoreViewHolder holder, int position) {
        MergedMore mergedmoreItem = mMergedMore.get(position);
        if (mergedmoreItem != null && mergedmoreItem.getDataType() == 1) {
            if (!TextUtils.isEmpty(mergedmoreItem.getCampaign().getLogoUrl())) {
                Glide.with(mContext)
                        .load(mergedmoreItem.getCampaign().getLogoUrl())
                        .transform(new CenterCrop(), new RoundedCorners(4))
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivCampaignTitle);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivCampaignTitle);
            }

            holder.tvCampaignTitle.setText(mergedmoreItem.getCampaign().getTitle());
            holder.tvCampaignSubtitle.setText(mergedmoreItem.getCampaign().getSubtitle());
            holder.tvCampaignMessage.setText(mergedmoreItem.getCampaign().getMessage());
            if (mergedmoreItem.getCampaign().getIsNew())
                holder.ivIsNew.setVisibility(View.VISIBLE);
            else
                holder.ivIsNew.setVisibility(View.GONE);
        } else if (mergedmoreItem != null && mergedmoreItem.getDataType() == 2) {
            if (!TextUtils.isEmpty(mergedmoreItem.getCCMS().getImageUrl())) {
                Glide.with(mContext)
                        .load(mergedmoreItem.getCCMS().getImageUrl())
                        .transform(new CenterCrop(), new RoundedCorners(4))
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivCampaignTitle);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivCampaignTitle);
            }

            holder.tvCampaignTitle.setText(mergedmoreItem.getCCMS().getTitle());
            holder.tvCampaignSubtitle.setText(mergedmoreItem.getCCMS().getSubtitle());
            holder.tvCampaignMessage.setText(mergedmoreItem.getCCMS().getMessage());
            holder.ivIsNew.setVisibility(View.GONE);
        }
        holder.itemView.setOnClickListener(v -> onClickSubject.onNext(mergedmoreItem));
    }

    public Observable<MergedMore> getPositionClicks() {
        return onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }
}
