package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;

import org.json.JSONObject;

import java.util.ArrayList;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarplyManagerHelper;

public class MoreCampaignAdapter extends RecyclerView.Adapter<MoreCampaignAdapter.MoreCampaignViewHolder> {

    private Context mContext;
    private ArrayList<Campaign> mCampaigns = new ArrayList<>();
    private final PublishSubject<Campaign> onClickSubject = PublishSubject.create();

    public MoreCampaignAdapter(Context mContext, ArrayList<Campaign> campaignList) {
        this.mContext = mContext;
        this.mCampaigns.clear();
        this.mCampaigns.addAll(campaignList);
    }

    public class MoreCampaignViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivCampaignTitle, ivIsNew;
        private TextView tvCampaignTitle, tvCampaignSubtitle, tvCampaignMessage;

        public MoreCampaignViewHolder(View view) {
            super(view);
            ivCampaignTitle = view.findViewById(R.id.iv_campaign_logo);
            tvCampaignTitle = view.findViewById(R.id.tv_campaign_title);
            ivIsNew = view.findViewById(R.id.iv_campaign_new);
            tvCampaignSubtitle = view.findViewById(R.id.tv_campaign_subtitle);
            tvCampaignMessage = view.findViewById(R.id.tv_campaign_message);
        }
    }

    @Override
    public int getItemCount() {
        if (mCampaigns == null)
            return 0;
        else
            return mCampaigns.size();
    }


    public Campaign getItem(int id) {
        return mCampaigns.get(id);
    }

    public void updateData(ArrayList<Campaign> campaignList) {
        mCampaigns.clear();
        mCampaigns.addAll(campaignList);
        notifyDataSetChanged();
    }

    @Override
    public long getItemId(int position) {
//        return super.getItemId(position);
        return Double.valueOf(Math.random()).longValue();
    }

    @Override
    public MoreCampaignViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;

        itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_profile_recycler_vertical, parent, false);
        return new MoreCampaignViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final MoreCampaignViewHolder holder, int position) {
        Campaign campaignItem = mCampaigns.get(position);

        if (campaignItem != null) {
            JSONObject extraFields = WarpJSONParser.getJSONFromString(campaignItem.getExtraFields());
            if (extraFields != null) {
                if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                        if (ccms.getLoyaltyCampaignId().equals(campaignItem.getSessionUUID()) && ccms.getZone().equals("COSMOTE_APP_MORE4U")) {
                            if (!TextUtils.isEmpty(ccms.getImageUrl())) {
                                Glide.with(mContext)
                                        .load(ccms.getImageUrl())
                                        .transform(new CenterCrop(), new RoundedCorners(4))
                                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                                        .into(holder.ivCampaignTitle);
                            } else {
                                Glide.with(mContext)
                                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                                        .into(holder.ivCampaignTitle);
                            }

                            holder.tvCampaignTitle.setText(ccms.getTitle());
                            holder.tvCampaignSubtitle.setText(ccms.getSubtitle());
                            holder.tvCampaignMessage.setText(ccms.getMessage());
                            if (campaignItem.getIsNew())
                                holder.ivIsNew.setVisibility(View.VISIBLE);
                            else
                                holder.ivIsNew.setVisibility(View.GONE);

                            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(campaignItem));
                            return;
                        }
                    }
                    return;
                }
            }


            if (!TextUtils.isEmpty(campaignItem.getLogoUrl())) {
                Glide.with(mContext)
                        .load(campaignItem.getLogoUrl())
                        .transform(new CenterCrop(), new RoundedCorners(4))
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivCampaignTitle);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivCampaignTitle);
            }

            holder.tvCampaignTitle.setText(campaignItem.getTitle());
            holder.tvCampaignSubtitle.setText(campaignItem.getSubtitle());
            holder.tvCampaignMessage.setText(campaignItem.getMessage());
            if (campaignItem.getIsNew())
                holder.ivIsNew.setVisibility(View.VISIBLE);
            else
                holder.ivIsNew.setVisibility(View.GONE);

            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(campaignItem));
        }
    }

    public Observable<Campaign> getPositionClicks() {
        return onClickSubject.cache();
    }

}
