package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;

import java.util.ArrayList;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;

public class MoreContextualAdapter extends RecyclerView.Adapter<MoreContextualAdapter.MoreContextualViewHolder> {

    private Context mContext;
    private ArrayList<LoyaltyContextualOfferModel> mCampaigns = new ArrayList<>();
    private final PublishSubject<LoyaltyContextualOfferModel> onClickSubject = PublishSubject.create();

    public MoreContextualAdapter(Context mContext, ArrayList<LoyaltyContextualOfferModel> campaignList) {
        this.mContext = mContext;
        this.mCampaigns.clear();
        this.mCampaigns.addAll(campaignList);
    }

    public class MoreContextualViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivCampaignTitle, ivIsNew;
        private TextView tvCampaignTitle, tvCampaignSubtitle, tvCampaignMessage;

        public MoreContextualViewHolder(View view) {
            super(view);
            ivCampaignTitle = view.findViewById(R.id.iv_campaign_logo);
            tvCampaignTitle = view.findViewById(R.id.tv_campaign_title);
            ivIsNew = view.findViewById(R.id.iv_campaign_new);
            tvCampaignSubtitle = view.findViewById(R.id.tv_campaign_subtitle);
            tvCampaignMessage = view.findViewById(R.id.tv_campaign_message);
        }
    }

    @Override
    public int getItemCount() {
        if (mCampaigns == null)
            return 0;
        else
            return mCampaigns.size();
    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    public LoyaltyContextualOfferModel getItem(int id) {
        return mCampaigns.get(id);
    }

    public void updateData(ArrayList<LoyaltyContextualOfferModel> campaignList) {
        mCampaigns.clear();
        mCampaigns.addAll(campaignList);
        notifyDataSetChanged();
    }

    @Override
    public MoreContextualViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;

        itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_profile_recycler_vertical, parent, false);
        return new MoreContextualViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final MoreContextualViewHolder holder, int position) {
        LoyaltyContextualOfferModel campaignItem = mCampaigns.get(position);

        if (campaignItem != null) {
            if (!TextUtils.isEmpty(campaignItem.getImageUrl())) {
                Glide.with(mContext)
                        .load(campaignItem.getImageUrl())
                        .transform(new CenterCrop(), new RoundedCorners(4))
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivCampaignTitle);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivCampaignTitle);
            }

            holder.tvCampaignTitle.setText(campaignItem.getTitle());
            holder.tvCampaignSubtitle.setText(campaignItem.getSubtitle());
            holder.tvCampaignMessage.setText(campaignItem.getMessage());
            holder.ivIsNew.setVisibility(View.GONE);

            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(campaignItem));
        }
    }

    public Observable<LoyaltyContextualOfferModel> getPositionClicks() {
        return onClickSubject.cache();
    }

}
