package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;


public class ProfileCampaignAdapter extends RecyclerView.Adapter<ProfileCampaignAdapter.ProfileCampaignViewHolder> {

    private Context mContext;
    private CampaignList mCampaigns;
    private final PublishSubject<Campaign> onClickSubject = PublishSubject.create();
    private boolean mIsVertical = false;

    public ProfileCampaignAdapter(Context mContext, CampaignList campaignList) {
        this.mContext = mContext;
        this.mCampaigns = campaignList;
        this.mIsVertical = false;
    }

    public ProfileCampaignAdapter(Context mContext, CampaignList campaignList, boolean vertical) {
        this.mContext = mContext;
        this.mCampaigns = campaignList;
        this.mIsVertical = vertical;
    }

    public class ProfileCampaignViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivCampaignTitle, ivIsNew;
        private TextView tvCampaignTitle, tvCampaignSubtitle, tvCampaignMessage;

        public ProfileCampaignViewHolder(View view) {
            super(view);
            ivCampaignTitle = view.findViewById(R.id.iv_campaign_logo);
            tvCampaignTitle = view.findViewById(R.id.tv_campaign_title);
        }

        public ProfileCampaignViewHolder(View view, boolean vertical) {
            super(view);
            ivCampaignTitle = view.findViewById(R.id.iv_campaign_logo);
            tvCampaignTitle = view.findViewById(R.id.tv_campaign_title);
            ivIsNew = view.findViewById(R.id.iv_campaign_new);
            if (vertical) {
                tvCampaignSubtitle = view.findViewById(R.id.tv_campaign_subtitle);
                tvCampaignMessage = view.findViewById(R.id.tv_campaign_message);
            }
        }
    }

    @Override
    public int getItemCount() {
        if (mCampaigns == null)
            return 0;
        else
            return mCampaigns.size();
    }


    public Campaign getItem(int id) {
        return mCampaigns.get(id);
    }

    public void updateData(CampaignList campaignList) {
        mCampaigns.clear();
        mCampaigns.addAll(campaignList);
        notifyDataSetChanged();
    }

    @Override
    public ProfileCampaignViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;
        if (!mIsVertical) {
            itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_profile_recycler, parent, false);
            return new ProfileCampaignViewHolder(itemView);
        } else {
            itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_profile_recycler_vertical, parent, false);
            return new ProfileCampaignViewHolder(itemView, true);
        }
    }

    @Override
    public void onBindViewHolder(final ProfileCampaignViewHolder holder, int position) {
        Campaign campaignItem = mCampaigns.get(position);

        if (campaignItem != null) {
            if (!TextUtils.isEmpty(campaignItem.getLogoUrl())) {
                Glide.with(mContext)
                        .load(campaignItem.getLogoUrl())
                        .transform(new CenterCrop(), new RoundedCorners(4))
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(holder.ivCampaignTitle);
            } else {
                Glide.with(mContext)
                        .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                        .into(holder.ivCampaignTitle);
            }

            holder.tvCampaignTitle.setText(campaignItem.getTitle());
            if (mIsVertical) {
                holder.tvCampaignSubtitle.setText(campaignItem.getSubtitle());
                holder.tvCampaignMessage.setText(campaignItem.getMessage());
                if (campaignItem.getIsNew())
                    holder.ivIsNew.setVisibility(View.VISIBLE);
                else
                    holder.ivIsNew.setVisibility(View.GONE);
            }

            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(campaignItem));
        }
    }

    public Observable<Campaign> getPositionClicks() {
        return onClickSubject.cache();
    }

}
