package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;

import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Merchant;
import ly.warp.sdk.io.models.SharingCoupon;
import ly.warp.sdk.io.models.SharingList;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarplyManagerHelper;

public class SharedCouponAdapter extends RecyclerView.Adapter<SharedCouponAdapter.SharedCouponViewHolder> {

    private Context mContext;
    private /*SharingList*/ ArrayList<SharingCoupon> mCoupons;
    private final PublishSubject<SharingCoupon> onClickSubject = PublishSubject.create();

    public SharedCouponAdapter(Context mContext, SharingList campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
    }

    public SharedCouponAdapter(Context mContext, ArrayList<SharingCoupon> campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
    }

    public class SharedCouponViewHolder extends RecyclerView.ViewHolder {
        private TextView tvCouponTitle, tvCouponValue, tvCouponDate, tvCouponLabel, tvCouponPhone;
        private ImageView ivCouponLogo;

        public SharedCouponViewHolder(View view) {
            super(view);
            tvCouponTitle = view.findViewById(R.id.tv_shared_coupons_title);
            tvCouponValue = view.findViewById(R.id.tv_shared_coupons_value);
            tvCouponDate = view.findViewById(R.id.tv_shared_coupons_date);
            tvCouponLabel = view.findViewById(R.id.tv_shared_coupons_label);
            tvCouponPhone = view.findViewById(R.id.tv_shared_coupons_phone);
            ivCouponLogo = view.findViewById(R.id.iv_shared_logo);
        }
    }

    @Override
    public int getItemCount() {
        if (mCoupons == null)
            return 0;
        else
            return mCoupons.size();
    }


    public SharingCoupon getItem(int id) {
        return mCoupons.get(id);
    }

    public void updateData(SharingList couponList) {
        mCoupons.clear();
        mCoupons.addAll(couponList);
        notifyDataSetChanged();
    }


    @Override
    public SharedCouponViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView;
        itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.shared_coupon_layout, parent, false);
        return new SharedCouponViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final SharedCouponViewHolder holder, int position) {
        SharingCoupon couponItem = mCoupons.get(position);
        Merchant merchant = new Merchant();

        if (couponItem != null) {
            if (WarplyManagerHelper.getMerchantList() != null && WarplyManagerHelper.getMerchantList().size() > 0) {
                for (Merchant mer : WarplyManagerHelper.getMerchantList()) {
                    if (mer.getUuid().equals(couponItem.getMerchantUuid())) {
                        merchant = mer;
                        break;
                    }
                }
            }

            if (merchant == null) {
                holder.tvCouponTitle.setText(couponItem.getName());
            } else {
                holder.tvCouponTitle.setText(merchant.getAdminName());
                if (!TextUtils.isEmpty(merchant.getImgPreview())) {
                    Glide.with(mContext)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                            .load(merchant.getImgPreview())
                            .diskCacheStrategy(DiskCacheStrategy.DATA)
                            .into(holder.ivCouponLogo);
                }
            }

            JSONObject extraFields = WarpJSONParser.getJSONFromString(couponItem.getTransactionMetadata());

            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss", Locale.US);
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(couponItem.getDate());
            } catch (ParseException e) {
                e.printStackTrace();
            }
            simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            holder.tvCouponDate.setText(simpleDateFormat.format(newDate != null ? newDate : ""));

            if (couponItem.getSharingType().equals("sent")) {
                holder.tvCouponLabel.setText(R.string.cos_shared_coupon_receiver);
                if (extraFields != null && extraFields.has("receiver_msisdn")) {
                    holder.tvCouponPhone.setText(extraFields.optString("receiver_msisdn"));
                }
            } else if (couponItem.getSharingType().equals("received")) {
                holder.tvCouponLabel.setText(R.string.cos_shared_coupon_sender);
                if (extraFields != null && extraFields.has("sender_msisdn")) {
                    holder.tvCouponPhone.setText(extraFields.optString("sender_msisdn"));
                }
            }

            String itemValue = String.format("%.02f", couponItem.getFinal_price());
            holder.tvCouponValue.setText(itemValue + mContext.getResources().getString(R.string.euro));
            holder.itemView.setOnClickListener(v -> onClickSubject.onNext(couponItem));
        }
    }

    public Observable<SharingCoupon> getPositionClicks() {
        return onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }
}
