package ly.warp.sdk.views.dialogs;

import android.content.Context;

import androidx.appcompat.app.AlertDialog;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;

import ly.warp.sdk.R;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.Campaign;

/**
 * Created by Panagiotis Triantafyllou on 28-Mar-19.
 */

public class InAppDialog {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private static Context mContext;
    private static AlertDialog mInAppDialog;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    // ===========================================================
    // Methods
    // ===========================================================

    public static void showDefaultInAppDialog(Context context, Campaign campaignToShow, boolean showViewBtn, int v) {
        mContext = context;
        showDefaultInAppDialog(context, campaignToShow, showViewBtn);
    }

    private static void showDefaultInAppDialog(final Context context, final Campaign campaignToShow, boolean showViewBtn) {
        if (mInAppDialog != null && mInAppDialog.isShowing()) {
            mInAppDialog.dismiss();
        }

        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View customView = inflater.inflate(R.layout.layout_inapp_alert_dialog_default, null);

        LinearLayout customButtonsView = customView.findViewById(R.id.ll_custom_buttons_view);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        params.gravity = Gravity.RIGHT | Gravity.END;

        ImageView campaignImage = customView.findViewById(R.id.iv_inapp_image);
        TextView campaignTitle = customView.findViewById(R.id.tv_inapp_title);
        TextView campaignSubtitle = customView.findViewById(R.id.tv_inapp_subtitle);

        Glide
                .with(context)
                .load(campaignToShow.getLogoUrl())
                .placeholder(R.drawable.ic_default_campaign)
                .into(campaignImage);
        campaignTitle.setText(campaignToShow.getTitle());
        campaignSubtitle.setText(campaignToShow.getSubtitle());

        if (showViewBtn) {
            String[] items = {"View", "Close"};
            TextView viewBtn = new TextView(context);
            viewBtn.setId(0);
            viewBtn.setTag(items[0]);
            viewBtn.setText(items[0]);
            viewBtn.setTextAppearance(context, R.style.InAppButtonsStyle);
            viewBtn.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    context.startActivity(WarpViewActivity.createIntentFromSessionUUID(mContext,
                            campaignToShow.getSessionUUID()));
                    mInAppDialog.dismiss();
                }
            });
            customButtonsView.addView(viewBtn, params);

//            dialog.setItems(items, new DialogInterface.OnClickListener() {
//                public void onClick(DialogInterface dialog, int which) {
//                    switch (which) {
//                        case 0:
//                            context.startActivity(WarpViewActivity.createIntentFromSessionUUID(context,
//                                    campaignToShow.getSessionUUID()));
//                            break;
//
//                        case 1:
//                            break;
//                    }
//                }
//            });
            mInAppDialog = new AlertDialog.Builder(context)
                    .setView(customView)
                    .create();
            mInAppDialog.show();
        } else {
//            AlertDialog.Builder dialog = new AlertDialog.Builder(context);
//            mInAppDialog.setView(customView);
//            mInAppDialog.setNegativeButton("Close", new DialogInterface.OnClickListener() {
//                public void onClick(DialogInterface dialog, int id) {
//                }
//            });
//            mInAppDialog = new AlertDialog.Builder(context)
//                    .create();
//            mInAppDialog.show();
        }
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================
}
