package ly.warp.sdk.views.dialogs;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import static ly.warp.sdk.utils.constants.WarpConstants.PACKAGE_ADDRESS_GOOGLE;

final class IntentHelper {

    private static final String GOOGLE_PLAY_PACKAGE_NAME = "com.android.vending";

    private IntentHelper() {
    }

    static Uri getGooglePlay(String packageName) {
        return packageName == null ? null : Uri.parse(PACKAGE_ADDRESS_GOOGLE + packageName);
    }

    static Intent createIntentForGooglePlay(Context context) {
        Intent intent = new Intent(Intent.ACTION_VIEW, getGooglePlay(context.getPackageName()));
        intent.setPackage(GOOGLE_PLAY_PACKAGE_NAME);
        return intent;
    }
}